/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.EnrichedBlueprintRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintPermissions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintRoleAssignments;
import com.dataiku.gh.core.storage.sql.model.QBlueprints;
import com.dataiku.gh.core.storage.sql.model.QBlueprintsHistory;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintDAO
extends AbstractItemBasedDAO<String, Blueprint, EnrichedBlueprint>
implements IBlueprintDAO {
    @Autowired
    private EnrichedBlueprintRowMapper enrichedBlueprintRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT;
    }

    @Override
    protected RowMapper<EnrichedBlueprint> getRowMapper() {
        return this.enrichedBlueprintRowMapper;
    }

    @Override
    protected String getId(Blueprint item) {
        return item.id;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QBlueprints.blueprints;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QBlueprints.blueprints.blueprintJson;
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QBlueprintsHistory.blueprintsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QBlueprintsHistory.blueprintsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QBlueprintsHistory.blueprintsHistory.blueprintJson;
    }

    @Override
    protected Predicate getIdCondition(String id) {
        return QBlueprints.blueprints.blueprintId.eq((Object)id);
    }

    @Override
    protected SQLQuery<?> buildBaseSelectQuery() {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.from((Expression)QBlueprints.blueprints)).leftJoin((EntityPath)QBlueprintRoleAssignments.blueprintRoleAssignments)).on((Predicate)QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).leftJoin((EntityPath)QBlueprintPermissions.blueprintPermissions)).on((Predicate)QBlueprintPermissions.blueprintPermissions.blueprintPermissionsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).select(new Expression[]{QBlueprints.blueprints.blueprintJson, QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsJson, QBlueprintPermissions.blueprintPermissions.blueprintPermissionsJson});
    }
}

