/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.history;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.history.HistoryAction;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.history.IRevisionDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QHistoryActions;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class RevisionDAO
extends AbstractPostgreSQLClient
implements IRevisionDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.revisions");

    @Override
    @GHMandatoryTransaction
    public long newActionId() throws DataStoreIOException {
        return this.newId("history_actions_seq");
    }

    @Override
    @GHMandatoryTransaction
    public long newRevisionId() throws DataStoreIOException {
        return this.newId("history_revisions_seq");
    }

    @Override
    @GHMandatoryTransaction
    public void createHistoryAction(HistoryAction historyAction) throws DataStoreIOException {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QHistoryActions.historyActions).columns(new Path[]{QHistoryActions.historyActions.historyActionJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(historyAction)});
        if (this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query) != 1) {
            throw new DataStoreIOException("Cannot create history action " + historyAction.id);
        }
    }

    @Override
    @GHMandatoryTransaction
    public Map<ActionType, Long> getActionCounts() throws DataStoreIOException {
        try {
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QueryBuilderUtils.jsonString(QHistoryActions.historyActions.historyActionJson, new String[]{"type"}).as("type"), Wildcard.count.as("count")}).from((Expression)QHistoryActions.historyActions)).groupBy((Expression)QueryBuilderUtils.jsonString(QHistoryActions.historyActions.historyActionJson, new String[]{"type"}));
            return this.querydslJdbcTemplate.query(sqlQuery, (rs, rowNum) -> ImmutablePair.of((Object)rs.getString("type"), (Object)rs.getLong("count"))).stream().filter(p -> EnumUtils.isValidEnum(ActionType.class, (String)((String)p.getLeft()))).collect(Collectors.toMap(p -> ActionType.valueOf((String)p.getLeft()), Pair::getValue));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private long newId(String sequenceName) throws DataStoreIOException {
        try {
            SQLQuery sqlQuery = this.sqlQueryFactory.select((Expression)SQLExpressions.nextval((String)sequenceName));
            return this.querydslJdbcTemplate.queryForObject(sqlQuery, Long.class);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

