/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao.impl;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.AutoCloseInputStream;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.model.PublicUser;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedUsersDAO
implements UsersDAO {
    private static final RelFile usersFile = RelFile.global((String)"users.json");
    private final String defaultAdminGroupPrefix = "administrators";
    private Map<String, PublicUser> publicUsersCache;
    static DKULogger logger = DKULogger.getLogger((String)"dku.users.dao");

    @Override
    public List<UsersDAO.User> listUsers() throws IOException {
        return (List)JSON.deepCopy(this.listUsersUnsafe(), (TypeToken)new TypeToken<List<UsersDAO.User>>(){});
    }

    @Override
    public List<UsersDAO.User> listUsersUnsafe() throws IOException {
        return this.getData((boolean)true).users;
    }

    @Override
    public List<UsersDAO.Group> listGroups() throws IOException {
        return (List)JSON.deepCopy(this.listGroupsUnsafe(), (TypeToken)new TypeToken<List<UsersDAO.Group>>(){});
    }

    @Override
    public List<UsersDAO.Group> listGroupsUnsafe() throws IOException {
        return this.getData((boolean)true).groups;
    }

    @Override
    public UsersDAO.User getOrNull(String user) throws IOException {
        return (UsersDAO.User)JSON.deepCopy((Object)this.getOrNullUnsafe(user));
    }

    @Override
    public UsersDAO.User getOrNullUnsafe(String user) throws IOException {
        return this.getOrNull(user, this.getData(true));
    }

    @Override
    public UsersDAO.User getUserIgnoreCaseOrNull(String user) throws IOException {
        return (UsersDAO.User)JSON.deepCopy((Object)this.getUserIgnoreCaseOrNull(user, this.getData(true)));
    }

    private UsersDAO.User getUserIgnoreCaseOrNull(String login, UsersFile uf) {
        for (UsersDAO.User u : uf.users) {
            if (!u.login.equalsIgnoreCase(login)) continue;
            return u;
        }
        return null;
    }

    @Override
    public UsersDAO.User getMandatory(String user) throws IOException {
        return (UsersDAO.User)JSON.deepCopy((Object)this.getMandatoryUnsafe(user));
    }

    @Override
    public UsersDAO.User getMandatoryUnsafe(String user) throws IOException {
        return this.getMandatory(user, this.getData(true));
    }

    @Override
    public UsersDAO.Group getGroup(String name) throws IOException {
        return (UsersDAO.Group)JSON.deepCopy((Object)this.getGroupUnsafe(name));
    }

    @Override
    public UsersDAO.Group getGroupUnsafe(String name) throws IOException {
        return this.getGroup(name, this.getData(true));
    }

    @Override
    public UsersDAO.Group getGroupMandatory(String name) throws IOException {
        return (UsersDAO.Group)JSON.deepCopy((Object)this.getGroupMandatoryUnsafe(name));
    }

    @Override
    public UsersDAO.Group getGroupMandatoryUnsafe(String name) throws IOException {
        return this.getGroupMandatory(name, this.getData(true));
    }

    private UsersDAO.User getMandatory(String login, UsersFile uf) throws NotFoundException {
        UsersDAO.User u = this.getOrNull(login, uf);
        if (u == null) {
            throw new NotFoundException("User '" + login + "' doesn't exist");
        }
        return u;
    }

    private UsersDAO.User getOrNull(String login, UsersFile uf) {
        for (UsersDAO.User u : uf.users) {
            if (!u.login.equals(login)) continue;
            return u;
        }
        return null;
    }

    private UsersDAO.Group getGroupMandatory(String name, UsersFile uf) throws NotFoundException {
        UsersDAO.Group g = this.getGroup(name, uf);
        if (g == null) {
            throw new NotFoundException("Group '" + name + "' doesn't exist");
        }
        return g;
    }

    private UsersDAO.Group getGroup(String name, UsersFile uf) {
        for (UsersDAO.Group g : uf.groups) {
            if (!g.name.equals(name)) continue;
            return g;
        }
        return null;
    }

    private UsersFile getData(boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(usersFile)) {
            return new UsersFile();
        }
        if (unsafe) {
            return (UsersFile)t.readObjectUnsafe(usersFile, UsersFile.class);
        }
        return (UsersFile)t.readObject(usersFile, UsersFile.class);
    }

    @Override
    public GroupDiff saveGroup(UsersDAO.Group group) throws IOException {
        UsersFile uf = this.getData(false);
        UsersDAO.Group oldGroup = null;
        boolean updated = false;
        for (int i = 0; i < uf.groups.size(); ++i) {
            UsersDAO.Group current = uf.groups.get(i);
            if (!current.name.equals(group.name)) continue;
            oldGroup = current;
            uf.groups.set(i, group);
            updated = true;
            break;
        }
        if (!updated) {
            uf.groups.add(group);
        }
        Gson gson = new Gson();
        JsonObject oldJson = oldGroup == null ? new JsonObject() : gson.toJsonTree(oldGroup).getAsJsonObject();
        JsonObject newJson = gson.toJsonTree((Object)group).getAsJsonObject();
        GroupDiff groupDiff = GroupDiff.calculateDiff((JsonObject)oldJson, (JsonObject)newJson);
        this.saveData(uf);
        if (updated) {
            this.onGroupSave(group);
        } else {
            this.onGroupCreate(group);
        }
        return groupDiff;
    }

    @Override
    public UsersDAO.Group addGroup(String name, UserSourceType sourceType) throws IOException, CodedException {
        if (this.getGroup(name) == null) {
            UsersDAO.Group g = new UsersDAO.Group();
            g.name = name;
            g.description = "";
            g.sourceType = sourceType;
            this.saveGroup(g);
            return g;
        }
        throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_GROUP_EXISTS, "Group " + name + " already exists");
    }

    @Override
    public UsersDAO.Group addGroup(UsersDAO.Group group) throws IOException, CodedException {
        if (this.getGroup(group.name) == null) {
            this.saveGroup(group);
            return group;
        }
        throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_GROUP_EXISTS, "Group " + group.name + " already exists");
    }

    @Override
    public void deleteGroup(String name) throws IOException {
        UsersFile uf = this.getData(false);
        UsersDAO.Group g = this.getGroupMandatory(name, uf);
        uf.groups.remove(g);
        this.saveData(uf);
        this.onGroupDelete(name);
    }

    @Override
    public UsersDAO.Group getDefaultAdminGroup(boolean create) throws IOException, CodedException {
        Object name = "administrators";
        UsersDAO.Group g = this.getGroup((String)name);
        if (g != null && !g.isAdmin()) {
            DecimalFormat fmt = new DecimalFormat("_00");
            for (int i = 0; i < 100 && (g = this.getGroup((String)(name = "administrators" + fmt.format(i)))) != null && !g.isAdmin(); ++i) {
            }
        }
        if (g != null && g.isAdmin()) {
            return g;
        }
        if (g == null && create) {
            g = new UsersDAO.Group();
            g.name = name;
            g.description = "Default group for Dataiku Govern administrators";
            g.withAdmin(true);
            return this.addGroup(g);
        }
        return null;
    }

    @Override
    public boolean checkLogin(String user, String password) throws IOException, CodedException {
        UsersFile uf = this.getData(true);
        UsersDAO.User u = this.getOrNull(user, uf);
        if (u == null) {
            System.err.println("User not found");
            return false;
        }
        return u.sourceType == UserSourceType.LOCAL && u.checkPassword(password);
    }

    @Override
    public boolean checkLoginIgnoreCase(String user, String password) throws IOException, CodedException {
        UsersFile uf = this.getData(true);
        UsersDAO.User u = this.getUserIgnoreCaseOrNull(user, uf);
        if (u == null) {
            System.err.println("User not found");
            return false;
        }
        return u.sourceType == UserSourceType.LOCAL && u.checkPassword(password);
    }

    @Override
    public UserDiff saveUser(UsersDAO.User updatedUser) throws IOException {
        UsersFile uf = this.getData(false);
        UsersDAO.User oldUser = null;
        boolean updated = false;
        for (int i = 0; i < uf.users.size(); ++i) {
            UsersDAO.User current = uf.users.get(i);
            if (!current.login.equals(updatedUser.login)) continue;
            oldUser = current;
            uf.users.set(i, updatedUser);
            updated = true;
            break;
        }
        if (!updated) {
            uf.users.add(updatedUser);
        }
        Gson gson = new Gson();
        JsonObject oldJson = oldUser == null ? new JsonObject() : gson.toJsonTree(oldUser).getAsJsonObject();
        JsonObject newJson = gson.toJsonTree((Object)updatedUser).getAsJsonObject();
        UserDiff userDiff = UserDiff.calculateDiff((JsonObject)oldJson, (JsonObject)newJson);
        this.saveData(uf);
        if (updated) {
            this.onUserSave(updatedUser);
        } else {
            this.onUserCreate(updatedUser);
        }
        return userDiff;
    }

    @Override
    public void deleteUser(String login) throws IOException {
        UsersFile uf = this.getData(false);
        UsersDAO.User u = this.getMandatory(login, uf);
        uf.users.remove(u);
        this.saveData(uf);
        this.onUserDelete(login);
    }

    @Override
    public void forceDeleteUser(String login) throws IOException {
        try {
            this.deleteUser(login);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public InputStream getUserPicture(String login, String size) throws IOException {
        File pic = this.pictureFile(login, size);
        if (pic.exists()) {
            return new AutoCloseInputStream((InputStream)FileUtils.openInputStream((File)pic));
        }
        return null;
    }

    @Override
    public void setUserPicture(String login, InputStream imgData, String size) throws IOException {
        File picFile;
        if (!this.getPicsDir().exists()) {
            this.getPicsDir().mkdir();
        }
        if ((picFile = this.pictureFile(login, size)).exists()) {
            DKUFileUtils.forceDelete((File)picFile);
        }
        if (imgData != null) {
            File writeTo = this.pictureFile(login, size);
            DKUFileUtils.mkdirsParent((File)writeTo);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)imgData, (OutputStream)baos);
            FileUtils.writeByteArrayToFile((File)writeTo, (byte[])baos.toByteArray());
        }
    }

    @Override
    public void clearUserPictures(String login) throws IOException {
        File imgFolder = this.userPictureFolder(login);
        if (imgFolder.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)imgFolder);
        }
    }

    private void reloadPublicUsersCache() {
        try {
            HashMap<String, PublicUser> newPublicUsersCache = new HashMap<String, PublicUser>();
            for (UsersDAO.User u : this.getData((boolean)true).users) {
                PublicUser pu = new PublicUser();
                pu.login = u.login;
                pu.displayName = u.displayName;
                pu.email = u.email;
                pu.sourceType = u.sourceType;
                newPublicUsersCache.put(u.login, pu);
            }
            this.publicUsersCache = newPublicUsersCache;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read users file", (Throwable)e);
        }
    }

    @Override
    public PublicUser getPublicUser(String login) throws IOException {
        if (login == null) {
            PublicUser pu = new PublicUser();
            pu.displayName = "DataikuGovern";
            return pu;
        }
        if (this.publicUsersCache == null) {
            this.reloadPublicUsersCache();
        }
        if (this.publicUsersCache.get(login) != null) {
            return this.publicUsersCache.get(login);
        }
        PublicUser pu = new PublicUser();
        pu.login = login;
        pu.displayName = login + " (deleted)";
        return pu;
    }

    @Override
    public List<PublicUser> getPublicUsers(Collection<String> logins) throws IOException {
        ArrayList<PublicUser> ret = new ArrayList<PublicUser>();
        for (String login : logins) {
            ret.add(this.getPublicUser(login));
        }
        return ret;
    }

    private File pictureFile(String login, String size) {
        return new File(this.userPictureFolder(login), "profile-" + size + ".png");
    }

    private File userPictureFolder(String login) {
        assert (!StringUtils.isBlank((String)login));
        return new File(this.getPicsDir(), "user-" + login);
    }

    private File getPicsDir() {
        return new File(ApplicationConfigurator.getBaseFolderF(), "user_data/pics/");
    }

    private void saveData(UsersFile data) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(usersFile, (Object)data);
        this.reloadPublicUsersCache();
    }

    private void onUserCreate(UsersDAO.User user) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onUserCreate(user);
        }
    }

    private void onUserSave(UsersDAO.User user) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onUserSave(user);
        }
    }

    private void onUserDelete(String login) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onUserDelete(login);
        }
    }

    private void onGroupCreate(UsersDAO.Group group) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGroupCreate(group);
        }
    }

    private void onGroupSave(UsersDAO.Group group) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGroupSave(group);
        }
    }

    private void onGroupDelete(String groupName) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGroupDelete(groupName);
        }
    }

    private static class UsersFile {
        public List<UsersDAO.User> users = new ArrayList<UsersDAO.User>();
        public List<UsersDAO.Group> groups = new ArrayList<UsersDAO.Group>();

        private UsersFile() {
        }
    }
}

