/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security.azure;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.azure.AzureADUserSupplier;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GHAzureADUserSupplier
extends AzureADUserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private ProxySettings proxySettings;

    @Autowired
    public GHAzureADUserSupplier(GeneralSettingsDAO generalSettingsDao, PubSubService pubSubService, PasswordEncryptionService symetricCryptoService) {
        super(symetricCryptoService);
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.azureADSettings = settings.azureADSettings;
        this.proxySettings = settings.proxySettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDao.getUnsafeAutoTXN();
                this.azureADSettings = generalSettings.azureADSettings;
                this.proxySettings = generalSettings.proxySettings;
                this.onRefreshSettings();
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }

    public GHAzureADUserSupplier(PasswordEncryptionService symetricCryptoService, AzureADSettings azureADSettings) {
        super(symetricCryptoService);
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.azureADSettings = azureADSettings;
        this.proxySettings = generalSettings.proxySettings;
    }

    public ProxySettings getProxySetting() {
        return this.azureADSettings.useGlobalProxy ? this.proxySettings : new ProxySettings();
    }
}

