/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.google.common.base.Joiner;
import com.twitter.hbc.core.Constants;
import com.twitter.hbc.core.endpoint.BaseEndpoint;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import java.util.List;

public class DefaultStreamingEndpoint
extends BaseEndpoint
implements StreamingEndpoint {
    protected final boolean backfillable;
    private volatile boolean delimited;
    private volatile boolean stallWarnings;

    public DefaultStreamingEndpoint(String path, String httpMethod, boolean backfillable) {
        super(path, httpMethod);
        this.backfillable = backfillable;
        this.delimited = true;
        this.stallWarnings = true;
    }

    public boolean isBackfillable() {
        return this.backfillable;
    }

    @Override
    protected void addDefaultParams() {
        if (this.delimited) {
            this.addQueryParameter("delimited", "length");
        } else {
            this.removeQueryParameter("delimited");
        }
        if (this.stallWarnings) {
            this.addQueryParameter("stall_warnings", "true");
        } else {
            this.removeQueryParameter("stall_warnings");
        }
    }

    public final void delimited(boolean on) {
        this.delimited = on;
    }

    public final void stallWarnings(boolean on) {
        this.stallWarnings = on;
    }

    @Override
    public final void setBackfillCount(int backfillCount) {
        if (this.isBackfillable()) {
            if (backfillCount != 0) {
                this.addQueryParameter("count", Integer.toString(backfillCount));
            } else {
                this.removeQueryParameter("count");
            }
        }
    }

    public DefaultStreamingEndpoint languages(List<String> languages) {
        this.addPostParameter("language", Joiner.on((char)',').join(languages));
        return this;
    }

    public DefaultStreamingEndpoint filterLevel(Constants.FilterLevel filterLevel) {
        this.addPostParameter("filter_level", filterLevel.asParameter());
        return this;
    }
}

