/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.ShortType;
import java.util.Objects;
import java.util.Optional;

public class DefaultShortVector
extends AbstractColumnVector {
    private final short[] values;

    public DefaultShortVector(int n, Optional<boolean[]> optional, short[] sArray) {
        super(n, (DataType)ShortType.SHORT, optional);
        this.values = Objects.requireNonNull(sArray, "values is null");
        Preconditions.checkArgument((sArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{sArray.length, n});
    }

    @Override
    public short getShort(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

