/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.defaults.internal.data.DefaultColumnarBatch;
import io.delta.kernel.defaults.internal.data.vector.DefaultStructVector;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

class RowColumnReader
extends GroupConverter
implements ParquetColumnReaders.BaseColumnReader {
    private final StructType readSchema;
    private final Converter[] converters;
    private final Map<Integer, Integer> parquetOrdinalToConverterOrdinal;
    private boolean isCurrentValueNull = true;
    private int currentRowIndex;
    private boolean[] nullability;

    RowColumnReader(int n, StructType structType, GroupType groupType) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"invalid initialBatchSize: %s", (Object[])new Object[]{n});
        this.readSchema = Objects.requireNonNull(structType, "readSchema is not null");
        List list = structType.fields();
        this.converters = new Converter[list.size()];
        this.parquetOrdinalToConverterOrdinal = new HashMap<Integer, Integer>();
        this.nullability = ParquetColumnReaders.initNullabilityVector(n);
        int n2 = 0;
        for (int i = 0; i < this.converters.length; ++i) {
            Type type;
            StructField structField = (StructField)list.get(i);
            DataType dataType = structField.getDataType();
            Map<Integer, Type> map = ParquetSchemaUtils.getParquetFieldToTypeMap(groupType);
            Type type2 = type = structField.isDataColumn() ? ParquetSchemaUtils.findSubFieldType(groupType, structField, map) : null;
            if (type == null) {
                if (StructField.METADATA_ROW_INDEX_COLUMN_NAME.equalsIgnoreCase(structField.getName()) && structField.isMetadataColumn()) {
                    Preconditions.checkArgument((boolean)(structField.getDataType() instanceof LongType), (String)"row index metadata column must be type long");
                    this.converters[i] = new ParquetColumnReaders.FileRowIndexColumnReader(n);
                    continue;
                }
                this.converters[i] = new ParquetColumnReaders.NonExistentColumnReader(dataType);
                continue;
            }
            this.converters[i] = ParquetColumnReaders.createConverter(n, dataType, type);
            this.parquetOrdinalToConverterOrdinal.put(n2, i);
            ++n2;
        }
    }

    public Converter getConverter(int n) {
        return this.converters[this.parquetOrdinalToConverterOrdinal.get(n)];
    }

    public void start() {
        this.isCurrentValueNull = false;
    }

    public void end() {
    }

    public ColumnarBatch getDataAsColumnarBatch(int n) {
        ColumnVector[] columnVectorArray = this.collectMemberVectors(n);
        DefaultColumnarBatch defaultColumnarBatch = new DefaultColumnarBatch(n, this.readSchema, columnVectorArray);
        this.resetWorkingState();
        return defaultColumnarBatch;
    }

    @Override
    public void finalizeCurrentRow(long l) {
        this.resizeIfNeeded();
        this.finalizeLastRowInConverters(l);
        this.nullability[this.currentRowIndex] = this.isCurrentValueNull;
        this.isCurrentValueNull = true;
        ++this.currentRowIndex;
    }

    @Override
    public ColumnVector getDataColumnVector(int n) {
        ColumnVector[] columnVectorArray = this.collectMemberVectors(n);
        DefaultStructVector defaultStructVector = new DefaultStructVector(n, (DataType)this.readSchema, Optional.of(this.nullability), columnVectorArray);
        this.resetWorkingState();
        return defaultStructVector;
    }

    @Override
    public void resizeIfNeeded() {
        if (this.nullability.length == this.currentRowIndex) {
            int n = this.nullability.length * 2;
            this.nullability = Arrays.copyOf(this.nullability, n);
            ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
        }
    }

    @Override
    public void resetWorkingState() {
        this.currentRowIndex = 0;
        this.isCurrentValueNull = true;
        this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
    }

    private void finalizeLastRowInConverters(long l) {
        for (int i = 0; i < this.converters.length; ++i) {
            ((ParquetColumnReaders.BaseColumnReader)this.converters[i]).finalizeCurrentRow(l);
        }
    }

    private ColumnVector[] collectMemberVectors(int n) {
        ColumnVector[] columnVectorArray = new ColumnVector[this.converters.length];
        for (int i = 0; i < this.converters.length; ++i) {
            columnVectorArray[i] = ((ParquetColumnReaders.BaseColumnReader)this.converters[i]).getDataColumnVector(n);
        }
        return columnVectorArray;
    }
}

