/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.git.BaseDiffBuilder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.springframework.beans.factory.annotation.Autowired;

public class GitCommitsAnalyzer {
    @Autowired
    private DSSUsageStatsInternalDB dbService;
    @Autowired
    private TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.stats.git");

    public GitCommitsAnalyzer() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void updateProjectAnalysis(String projectKey) throws Exception {
        long newMax = System.currentTimeMillis();
        newMax = newMax / 3600000L * 3600000L;
        newMax -= 10800000L;
        long prevMax = this.dbService.getLastAnalyzedHour(projectKey);
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        JGitManager.SubGit pgit = gitManager.getSubGit(projectKey);
        logger.infoV("Updating commits analysis for " + projectKey + " since " + DKUDateUtils.isoFormatLocal((long)prevMax), new Object[0]);
        List<IDSSUsageStatsInternalDB.CommitAnalysis> analyses = this.analyze(projectKey, pgit, prevMax);
        logger.infoV("Storing %d commit analysis", new Object[]{analyses.size()});
        this.dbService.storeCommitsAnalysis(projectKey, analyses, newMax);
    }

    private List<IDSSUsageStatsInternalDB.CommitAnalysis> analyze(String projectKey, JGitManager.SubGit pgit, final long fromTime) throws IOException, GitAPIException {
        logger.info((Object)("Analyzing stats for " + projectKey + " from " + DKUDateUtils.isoFormatLocal((long)fromTime) + " prefix=" + pgit.pathPrefix));
        ArrayList<RevCommit> used = new ArrayList<RevCommit>();
        try (RevWalk walk = new RevWalk(pgit.git.getRepository());){
            walk.markStart(walk.parseCommit((AnyObjectId)pgit.git.getRepository().resolve("HEAD")));
            if (StringUtils.isBlank((String)pgit.pathPrefix)) {
                walk.setTreeFilter(TreeFilter.ANY_DIFF);
            } else {
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.create((String)pgit.pathPrefix)));
            }
            walk.setRevFilter(new RevFilter(){

                public boolean include(RevWalk walker, RevCommit commit) throws IOException {
                    long commitTime = 1000L * (long)commit.getCommitTime();
                    if (commitTime < fromTime) {
                        throw StopWalkException.INSTANCE;
                    }
                    return true;
                }

                public RevFilter clone() {
                    return this;
                }
            });
            for (RevCommit rc : walk) {
                long commitTime;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found commit " + String.valueOf(rc.getId()) + " ts= " + rc.getCommitTime()));
                }
                if ((commitTime = 1000L * (long)rc.getCommitTime()) < fromTime) {
                    logger.warn((Object)"FAIL !!");
                    break;
                }
                used.add(rc);
            }
            walk.dispose();
        }
        logger.info((Object)("Analyzing " + used.size() + " commits"));
        ArrayList<IDSSUsageStatsInternalDB.CommitAnalysis> ret = new ArrayList<IDSSUsageStatsInternalDB.CommitAnalysis>();
        BaseDiffBuilder bdb = new BaseDiffBuilder(pgit.git);
        bdb.getDiffFormatter().statsOnly = true;
        int i = 0;
        for (RevCommit rc : used) {
            if (i % 100 == 0) {
                logger.infoV("Analyzed %d commits", new Object[]{i});
            }
            ++i;
            IDSSUsageStatsInternalDB.CommitAnalysis ca = new IDSSUsageStatsInternalDB.CommitAnalysis();
            ca.projectKey = projectKey;
            ca.commitId = rc.getId().getName();
            ca.author = rc.getAuthorIdent().getName();
            ca.timestamp = (long)rc.getCommitTime() * 1000L;
            for (GitModel.DKUDiffEntry e : bdb.diffSingleCommit(null, rc)) {
                if (e.changeType == DiffEntry.ChangeType.ADD) {
                    ++ca.addedFiles;
                } else if (e.changeType == DiffEntry.ChangeType.DELETE) {
                    ++ca.removedFiles;
                } else {
                    ++ca.changedFiles;
                }
                ca.addedLines += e.fileChange.addedLines;
                ca.removedLines += e.fileChange.removedLines;
            }
            ret.add(ca);
        }
        return ret;
    }
}

