/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.dip.analysis.coreservices.CacheableKernelService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.Pair;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataAugmentationService
extends CacheableKernelService {
    @Autowired
    PredictionService predictionService;
    private static final int KERNEL_CACHE_EXPIRATION_TIME_IN_SECONDS = 300;
    private static final String DATA_AUGMENTATION_SERVER_MODULE = "dataiku.doctor.deephub.data_augmentation.server";

    public List<AugmentedImage> getAugmentedImages_NT(AuthCtx user, MLTaskLoc taskLoc, PredictionMLTask task, DeepHubPreTrainModelingParams.ImageAugmentationParams augmentationParams, String imagePath, int numAugmentedVersions, AugmentationType augmentationType, Boolean applyMaxTransform) throws Exception {
        List resp;
        this.checkMLTask(task);
        LocalSimplePythonKernelBuilder builder = new LocalSimplePythonKernelBuilder(taskLoc, task);
        String lockName = "analysis.ml.prediction.data_augmentation." + String.valueOf(builder.getKey(user));
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            SimplePythonKernel kernel = (SimplePythonKernel)this.acquireKernel(user, builder);
            String managedFolderId = ((PredictionMLTask.DeepHubPredictionMLTask)task).managedFolderSmartId;
            kernel.getLink().sendRequest((Object)new DataAugmentationKernelParams(augmentationParams, managedFolderId, imagePath, numAugmentedVersions, augmentationType, applyMaxTransform));
            resp = (List)kernel.getLink().receiveJsonResponse((TypeToken)new TypeToken<List<AugmentedImage>>(){});
        }
        return resp;
    }

    private void checkMLTask(PredictionMLTask task) throws IOException {
        assert (task instanceof PredictionMLTask.DeepHubPredictionMLTask);
        InfoMessage checkMessage = this.predictionService.checkDeepHubCodeEnv((PredictionMLTask.DeepHubPredictionMLTask)task);
        if (checkMessage != null && (InfoMessage.Severity.WARNING.equals((Object)checkMessage.severity) || InfoMessage.Severity.ERROR.equals((Object)checkMessage.severity))) {
            throw new IllegalArgumentException("Cannot get augmented image because of the selected code-env: " + checkMessage.message);
        }
    }

    @Override
    protected int getKernelCacheExpirationTimeInSeconds() {
        return 300;
    }

    private static class LocalSimplePythonKernelBuilder
    implements CacheableKernelService.CacheableKernelBuilder {
        private final MLTaskLoc taskLoc;
        private final MLTask task;

        public LocalSimplePythonKernelBuilder(MLTaskLoc taskLoc, MLTask task) {
            this.taskLoc = taskLoc;
            this.task = task;
        }

        @Override
        public AlivenessCheckableAndClosable createKernel(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException, InterruptedException {
            LocalSimplePythonKernel kernel = new LocalSimplePythonKernel(authCtx, this.taskLoc.analysisProjectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, this.task.envSelection.envName, DataAugmentationService.DATA_AUGMENTATION_SERVER_MODULE, false, false, null, true, "data-augmentation-server");
            kernel.start();
            return kernel;
        }

        @Override
        public Pair<String, String> getKey(AuthCtx authCtx) {
            return new Pair((Object)authCtx.toString(), (Object)this.taskLoc.toString());
        }
    }

    static class DataAugmentationKernelParams {
        final int numAugmentedVersions;
        final DeepHubPreTrainModelingParams.ImageAugmentationParams augmentationParams;
        final AugmentationType augmentationType;
        final boolean applyMaxTransform;
        final String managedFolderId;
        final String imagePath;

        DataAugmentationKernelParams(DeepHubPreTrainModelingParams.ImageAugmentationParams augmentationParams, String managedFolderId, String imagePath, int numAugmentedVersions, AugmentationType augmentationType, boolean applyMaxTransform) {
            this.augmentationParams = augmentationParams;
            this.managedFolderId = managedFolderId;
            this.imagePath = imagePath;
            this.numAugmentedVersions = numAugmentedVersions;
            this.augmentationType = augmentationType;
            this.applyMaxTransform = applyMaxTransform;
        }
    }

    @UIModel
    public static enum AugmentationType {
        AFFINE,
        COLOR,
        CROP;

    }

    @UIModel
    static class AugmentedImage {
        String imgDataAsBase64;
        boolean failed;

        AugmentedImage() {
        }
    }
}

