/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices.flow;

import com.dataiku.dip.analysis.coreservices.flow.ISavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.SavedModelOriginInfo;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedModelsCRUDService
implements ISavedModelsCRUDService {
    @Autowired
    private SavedModelsDAO dao;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private LLMSMMgmtService llmSavedModelsService;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.savedmodelsCRUD");

    @Override
    public SavedModel getOrNull(String projectKey, String id) throws IOException {
        return (SavedModel)this.dao.getOrNull(projectKey, id);
    }

    @Override
    public SavedModel getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (SavedModel)this.dao.getOrNullUnsafe(projectKey, id);
    }

    @Override
    public SavedModel getMandatory(String projectKey, String id) throws IOException {
        return (SavedModel)this.dao.getMandatory(projectKey, id);
    }

    @Override
    public SavedModel getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (SavedModel)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public SavedModel lookupMandatoryUnsafe(String projectKey, String lookup) throws IOException {
        SavedModel ret = (SavedModel)this.dao.getOrNullUnsafe(projectKey, lookup);
        if (ret != null) {
            return ret;
        }
        for (SavedModel sm : this.dao.listUnsafe(projectKey)) {
            if (!sm.name.equals(lookup)) continue;
            return sm;
        }
        throw new NotFoundException("Saved model with id/name '" + lookup + "' does not exist in project " + projectKey);
    }

    @Override
    public SavedModel getRecipeInput(SerializedRecipe sr) throws IOException {
        AnyLoc modelLoc = AnyLoc.resolveSmart(sr.projectKey, sr.getInputsForRole((String)"model").get((int)0).ref);
        return this.getMandatory(modelLoc.getProjectKey(), modelLoc.getId());
    }

    private void denormalizeProxyModelFields(SavedModel sm) {
        File versionsFolder = MLPaths.savedModelVersionsFolder(sm);
        if (!versionsFolder.isDirectory()) {
            return;
        }
        for (File f : versionsFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES)) {
            FullModelId fmi = new FullModelId(sm.projectKey, sm.id, f.getName());
            try {
                MLFlowModelVersionInfo mlFlowImportedModelMetadata = fmi.getMLflowImportedModelMetadata();
                if (!mlFlowImportedModelMetadata.isProxyModel()) continue;
                mlFlowImportedModelMetadata.proxyModelVersionConfiguration.proxyModelConfiguration.setFromSavedModel(sm, false);
                fmi.writeMLflowImportedModelMetadata(mlFlowImportedModelMetadata);
            }
            catch (IOException ioe) {
                this.logger.error((Object)("Error updating proxy model configuration of SMV " + fmi.toString()), (Throwable)ioe);
            }
        }
    }

    @Override
    public SavedModel save(SavedModel sm, boolean creation, boolean summaryOnly) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)sm.projectKey);
        Preconditions.checkNotNull((Object)sm.id);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sm.name), (Object)"Required field 'name' is empty.");
        Preconditions.checkArgument((sm.savedModelType != SavedModel.SavedModelType.PROXY_MODEL || sm.proxyModelConfiguration != null && StringUtils.isNotBlank((String)sm.proxyModelConfiguration.protocol) ? 1 : 0) != 0, (Object)("Field 'protocol' is required for the savedModelType '" + String.valueOf((Object)sm.savedModelType) + "'."));
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SavedModel preExisting = (SavedModel)this.dao.getOrNullUnsafe(sm.projectKey, sm.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(sm, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", sm.name);
        details.addProperty("savedModelType", sm.savedModelType != null ? sm.savedModelType.toString() : null);
        details.addProperty("taskType", sm.miniTask != null ? sm.miniTask.taskType.toString() : null);
        details.addProperty("proxyModelProtocol", sm.proxyModelConfiguration != null ? sm.proxyModelConfiguration.protocol : null);
        details.addProperty("backendType", sm.miniTask != null ? sm.miniTask.backendType.toString() : null);
        if (sm.miniTask != null && sm.getType() == MLTask.MLTaskType.PREDICTION) {
            PredictionMLTask miniTask = (PredictionMLTask)sm.miniTask;
            if (miniTask.predictionType != null) {
                details.addProperty("predictionType", miniTask.predictionType.toString());
            }
        }
        boolean updateSMVs = false;
        if (creation) {
            this.addDefaultMetricsStuff(sm);
            sm.creationTag = new VersionTag(t.getUser().getIdentifier());
            action = TaggableObjectChangedEvent.ActionType.SAVED_MODEL_CREATE;
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(sm);
        } else {
            action = TaggableObjectChangedEvent.ActionType.SAVED_MODEL_EDIT;
            if (preExisting != null) {
                boolean bothProxyModels;
                if (!sm.name.equals(preExisting.name)) {
                    action = TaggableObjectChangedEvent.ActionType.SAVED_MODEL_RENAME;
                    details.addProperty("newName", sm.name);
                    details.addProperty("oldName", preExisting.name);
                }
                boolean bl = bothProxyModels = sm.proxyModelConfiguration != null && preExisting.proxyModelConfiguration != null;
                if (bothProxyModels) {
                    if (!StringUtils.equals((String)preExisting.proxyModelConfiguration.protocol, (String)sm.proxyModelConfiguration.protocol)) {
                        throw new IllegalArgumentException("The protocol field cannot be updated.");
                    }
                    if (!StringUtils.equals((String)preExisting.proxyModelConfiguration.connection, (String)sm.proxyModelConfiguration.connection)) {
                        updateSMVs = true;
                    }
                }
            }
            diff = this.colaborativeMetadataDiffService.diff(preExisting, sm, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(sm.projectKey, sm.id), sm);
        this.dao.save(sm);
        if (updateSMVs) {
            this.denormalizeProxyModelFields(sm);
        }
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SAVED_MODEL, sm.projectKey, sm.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(sm.projectKey, sm.tags);
        if (action == TaggableObjectChangedEvent.ActionType.SAVED_MODEL_RENAME) {
            this.graphService.invalidateCache();
        }
        return sm;
    }

    public void rename(String projectKey, String savedModelId, String newName) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)newName), (Object)"Saved model name cannot be blank");
        SavedModel savedModel = (SavedModel)this.dao.getMandatory(projectKey, savedModelId);
        String newNameTrimmed = newName.trim();
        if (newNameTrimmed.equals(savedModel.name)) {
            return;
        }
        SavedModel renamedSavedModel = (SavedModel)this.dao.getMandatory(projectKey, savedModelId);
        renamedSavedModel.name = newNameTrimmed;
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdate(renamedSavedModel, savedModel);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), savedModel, renamedSavedModel);
        this.dao.save(renamedSavedModel);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", renamedSavedModel.name);
        details.addProperty("oldName", savedModel.name);
        details.addProperty("newName", renamedSavedModel.name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SAVED_MODEL, renamedSavedModel.projectKey, renamedSavedModel.id, t.getUser(), TaggableObjectChangedEvent.ActionType.SAVED_MODEL_RENAME).withDetails(details));
        this.graphService.invalidateCache();
    }

    protected void addDefaultMetricsStuff(SavedModel sm) {
        ProbesSet metrics = new ProbesSet();
        metrics.displayedState.partition = "NP";
        metrics.displayedState.metrics.add("reporting:BUILD_DURATION");
        sm.metrics = metrics;
        ChecksSet checks = new ChecksSet();
        checks.displayedState.partition = "NP";
        sm.metricsChecks = checks;
    }

    @Override
    public List<SavedModel> list(String projectKey) throws IOException {
        return this.dao.list(projectKey);
    }

    @Override
    public List<SavedModel> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    @Override
    public List<SavedModel> list(String projectKey, SavedModel.SavedModelType savedModelType) throws IOException {
        return this.dao.list(projectKey).stream().filter(sm -> sm.savedModelType == savedModelType).toList();
    }

    @Override
    public List<SavedModel> listUnsafe(String projectKey, SavedModel.SavedModelType savedModelType) throws IOException {
        return this.dao.listUnsafe(projectKey).stream().filter(sm -> sm.savedModelType == savedModelType).toList();
    }

    @Override
    public void performDeletion(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        SavedModel sm;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            sm = (SavedModel)this.dao.getOrNull(projectKey, id);
            this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, sm);
            if (sm != null) {
                details.addProperty("objectDisplayName", sm.name);
                details.addProperty("savedModelType", sm.savedModelType != null ? sm.savedModelType.toString() : null);
                details.addProperty("taskType", sm.miniTask != null ? sm.miniTask.taskType.toString() : null);
                details.addProperty("proxyModelProtocol", sm.proxyModelConfiguration != null ? sm.proxyModelConfiguration.protocol : null);
                details.addProperty("backendType", sm.miniTask != null ? sm.miniTask.backendType.toString() : null);
                if (sm.miniTask != null && sm.getType() == MLTask.MLTaskType.PREDICTION) {
                    PredictionMLTask miniTask = (PredictionMLTask)sm.miniTask;
                    if (miniTask.predictionType != null) {
                        details.addProperty("predictionType", miniTask.predictionType.toString());
                    }
                }
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error when getting SavedModel", (Throwable)e);
        }
        sm = (SavedModel)this.dao.getOrNull(projectKey, id);
        if (sm != null && sm.savedModelType == SavedModel.SavedModelType.LLM_GENERIC) {
            this.llmSavedModelsService.deleteAllLLMGenericModelVersions(authCtx, sm);
        }
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, projectKey, id, ignored);
        for (TaggableObjectsDeletionService.ImpactedDataset deletedDataset : di.deletedDatasets) {
            this.datasetSaveService.delete(deletedDataset.projectKey, deletedDataset.name);
        }
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
            this.recipeSaveService.delete(recipe.projectKey, recipe.name);
        }
        try {
            this.exposedObjectsService.removeExposedObject(projectKey, ITaggingService.TaggableType.SAVED_MODEL, id);
        }
        catch (Exception e) {
            this.logger.warnV((Throwable)e, "Unable to remove objet sharing for %s(%s) on project %s.", new Object[]{ITaggingService.TaggableType.SAVED_MODEL, id, projectKey});
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SAVED_MODEL, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.SAVED_MODEL_DELETE).withDetails(details));
        try {
            this.dao.delete(projectKey, id);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"Saved model was not found during deletion, proceeding");
        }
    }

    @Override
    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String smId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        return this.computeDeletionImpact(authCtx, projectKey, projectKey, smId, ignored);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nonnull String contextProjectKey, String projectKey, String smId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        ProjectFlowGraph graphUnsafe;
        FlowComputable fcUnsafe;
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        AnyLoc smLoc = new AnyLoc(projectKey, smId);
        List<SerializedRecipe> connectedRecipes = this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(smLoc);
        for (SerializedRecipe sr : connectedRecipes) {
            this.addRecipeToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(projectKey)) {
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(contextProjectKey)) {
                if (!sr.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(smLoc)) && !sr.getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(smLoc))) continue;
                this.addRecipeToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
            }
        }
        if ((fcUnsafe = (graphUnsafe = this.graphService.getProjectGraphUnsafe(projectKey)).getComputable(projectKey + "." + smId)) != null) {
            this.addImplicitRecipesToDeletionImpact(authCtx, fcUnsafe.getSuccessors(), di, ignored);
        }
        Set<String> smExpositionTargetProjects = this.projectsService.getObjectExpositionTargetProjects(smLoc.getProjectKey(), smLoc.getId());
        for (String targetProject : smExpositionTargetProjects) {
            ProjectFlowGraph foreignGraphUnsafe;
            FlowComputable foreignFcUnsafe;
            if (!this.permissionsService.hasProjectPrivilege(authCtx, targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF) || (foreignFcUnsafe = (foreignGraphUnsafe = this.graphService.getProjectGraphUnsafe(targetProject)).getComputable(projectKey + "." + smId)) == null) continue;
            this.addForeignImplicitRecipesToDeletionImpact(foreignFcUnsafe.getSuccessors(), di, ignored);
        }
        return di;
    }

    private void addRecipeToDeletionImpact(AuthCtx authCtx, SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String recipeProjectKey = sr.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(sr.getProjectKey(), ITaggingService.TaggableType.RECIPE, sr.name))) {
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipeProjectKey, sr.name, sr.type);
            if (contextProjectKey.equals(recipeProjectKey)) {
                di.deletedRecipes.add(impactedRecipe);
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, recipeProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableRecipes.add(impactedRecipe);
            }
        }
    }

    private void addImplicitRecipesToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                    di.merge(this.datasetDeletionService.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"Failed to get saved model info: ", (Throwable)e);
            }
        }
    }

    private void addForeignImplicitRecipesToDeletionImpact(List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.foreignReadableDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"Failed to get saved model info: ", (Throwable)e);
            }
        }
    }

    public List<SavedModelWithVersions> listWithVersionsFromAnalysis(String projectKey, String analysisId) throws IOException {
        ArrayList<SavedModelWithVersions> matchingModels = new ArrayList<SavedModelWithVersions>();
        String analysisPrefix = FullModelId.analysisPrefix(projectKey, analysisId);
        for (SavedModel sm : this.dao.list(projectKey)) {
            File[] versionsDir;
            File versionsFolder = MLPaths.savedModelVersionsFolder(sm);
            SavedModelWithVersions savedModelWithVersions = null;
            if (!versionsFolder.isDirectory()) continue;
            for (File f : versionsDir = versionsFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES)) {
                String versionId = f.getName();
                FullModelId versionFMI = new FullModelId(sm.projectKey, sm.id, versionId);
                if (!versionFMI.getSmOriginFile().isFile()) continue;
                SavedModelOriginInfo versionOrigin = versionFMI.getSmOrigin();
                if (versionOrigin.origin != SavedModelOriginInfo.Origin.EXPORTED_FROM_ANALYSIS || versionOrigin.fullModelId == null || !versionOrigin.fullModelId.startsWith(analysisPrefix)) continue;
                if (savedModelWithVersions == null) {
                    savedModelWithVersions = new SavedModelWithVersions(sm);
                }
                ++savedModelWithVersions.nbVersionsFromAnalysis;
            }
            if (savedModelWithVersions == null) continue;
            savedModelWithVersions.nbVersions = versionsDir.length;
            matchingModels.add(savedModelWithVersions);
        }
        return matchingModels;
    }

    public Map<String, Boolean> listAnalysesWithVersions(String projectKey) throws IOException {
        HashMap<String, Boolean> analysisWithSavedModel = new HashMap<String, Boolean>();
        for (SavedModel sm : this.dao.list(projectKey)) {
            File versionsFolder = MLPaths.savedModelVersionsFolder(sm);
            if (!versionsFolder.isDirectory()) continue;
            for (File f : versionsFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES)) {
                String versionId = f.getName();
                FullModelId versionFMI = new FullModelId(sm.projectKey, sm.id, versionId);
                if (!versionFMI.getSmOriginFile().isFile()) continue;
                SavedModelOriginInfo versionOrigin = versionFMI.getSmOrigin();
                if (versionOrigin.origin != SavedModelOriginInfo.Origin.EXPORTED_FROM_ANALYSIS || versionOrigin.fullModelId == null) continue;
                String originalAnalysisId = FullModelId.extractAnalysisId(versionOrigin.fullModelId);
                Boolean isActive = (Boolean)analysisWithSavedModel.get(originalAnalysisId);
                if (isActive == null) {
                    isActive = Boolean.FALSE;
                }
                analysisWithSavedModel.put(originalAnalysisId, isActive != false || f.getName().equals(sm.activeVersion));
            }
        }
        return analysisWithSavedModel;
    }

    @Override
    public void addDeployedSavedModelVersionSuffixAndUpdateLabel(SavedModel sm, String newVersion) throws IOException {
        FullModelId baseFMI = new FullModelId(sm.projectKey, sm.id, newVersion);
        ModelUserMeta baseUserMeta = baseFMI.getUserMeta();
        baseUserMeta.name = baseUserMeta.name + sm.getInitialVersionSuffix();
        baseUserMeta.labels = EvaluationLabelsHelper.setModelNameToLabels(baseUserMeta.labels, baseUserMeta.name);
        baseFMI.saveUserMeta(baseUserMeta);
    }

    public class SavedModelWithVersions {
        public SavedModel savedModel;
        public int nbVersions = 0;
        public int nbVersionsFromAnalysis = 0;

        public SavedModelWithVersions(SavedModel savedModel) {
            this.savedModel = savedModel;
        }
    }
}

