/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationThread;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.analysis.docgen.model.ModelDocumentFormat;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelDocumentGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private ClusteringSMMgmtService csmmService;
    @Autowired
    private SavedModelsCRUDService smService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    public static boolean isModelDocumentationConstant(String fullModelId) {
        return fullModelId.equals("LATEST_VERSION") || fullModelId.equals("ACTIVE_VERSION");
    }

    public FutureResponse<DocumentGenerationResponse> generateDocument(DSSAuthCtx authCtx, String projectKey, InputStream inputStream, FullModelId fmi) throws Exception {
        GeneralSettingsDAO.GeneralSettings generalSettings = null;
        try (Transaction t = this.transactionService.beginRead();){
            generalSettings = this.generalSettingsDAO.read();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read the general settings", (Throwable)e);
        }
        String rootUrl = UrlUtil.getDSSInternalRootUrl(generalSettings);
        ModelDocumentGenerationThread thread = new ModelDocumentGenerationThread(authCtx, projectKey, fmi, inputStream, rootUrl);
        return this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<DocumentGenerationResponse>>(){});
    }

    public FutureResponse<DocumentGenerationResponse> generateDocumentAndWaitResponse(DSSAuthCtx authCtx, String projectKey, InputStream inputStream, FullModelId fmi) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocument(authCtx, projectKey, inputStream, fmi);
        return this.futureService.waitForFinalResponse(future);
    }

    public DocumentGenerationResponse getMdgResponse(DSSAuthCtx authCtx, String projectKey, InputStream inputStream, FullModelId fmi) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocumentAndWaitResponse(authCtx, projectKey, inputStream, fmi);
        if (((DocumentGenerationResponse)future.result).data.fatal) {
            throw new IOException("Generate document fatal error:" + String.valueOf(((DocumentGenerationResponse)future.result).data.firstFatal()));
        }
        return (DocumentGenerationResponse)future.result;
    }

    public File generateDocumentAndWaitFile(DSSAuthCtx authCtx, String projectKey, InputStream inputStream, FullModelId fmi) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocumentAndWaitResponse(authCtx, projectKey, inputStream, fmi);
        if (((DocumentGenerationResponse)future.result).data.fatal) {
            throw new IOException("Generate document fatal error:" + String.valueOf(((DocumentGenerationResponse)future.result).data.firstFatal()));
        }
        File parentFolder = new File(MDGFileUtil.getTmpExportDirectory(((DocumentGenerationResponse)future.result).exportId));
        return MDGFileUtil.getRenderedTemplateFile(parentFolder);
    }

    public File getMdgFile(String templateUploadId) throws IOException {
        File parentFolder = new File(MDGFileUtil.getTmpExportDirectory(templateUploadId));
        return MDGFileUtil.getRenderedTemplateFile(parentFolder);
    }

    public File getMdgFile(DocumentGenerationResponse response) throws IOException {
        return this.getMdgFile(response.exportId);
    }

    public void clean(File outputFile) throws IOException {
        FileUtils.cleanDirectory((File)outputFile.getParentFile());
    }

    public File getTemplate(boolean useDefault, String fullModelId, AuthCtx user, String projectKey, String folderId, String templatePath) throws DKUSecurityException, CodedException, IOException {
        if (useDefault) {
            return this.getDefaultTemplate(fullModelId);
        }
        return this.getTemplateFromManagedFolder(user, projectKey, folderId, templatePath);
    }

    public File getDefaultTemplate(String fullModelId) throws IOException {
        Object templateName;
        FullModelId fmi = FullModelId.parse(fullModelId);
        if (fmi.isExternalMLflowModelVersion()) {
            templateName = fmi.getPredictionType() == null || !fmi.getClassicalPredictionPerf().isPresent() ? "mlflow_no_evaluation" : "mlflow";
        } else {
            MLTask mlTask = fmi.getHeadMLTask();
            if (MLTask.MLTaskType.CLUSTERING.equals((Object)mlTask.taskType)) {
                templateName = "clustering";
            } else if (MLTask.MLTaskType.PREDICTION.equals((Object)mlTask.taskType)) {
                PredictionMLTask predictionMLTask = (PredictionMLTask)mlTask;
                switch (predictionMLTask.predictionType) {
                    case REGRESSION: {
                        templateName = "regression";
                        break;
                    }
                    case BINARY_CLASSIFICATION: {
                        templateName = "binary_classification";
                        break;
                    }
                    case MULTICLASS: {
                        templateName = "multiclass_classification";
                        break;
                    }
                    case TIMESERIES_FORECAST: {
                        templateName = "timeseries_forecast";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported prediction type: " + String.valueOf((Object)predictionMLTask.predictionType));
                    }
                }
            } else {
                throw new UnsupportedOperationException("Unknown ML task type " + String.valueOf((Object)mlTask.taskType));
            }
        }
        templateName = (String)templateName + "." + ModelDocumentFormat.DOCX.getExtension();
        return DKUFileUtils.getWithin((File)new File(DKUApp.getInstallFolder(), "resources"), (String[])new String[]{"docgen", templateName});
    }

    private File getTemplateFromManagedFolder(AuthCtx user, String projectKey, String folderId, String templatePath) throws IOException, DKUSecurityException, CodedException {
        ManagedFolder sourceMF;
        try (Transaction t = this.transactionService.beginRead();){
            sourceMF = this.managedFoldersService.getMandatory(projectKey, folderId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)sourceMF.buildHandler(user);){
            File file = new File(handler.getAbsolutePath(templatePath));
            return file;
        }
    }

    public FullModelId getSavedModelFMI_NT(String projectKey, String modelId, String selectVersion) throws IOException {
        SavedModel sm;
        TransactionContext.assertNoAttachedTransaction();
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, modelId);
        String modelProjectKey = ref.projectKey != null ? ref.projectKey : projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.smService.getMandatoryUnsafe(modelProjectKey, ref.objectId);
        }
        MLTask.MLTaskType smType = sm.getType();
        if ("ACTIVE_VERSION".equals(selectVersion)) {
            switch (smType) {
                case PREDICTION: {
                    return this.psmmService.getActiveVersionFMI(sm);
                }
                case CLUSTERING: {
                    return this.csmmService.getActiveVersionFMI(sm);
                }
                case LLM_GENERIC_RAW: 
                case LLM_GENERIC_PROMPTABLE_COMPLETION: 
                case LLM_CLASSIFICATION: {
                    throw new IllegalArgumentException("LLM not supported here");
                }
            }
        }
        if ("LATEST_VERSION".equals(selectVersion)) {
            switch (smType) {
                case PREDICTION: {
                    return this.psmmService.getLatestVersionFMI_NT(sm);
                }
                case CLUSTERING: {
                    return this.csmmService.getLatestVersionFMI_NT(sm);
                }
                case LLM_GENERIC_RAW: 
                case LLM_GENERIC_PROMPTABLE_COMPLETION: 
                case LLM_CLASSIFICATION: {
                    throw new IllegalArgumentException("LLM not supported here");
                }
            }
        }
        return null;
    }

    private static class FMIConstants {
        public static final String ACTIVE_VERSION = "ACTIVE_VERSION";
        public static final String LATEST_VERSION = "LATEST_VERSION";

        private FMIConstants() {
        }
    }
}

