/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractScoringRecipeRunner
implements InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload {
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected APITicketService ticketService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    private InitializableAbortableRecipeRunner abortableRunner = null;
    protected final JobActivity activity;
    protected final FlowRecipe recipe;
    protected final ResourcesGatherer gatherer = new ResourcesGatherer();
    protected AuthCtx authCtx;

    public AbstractScoringRecipeRunner(JobActivity activity) {
        this.activity = activity;
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = subgraph.getRecipe();
        activity.initStatus();
    }

    @Override
    public void init() throws Exception {
        SpringUtils.getInstance().autowire((Object)this.gatherer);
        new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.abortableRunner != null) {
            this.abortableRunner.notifyBeforeAborting();
        }
    }

    protected void startRunner(InitializableAbortableRecipeRunner runner) throws Exception {
        SpringUtils.getInstance().autowire((Object)runner);
        runner.init();
        this.abortableRunner = runner;
        runner.run();
    }

    static {
        DKUMLUtils.loadClasses();
        ScriptStep.loadClass();
    }
}

