/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class Guesser<T extends MLTask> {
    protected final T task;
    protected final MemTable table;

    protected Guesser(T task, MemTable table) {
        this.task = task;
        this.table = table;
    }

    public abstract void guessAllSettings(boolean var1);

    public abstract void updateGuess(@Nullable GuessStatus var1);

    public abstract FeaturePreprocessingParams guessSingleFeature(MemColumn var1);

    public void fixupAfterDuplication() {
        HashMap<String, FeaturePreprocessingParams> perFeature = new HashMap<String, FeaturePreprocessingParams>();
        Map<String, FeaturePreprocessingParams> perFeatureOld = ((MLTask)this.task).getPreprocessingParams().per_feature;
        for (MemColumn column : this.table.columns.values()) {
            FeaturePreprocessingParams fp;
            String columnName = column.getName();
            if (perFeatureOld.containsKey(columnName)) {
                fp = perFeatureOld.get(columnName);
            } else {
                fp = this.guessSingleFeature(column);
                fp.state = new FeaturePreprocessingParams.FeatureState();
                fp.state.recordedMeaning = column.selectedType.type.getClass().getSimpleName();
            }
            perFeature.put(columnName, fp);
        }
        ((MLTask)this.task).getPreprocessingParams().per_feature = perFeature;
    }
}

