/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.MetricMapProvider;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegressionModelPerf
extends PredictionModelPerf {
    public RegressionPerformance regression_performance;
    public ScatterplotData scatterPlotData;
    public RegressionMetrics metrics;
    public RegressionResiduals residuals;

    @Override
    public Map<String, Double> getMetricMap(boolean withStdMetrics) {
        HashMap<String, Double> metricMap = new HashMap<String, Double>();
        metricMap.put("evs", this.metrics.evs);
        metricMap.put("mape", this.metrics.mape);
        metricMap.put("mae", this.metrics.mae);
        metricMap.put("mse", this.metrics.mse);
        metricMap.put("rmse", this.metrics.rmse);
        metricMap.put("rmsle", this.metrics.rmsle);
        metricMap.put("r2", this.metrics.r2);
        metricMap.put("pearson", this.metrics.pearson);
        if (withStdMetrics) {
            metricMap.put("evsstd", this.metrics.evsstd);
            metricMap.put("r2std", this.metrics.r2std);
            metricMap.put("rmslestd", this.metrics.rmslestd);
            metricMap.put("rmsestd", this.metrics.rmsestd);
            metricMap.put("msestd", this.metrics.msestd);
            metricMap.put("maestd", this.metrics.maestd);
            metricMap.put("mapestd", this.metrics.mapestd);
            metricMap.put("pearsonstd", this.metrics.pearsonstd);
        }
        return MetricMapProvider.addCustomMetricsToMetricMap(this.metrics.customMetricsResults, metricMap, withStdMetrics);
    }

    public static class RegressionMetrics {
        public Double evs;
        public double evsstd;
        public Double mape;
        public Double mapestd;
        public Double mae;
        public double maestd;
        public Double mse;
        public double msestd;
        public Double rmse;
        public double rmsestd;
        public Double rmsle;
        public double rmslestd;
        public Double r2;
        public double r2std;
        public Double pearson;
        public double pearsonstd;
        public Double customScore;
        public double customScorestd;
        public PredictionModelPerf.AssertionsMetrics assertionsMetrics;
        public PredictionModelPerf.OverridesMetrics overridesMetrics;
        public CustomMetricResult[] customMetricsResults;
    }

    public static class RegressionResiduals {
        public List<Double> residuals = new ArrayList<Double>();
        public Double residualsMean;
        public Double residualsStd;
        public List<Double> stdResiduals = new ArrayList<Double>();
        public List<Double> theoreticalQuantiles = new ArrayList<Double>();
        public Stats stats;

        public static class Stats {
            Double jarqueBera;
            Double jarqueBeraPValue;
            Double skew;
            Double kurtosis;
        }
    }

    public static class ScatterplotData {
        public double[] x;
        public double[] y;
    }

    public static class RegressionPerformance {
        public List<PredictionModelPerf.HistogramBin> error_distribution;
        public double min_error;
        public Double raw_min_error;
        public double p25_error;
        public double median_error;
        public double average_error;
        public Double raw_average_error;
        public double std_error;
        public Double raw_std_error;
        public double p75_error;
        public double p90_error;
        public double max_error;
        public Double raw_max_error;
    }
}

