/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class PyExtraTreesMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Extra trees";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.RandomForestHyperparametersSpace rfp = rpmp.extra_trees_grid;
        assert (rfp != null);
        return new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, rfp)).withMVParam("trees", rfp.n_estimators).withMVParam("depth", rfp.max_tree_depth).withMVParam("min_samples", rfp.min_samples_leaf);
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription().withSVParam("trees", after.extra_trees.estimators).withSVParam("depth", after.extra_trees.max_tree_depth).withSVParam("min_samples", after.extra_trees.min_samples_leaf);
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.RandomForestHyperparametersSpace rfp = (PredictionModelingParams.RandomForestHyperparametersSpace)space;
        int baseNb = rfp.max_tree_depth.getLength() * rfp.min_samples_leaf.getLength() * rfp.n_estimators.getLength();
        if (rfp.selection_mode == PredictionModelingParams.TreeSelectionMode.NUMBER) {
            baseNb *= rfp.max_features.getLength();
        }
        if (rfp.selection_mode == PredictionModelingParams.TreeSelectionMode.PROP) {
            baseNb *= rfp.max_feature_prop.getLength();
        }
        return baseNb;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.RandomForestHyperparametersSpace etp = pmp.extra_trees;
        if (etp == null || !etp.enabled) {
            return;
        }
        checks.addWarningSparse("Extra Trees");
        ErrorContext.check((etp.n_jobs > 0 ? 1 : 0) != 0, (String)"Extra trees parallelism must be > 0");
        checks.checkNumericalDimension(etp.max_tree_depth, "Max depth of trees (Extra Trees)");
        checks.checkNumericalDimension(etp.min_samples_leaf, "Min samples per leaf (Extra Trees)");
        checks.checkNumericalDimension(etp.n_estimators, "Number of estimators (Extra Trees)");
        if (etp.selection_mode == PredictionModelingParams.TreeSelectionMode.NUMBER) {
            checks.checkNumericalDimension(etp.max_features, "Max number of features (Extra Trees)");
        }
        if (etp.selection_mode == PredictionModelingParams.TreeSelectionMode.PROP) {
            checks.checkNumericalDimension(etp.max_feature_prop, "Max proportion of features (Extra Trees)");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.RandomForestHyperparametersSpace etp = pmp.extra_trees;
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (etp == null || !etp.enabled) {
            return ret;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.EXTRA_TREES, pmp);
        rcmp.extra_trees_grid = etp;
        rcmp.max_ensemble_nodes_serialized = pmp.max_ensemble_nodes_serialized;
        WorkSet.ModelingSet ms = new WorkSet.ModelingSet(rcmp);
        rcmp.gridLength = this.getSearchSize(rcmp.grid_search_params, etp);
        ms.estimatedTrains = rcmp.gridLength > 1 ? rcmp.gridLength * gsFolds + 1 : 1;
        ret.add(ms);
        return ret;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    public boolean isJavaCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public boolean isPythonCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return true;
    }

    @Override
    public boolean isSQLCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        switch (coreParams.prediction_type) {
            case REGRESSION: 
            case BINARY_CLASSIFICATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPMMLCompatible() {
        return true;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams ret = this.getCopyWithGridStrategy(usedToTrain);
        ret.extra_trees_grid.n_estimators.setToSingleValueGrid(Long.valueOf(optimized.extra_trees.estimators));
        ret.extra_trees_grid.max_tree_depth.setToSingleValueGrid(Long.valueOf(optimized.extra_trees.max_tree_depth));
        ret.extra_trees_grid.min_samples_leaf.setToSingleValueGrid(Long.valueOf(optimized.extra_trees.min_samples_leaf));
        ret.extra_trees_grid.max_features.setToSingleValueGrid(Long.valueOf(optimized.extra_trees.max_features));
        ret.extra_trees_grid.max_feature_prop.setToSingleValueGrid(optimized.extra_trees.max_feature_prop);
        return ret;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.extra_trees = preTrain.extra_trees_grid;
        target.extra_trees.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.extra_trees = usedToTrain.extra_trees_grid;
        target.extra_trees.enabled = true;
    }
}

