/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.DeploymentInfoCRUDService;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.AutoSmartLogTailRedirect;
import com.dataiku.dip.futures.ExtraLogFileAppender;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFullyManagedAPIServiceDeploymentManager
extends AbstractAPIServiceDockerDeploymentManager {
    protected static final String DIAGNOSIS_DEPLOYMENT_INFO_FILENAME = "deployment-info.json";
    protected static final String DIAGNOSIS_DEPLOYMENT_FILENAME = "deployment.json";
    protected static final String DIAGNOSIS_INFRA_FILENAME = "infra.json";
    protected static final String DIAGNOSIS_LOCAL_SUMMARY_FILENAME = "local-summary.json";
    protected static final String DIAGNOSIS_REMOTE_SUMMARY_FILENAME = "remote-summary.json";
    protected static final String DIAGNOSIS_STATUS_REPORT_FILENAME = "status-report.json";
    protected static final String DIAGNOSIS_VERSIONS_FILENAME = "versions.json";
    @Autowired
    protected DeploymentInfoCRUDService deploymentInfoCRUDService;

    AbstractFullyManagedAPIServiceDeploymentManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected abstract AbstractFullyManagedAPIDeployment getDeployment();

    @Override
    protected abstract AbstractFullyManagedAPIDeploymentInfra getInfra();

    protected abstract FullyManagedAPIServiceDeploymentConfigManager getConfigManager();

    protected abstract AbstractFullyManagedStatusReporter getDeploymentStatusReporter();

    public abstract DeploymentStatusReport getFullCheckReport_NT() throws Exception;

    public abstract void deleteResources_NT() throws CodedException, IOException, SQLException, InterruptedException;

    protected VariablesContext getVariablesContext() {
        VariablesContext variablesContext = this.variablesService.getGlobalContext();
        if (variablesContext instanceof HierarchicalVariablesContext) {
            JsonObject variables = new JsonObject();
            variables.addProperty("apiDeploymentId", this.getDeployment().id);
            variables.addProperty("infraId", this.getInfra().id);
            variables.addProperty("publishedServiceId", this.getDeployment().publishedServiceId);
            String deployedServiceId = (String)StringUtils.defaultIfBlank((CharSequence)this.getDeployment().deployedServiceId, (CharSequence)this.getDeployment().publishedServiceId);
            variables.addProperty("deployedServiceId", deployedServiceId);
            ((HierarchicalVariablesContext)variablesContext).addLevel(variables);
        }
        return variablesContext;
    }

    @Nonnull
    protected PublishedApiServicePackageInfo getPackageInfo_NT() throws UnauthorizedException, IOException {
        String publishedServiceId = this.getDeployment().publishedServiceId;
        String generation = this.getDeployment().getActiveGeneration();
        PublishedApiServicePackageInfo packageInfo = this.publishedAPIServicesService.getPublishedPackageOrNull_Check_NT(publishedServiceId, generation, this.authCtx);
        if (packageInfo == null) {
            throw new UnsupportedOperationException(String.format("Generation %s not found in service %s.", generation, publishedServiceId));
        }
        return packageInfo;
    }

    @Override
    FutureResponse<String> startDiagnosis() throws Exception {
        final SmartLogTail logTail = new SmartLogTail();
        SimpleFutureThread<String> ft = new SimpleFutureThread<String>(this.authCtx){

            @Override
            protected String compute() throws Exception {
                try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Diagnosing Fully Managed deployment", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    String string = AbstractFullyManagedAPIServiceDeploymentManager.this.diagnosis(logTail, this);
                    return string;
                }
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"diag_fully_managed_api_deployment", (String)("Get diagnostic of Fully Managed deployment: " + AbstractFullyManagedAPIServiceDeploymentManager.this.getDeployment().id));
            }

            public SmartLogTail getLog() {
                return logTail.snapshot();
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<String>>(){});
    }

    private String diagnosis(SmartLogTail logTail, FutureThreadBase<?> future) throws Exception {
        String fileFriendlyLocalNow = DKUDateUtils.isoFormatFileFriendlyLocalNow();
        File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer_diag", this.getDeployment().id, "dss-api-diag-" + fileFriendlyLocalNow});
        DKUFileUtils.mkdirs((File)tmpDir);
        ExtraLogFileAppender.setupIfNeeded();
        ExtraLogFileAppender.startLoggingToExtraFile(new File(tmpDir, "diag.log"));
        try {
            String string;
            try (AutoSmartLogTailRedirect asltr = new AutoSmartLogTailRedirect(logTail);){
                string = this.diagnosisInternal(tmpDir, fileFriendlyLocalNow, future);
            }
            return string;
        }
        finally {
            ExtraLogFileAppender.stopLoggingToExtraFile();
        }
    }

    @Override
    void getDiagnosis(HttpServletResponse resp, String diagnosticName) throws Exception {
        File runDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer_diag", this.getDeployment().id, diagnosticName});
        if (runDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + diagnosticName + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoryToStream(runDir, bos);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("Diagnostic dir not found");
        }
    }

    protected abstract String diagnosisInternal(File var1, String var2, FutureThreadBase<?> var3) throws Exception;
}

