/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments.actions.updates;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.apideployer.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.apideployer.deployments.actions.updates.DeploymentUpdateDiff;
import com.dataiku.dip.apideployer.deployments.actions.updates.FileBasedDeploymentUpdateDAO;
import com.dataiku.dip.apideployer.deployments.actions.updates.exceptions.DeploymentUpdateNotFoundException;
import com.dataiku.dip.apideployer.deployments.actions.updates.exceptions.DeploymentUpdateReadException;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.GlobalObjectsJGitService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentUpdateService {
    private final FileBasedDeploymentUpdateDAO dao;
    private final GlobalObjectsJGitService globalGitService;
    private final Set<String> deploymentIdsWithUpdateSavedThisDssSession = new HashSet<String>();
    private static final int STORED_ENTRIES_MAX_COUNT = 100;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.updates.service");

    @Autowired
    public DeploymentUpdateService(FileBasedDeploymentUpdateDAO dao, GlobalObjectsJGitService globalGitService) {
        this.dao = dao;
        this.globalGitService = globalGitService;
    }

    @Nullable
    public Long getLastTimestamp(File parentDir) {
        long timestamp = DKUFileUtils.highestFileNumber((File)parentDir, (String)"");
        return timestamp < 0L ? null : Long.valueOf(timestamp);
    }

    @Nullable
    protected Long getPreviousTimestamp(File parentDir, long timestamp) {
        long previousTimestamp = DKUFileUtils.highestFileNumber((File)parentDir, (String)"", (Long)timestamp);
        return previousTimestamp < 0L ? null : Long.valueOf(previousTimestamp);
    }

    private List<DeploymentUpdate.Head> markRunningHeadsAsUnknown(List<DeploymentUpdate.Head> heads, AbstractDeployment deployment) {
        String deploymentKey = deployment.getKey();
        for (int i = 0; i < heads.size(); ++i) {
            DeploymentUpdate.Head head = heads.get(i);
            if (i == 0 && this.deploymentIdsWithUpdateSavedThisDssSession.contains(deploymentKey)) continue;
            head.markAsUnknownIfRunning();
        }
        return heads;
    }

    public List<DeploymentUpdate.Head> listLastUpdatesHeads(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment) {
        List<DeploymentUpdate.Head> heads = this.dao.listHeads(infra, deployment);
        return this.markRunningHeadsAsUnknown(heads, deployment);
    }

    @Nullable
    public File getLastUpdateLogsFile(AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        Long lastTimestamp = this.getLastTimestamp(this.dao.getUpdatesParentDir(infra, deployment));
        return lastTimestamp == null ? null : this.dao.getUpdateLogsFile(infra, deployment, lastTimestamp);
    }

    public File getUpdateLogsFile(AbstractDeploymentInfra infra, AbstractDeployment deployment, long startTimestamp) {
        return this.dao.getUpdateLogsFile(infra, deployment, startTimestamp);
    }

    @Nullable
    public DeploymentUpdate getUpdate(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) {
        try {
            return this.dao.getMandatory(infra, deployment, timestamp, includesAdminInfo);
        }
        catch (DeploymentUpdateNotFoundException e) {
            logger.warnV((Throwable)e, "No update found for deployment: %s", new Object[]{deployment.id});
        }
        catch (DeploymentUpdateReadException e) {
            logger.errorV((Throwable)e, "Error reading update for deployment: %s", new Object[]{deployment.id});
        }
        return null;
    }

    @Nullable
    public FullDeploymentUpdate getFullUpdate(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) throws IOException {
        return this.dao.getFullMandatory(infra, deployment, timestamp, includesAdminInfo);
    }

    @Nullable
    public DeploymentUpdate getLastUpdate(AbstractDeploymentInfra infra, AbstractDeployment deployment, boolean includesAdminInfo) {
        File parentDir = this.dao.getUpdatesParentDir(infra, deployment);
        Long lastTimestamp = this.getLastTimestamp(parentDir);
        return this.retrieveUpdate(infra, deployment, includesAdminInfo, lastTimestamp);
    }

    @Nullable
    public DeploymentUpdate getPreviousUpdate(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) {
        File parentDir = this.dao.getUpdatesParentDir(infra, deployment);
        Long lastTimestamp = this.getPreviousTimestamp(parentDir, timestamp);
        return this.retrieveUpdate(infra, deployment, includesAdminInfo, lastTimestamp);
    }

    @Nullable
    private DeploymentUpdate retrieveUpdate(AbstractDeploymentInfra infra, AbstractDeployment deployment, boolean includesAdminInfo, Long lastTimestamp) {
        if (lastTimestamp == null) {
            return null;
        }
        DeploymentUpdate update = this.getUpdate(infra, deployment, lastTimestamp, includesAdminInfo);
        if (update != null && update.isInProgress() && !this.deploymentIdsWithUpdateSavedThisDssSession.contains(deployment.getKey())) {
            update.setInProgress(false);
        }
        return update;
    }

    public void saveUpdate(DeploymentUpdate update) {
        File updateFile = this.dao.getUpdateFile(update);
        String absPath = updateFile.getAbsolutePath();
        try {
            this.dao.save(update, updateFile);
            this.deploymentIdsWithUpdateSavedThisDssSession.add(update.getDeployment().getKey());
        }
        catch (IOException e) {
            logger.errorV((Throwable)e, "Exception while storing deployment update at '%s'", new Object[]{absPath});
        }
    }

    public void deleteUpdate(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        this.dao.deleteUpdateDir(infra, deployment, startTimestamp);
    }

    public void deleteAllUpdates(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment) {
        this.dao.deleteAllUpdates(infra, deployment);
    }

    public void deleteUpdatesBeyondLimit(AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        List<File> dirs = this.dao.listDirs(infra, deployment);
        int maxCount = DKUApp.getParams().getIntParam("dku.deployer.storedUpdateEntriesMaxCount", Integer.valueOf(100));
        if (dirs == null || dirs.size() <= maxCount) {
            return;
        }
        int dirsToDeleteCount = dirs.size() - maxCount;
        logger.infoV("Deleting %d directories to maintain the limit of %d stored deployment update entries.", new Object[]{dirsToDeleteCount, maxCount});
        for (int i = 0; i < dirsToDeleteCount; ++i) {
            File dirToDelete = dirs.get(i);
            this.dao.deleteUpdateDir(dirToDelete);
        }
    }

    private AbstractDeployment stripTags(AbstractDeployment deployment) {
        deployment.deploymentTag = null;
        deployment.creationTag = null;
        deployment.versionTag = null;
        return deployment;
    }

    private AbstractDeploymentInfra stripTags(AbstractDeploymentInfra infra) {
        infra.creationTag = null;
        infra.versionTag = null;
        return infra;
    }

    @Nonnull
    public DeploymentUpdateDiff getUpdateSettingsDiff(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, boolean includesInfraDiff) throws IOException {
        String currentInfraJson;
        String updatePath = this.dao.getUpdateDir(infra, deployment, timestamp).getAbsolutePath();
        logger.infoV("Calculating settings diff for update at '%s'", new Object[]{updatePath});
        DeploymentUpdateDiff diff = new DeploymentUpdateDiff(false, new ArrayList<DeploymentUpdateDiff.Item>());
        DeploymentUpdate currentUpdate = this.getUpdate(infra, deployment, timestamp, true);
        if (currentUpdate == null) {
            logger.warnV("Could not retrieve current update for '%s'; returning empty diff", new Object[]{updatePath});
            return diff;
        }
        DeploymentUpdate previousUpdate = this.getPreviousUpdate(infra, deployment, timestamp, true);
        if (previousUpdate == null) {
            logger.warnV("Could not retrieve previous update for '%s'; returning empty diff", new Object[]{updatePath});
            return diff;
        }
        String previousDeploymentJson = JSON.pretty((Object)this.stripTags(previousUpdate.getDeployment()));
        String currentDeploymentJson = JSON.pretty((Object)this.stripTags(currentUpdate.getDeployment()));
        GitModel.FileChange deploymentDiff = this.globalGitService.getStringDiff(previousDeploymentJson, currentDeploymentJson);
        diff.items.add(new DeploymentUpdateDiff.Item("Deployment", deploymentDiff));
        if (currentUpdate.getInfra() == null) {
            logger.warnV("Current deployment update's infra is null for '%s'; returning diff without infra", new Object[]{updatePath});
            return diff;
        }
        if (previousUpdate.getInfra() == null) {
            logger.warnV("Previous deployment update's infra is null for '%s'; returning diff without infra", new Object[]{updatePath});
            return diff;
        }
        String previousInfraJson = JSON.pretty((Object)this.stripTags(previousUpdate.getInfra()));
        GitModel.FileChange infraDiff = this.globalGitService.getStringDiff(previousInfraJson, currentInfraJson = JSON.pretty((Object)this.stripTags(currentUpdate.getInfra())));
        if (!infraDiff.isEmpty()) {
            diff.setHasInfraChange(true);
            if (includesInfraDiff) {
                diff.items.add(new DeploymentUpdateDiff.Item("Infrastructure", infraDiff));
            }
        }
        logger.infoV("Successfully calculated settings diff for update at '%s'", new Object[]{updatePath});
        return diff;
    }

    public AbstractDeploymentHeavyStatus trimHeavyStatus(@Nullable AbstractDeploymentHeavyStatus heavyStatus) {
        if (!(heavyStatus instanceof APIServiceDeploymentHeavyStatus)) {
            return heavyStatus;
        }
        APIServiceDeploymentHeavyStatus apiHeavyStatus = (APIServiceDeploymentHeavyStatus)heavyStatus;
        if (apiHeavyStatus.packages != null) {
            apiHeavyStatus.packages.forEach(p -> {
                if (p instanceof PublishedApiServicePackageInfo) {
                    PublishedApiServicePackageInfo apiPackage = (PublishedApiServicePackageInfo)p;
                    apiPackage.apiKeys = null;
                }
            });
        }
        if (apiHeavyStatus.endpoints != null) {
            apiHeavyStatus.endpoints.forEach(e -> {
                e.testQueries = null;
            });
        }
        return heavyStatus;
    }

    public void saveTrimmedHeavyStatus(long timestamp, AbstractDeploymentInfra infra, AbstractDeployment deployment, @Nullable AbstractDeploymentHeavyStatus heavyStatus) {
        this.dao.saveHeavyStatus(infra, deployment, timestamp, this.trimHeavyStatus(heavyStatus));
    }
}

