/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.cli.AddAdminPublicAPIKeyCommand;
import com.dataiku.dip.cli.AddUserCommand;
import com.dataiku.dip.cli.BuildCommand;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.DatasetDumpCommand;
import com.dataiku.dip.cli.DatasetDumpSchemaCommand;
import com.dataiku.dip.cli.DecryptPasswordCommand;
import com.dataiku.dip.cli.EnableHashedApiKeysCommand;
import com.dataiku.dip.cli.EncryptPasswordCommand;
import com.dataiku.dip.cli.GenerateCryptoKeyCommand;
import com.dataiku.dip.cli.GeoLite2CityUpdateCommand;
import com.dataiku.dip.cli.HiveMetastoreSynchronizeCommand;
import com.dataiku.dip.cli.InstallPluginCommand;
import com.dataiku.dip.cli.RemoveUserCommand;
import com.dataiku.dip.cli.SQLCommand;
import com.dataiku.dip.cli.SQLTableSchemaCommand;
import com.dataiku.dip.cli.SetUserPasswordCommand;
import com.dataiku.dip.cli.TestFormatInputCommand;
import com.dataiku.dip.cli.TestFormatOutputCommand;
import com.dataiku.dip.cli.TwitterCommand;
import com.dataiku.dip.cli.UpdateCurrenciesRatesCommand;
import com.dataiku.dip.cli.internalcmd.BuildCDEPluginCodeEnv;
import com.dataiku.dip.cli.internalcmd.BuildCodeEnvImagesCommand;
import com.dataiku.dip.cli.internalcmd.CheckImpersonationLicenseCommand;
import com.dataiku.dip.cli.internalcmd.EnableGraphicsExportCommand;
import com.dataiku.dip.cli.internalcmd.EnableHadoopCommand;
import com.dataiku.dip.cli.internalcmd.EnableImpersonationCommand;
import com.dataiku.dip.cli.internalcmd.EnableSparkCommand;
import com.dataiku.dip.cli.internalcmd.ImportH2DatabaseToExternalCommand;
import com.dataiku.dip.cli.internalcmd.InitialSetupHome;
import com.dataiku.dip.cli.internalcmd.MigrateDSS20Command;
import com.dataiku.dip.cli.internalcmd.SetMonitoringConfigCommand;
import com.dataiku.dip.cli.internalcmd.SetupDSSVersionInProjectsGitTagCommand;
import com.dataiku.dip.cli.internalcmd.SynchronizeTypeBadgesCommand;
import com.dataiku.dip.cli.internalcmd.UpgradeActivityRrdFilesCommand;
import com.dataiku.dip.cli.internalcmd.V15MigrationCommand;
import com.dataiku.dip.cli.internalcmd.V16MigrationCommand;
import com.dataiku.dip.cli.internalcmd.V17MigrationCommand;
import com.dataiku.dip.cli.internalcmd.V20MigrationCommand;
import com.dataiku.dip.cli.internalcmd.V23MigrationCommand;
import com.dataiku.dip.cli.internalcmd.V6000MigrationCommand;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.util.PoiUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DKU {
    private static Map<String, Class<? extends CLICommand>> commands = new LinkedHashMap<String, Class<? extends CLICommand>>();

    public static void addGlobalOptions(Options opts) {
        opts.addOption("h", false, "Help");
        opts.addOption("v", false, "Verbose mode (enable debug logs)");
    }

    private static int dispatchOnCommand(String command, String[] args) throws Exception {
        Class<? extends CLICommand> cmd = commands.get(command.toLowerCase());
        if (cmd != null) {
            try {
                CLICommand actualCmd = cmd.newInstance();
                int result = actualCmd.execute(args);
                actualCmd.onPostExecute();
                return result;
            }
            catch (EndOfCommandException e) {
                return 0;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 1;
            }
        }
        System.err.println("Unrecognized command : " + command);
        DKU.usage();
        return 1;
    }

    private static void usage() throws Exception {
        System.err.println("Dataiku DSS internal command-line");
        if (System.getenv("DKU_DEBUG_DUMP_COMMANDS") != null) {
            Options gopts = new Options();
            DKU.addGlobalOptions(gopts);
            new HelpFormatter().printHelp("dku [-h] [-v] command args", gopts);
            System.err.println();
            System.err.println("Available commands: ");
            for (Map.Entry<String, Class<? extends CLICommand>> e : commands.entrySet()) {
                System.err.println("  " + e.getKey());
            }
            System.err.println();
            System.err.println("Fore more information about a command, type 'dku command -h'");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        if (System.getenv("DKU_SILENT") != null) {
            Logger.getRootLogger().setLevel(Level.WARN);
        }
        if (System.getenv("DKU_NOTDEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        if (System.getenv("DKU_DEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        BuiltinsLoader.load();
        if (BuiltinsLoader.apachePoiAvailable()) {
            PoiUtils.initializePoi();
        }
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        CommandLine cmdLine = new LenientGNUParser().parse(opts, args);
        if (cmdLine.getArgs().length == 0) {
            DKU.usage();
        } else {
            String command = cmdLine.getArgs()[0];
            System.exit(DKU.dispatchOnCommand(command, args));
        }
    }

    static {
        commands.put("add-user", AddUserCommand.class);
        commands.put("remove-user", RemoveUserCommand.class);
        commands.put("user-set-password", SetUserPasswordCommand.class);
        commands.put("install-plugin", InstallPluginCommand.class);
        commands.put("add-admin-api-key", AddAdminPublicAPIKeyCommand.class);
        commands.put("update-currency-rates", UpdateCurrenciesRatesCommand.class);
        commands.put("geoip-update", GeoLite2CityUpdateCommand.class);
        commands.put("dataset-dump", DatasetDumpCommand.class);
        commands.put("dataset-dump-schema", DatasetDumpSchemaCommand.class);
        commands.put("encrypt-password", EncryptPasswordCommand.class);
        commands.put("get-cleartext-password", DecryptPasswordCommand.class);
        commands.put("generate-crypto-key", GenerateCryptoKeyCommand.class);
        commands.put("enable-hashed-api-keys", EnableHashedApiKeysCommand.class);
        commands.put("hive-metastore-synchronize", HiveMetastoreSynchronizeCommand.class);
        commands.put("build", BuildCommand.class);
        commands.put("sql-table-schema", SQLTableSchemaCommand.class);
        commands.put("sql", SQLCommand.class);
        commands.put("twitter", TwitterCommand.class);
        commands.put("test-format-input", TestFormatInputCommand.class);
        commands.put("test-format-output", TestFormatOutputCommand.class);
        commands.put("__initial-setup-home", InitialSetupHome.class);
        commands.put("__migrate_dss20", MigrateDSS20Command.class);
        commands.put("__migrate_v15", V15MigrationCommand.class);
        commands.put("__migrate_v16", V16MigrationCommand.class);
        commands.put("__migrate_v17", V17MigrationCommand.class);
        commands.put("__migrate_v20", V20MigrationCommand.class);
        commands.put("__migrate_v23", V23MigrationCommand.class);
        commands.put("__migrate_v6000", V6000MigrationCommand.class);
        commands.put("__enable-spark", EnableSparkCommand.class);
        commands.put("__enable-hadoop", EnableHadoopCommand.class);
        commands.put("__enable-impersonation", EnableImpersonationCommand.class);
        commands.put("__enable-graphics-export", EnableGraphicsExportCommand.class);
        commands.put("__check-impersonation-license", CheckImpersonationLicenseCommand.class);
        commands.put("__set-monitoring-config", SetMonitoringConfigCommand.class);
        commands.put("__build-code-env-images", BuildCodeEnvImagesCommand.class);
        commands.put("__import_h2_to_external", ImportH2DatabaseToExternalCommand.class);
        commands.put("__setup_dss_version_in_projects_git", SetupDSSVersionInProjectsGitTagCommand.class);
        commands.put("__upgrade_activity_rrd_files", UpgradeActivityRrdFilesCommand.class);
        commands.put("__synchronize_type_badges", SynchronizeTypeBadgesCommand.class);
        commands.put("__build_cde_plugin_code_env", BuildCDEPluginCodeEnv.class);
    }

    static class EndOfCommandException
    extends IOException {
        EndOfCommandException() {
        }
    }

    public static class LenientGNUParser
    extends GnuParser {
        protected void processOption(String arg, ListIterator iter) throws ParseException {
            boolean hasOption = this.getOptions().hasOption(arg);
            if (hasOption) {
                super.processOption(arg, iter);
            }
        }
    }
}

