/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Splitter;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class ConfigurableYarnApplicationStatus {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage : applicationId listOfKeyValuePairs");
        }
        String yarnAppId = args[0];
        List extraConf = (List)JSON.parse((String)args[1], (TypeToken)new TypeToken<List<ClusterProperty>>(){});
        YarnConfiguration conf = new YarnConfiguration();
        for (ClusterProperty property : extraConf) {
            conf.set(property.key, property.value);
        }
        try (YarnClient client = YarnClient.createYarnClient();){
            client.init((Configuration)conf);
            client.start();
            List chunks = Splitter.on((char)'_').trimResults().splitToList((CharSequence)yarnAppId.substring("application_".length()));
            ApplicationId applicationId = ApplicationId.newInstance((long)Long.parseLong((String)chunks.get(0)), (int)Integer.parseInt((String)chunks.get(1)));
            ApplicationReport appReport = client.getApplicationReport(applicationId);
            System.out.println("appReport.getUser() = " + appReport.getUser());
        }
        catch (IOException | YarnException e) {
            System.err.println("Failed to get app status");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

