/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FilesBasedConnectionsDAO;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.git.ProjectCommitModeService;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveExecutionConfig;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.BackendVariablesService;
import com.google.common.collect.Sets;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class EnableHadoopCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark");

    @Override
    public String usageString() {
        return "__enable-hadoop";
    }

    @Override
    public String description() {
        return "";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__enable-hadoop", false);
        Logger.getLogger((String)"org.springframework").setLevel(Level.WARN);
        ApplicationConfigurator.autoconfigure();
        AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();
        appContext.register(new Class[]{SpringUtils.class});
        appContext.register(new Class[]{DKUTransactionService.class});
        appContext.register(new Class[]{GeneralSettingsDAO.class});
        appContext.register(new Class[]{BackendVariablesService.class});
        appContext.register(new Class[]{ProjectCommitModeService.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{FilesBasedConnectionsDAO.class});
        appContext.refresh();
        try (DKUTransactionService ts = new DKUTransactionService();
             RWTransaction rwt = ts.beginWriteAsDSS();){
            String flavor;
            if (!HadoopLoader.hadoopEnabled()) {
                throw new IllegalArgumentException("Hadoop  not enabled, can't configure it");
            }
            String username = System.getProperty("user.name");
            ConnectionsDAO connectionsDAO = (ConnectionsDAO)appContext.getBean(ConnectionsDAO.class);
            Map<String, DSSConnection> connections = connectionsDAO.list();
            boolean addConnections = true;
            for (DSSConnection c2 : connections.values()) {
                if (!(c2 instanceof HDFSConnection)) continue;
                logger.info((Object)"Already have HDFS connections, not adding any");
                addConnections = false;
                break;
            }
            if (System.getenv("DKU_INITIAL_SETUP_NO_HDFS_CONNECTIONS") != null) {
                addConnections = false;
            }
            boolean didAnything = false;
            if (addConnections) {
                HDFSConnection hdfsRoot = new HDFSConnection();
                hdfsRoot.name = "hdfs_root";
                hdfsRoot.params.setRoot("/");
                hdfsRoot.params.defaultDatabase = "dataiku";
                hdfsRoot.params.hiveSynchronizationMode = HDFSConnection.HiveSynchronizationMode.KEEP_IN_SYNC;
                hdfsRoot.allowManagedDatasets = false;
                hdfsRoot.allowWrite = false;
                connections.put("hdfs_root", hdfsRoot);
                HDFSConnection hdfsManaged = new HDFSConnection();
                hdfsManaged.name = "hdfs_managed";
                hdfsManaged.params.setRoot("/user/" + username + "/dss_managed_datasets");
                hdfsManaged.params.defaultDatabase = "dataiku";
                hdfsManaged.params.hiveSynchronizationMode = HDFSConnection.HiveSynchronizationMode.KEEP_IN_SYNC;
                hdfsManaged.params.namingRule.hdfsPathDatasetNamePrefix = "${projectKey}/";
                connections.put("hdfs_managed", hdfsManaged);
                connectionsDAO.writeList(connections);
                didAnything = true;
            }
            GeneralSettingsDAO.GeneralSettings settings = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafe();
            boolean mustSaveGeneralSettings = false;
            if (System.getenv("DKU_INITIAL_SETUP_DISABLE_HIVE") != null) {
                settings.hiveSettings.enabled = false;
                mustSaveGeneralSettings = true;
            }
            if (settings.hiveSettings.executionConfigs.size() == 0) {
                HiveExecutionConfig execConfig = new HiveExecutionConfig();
                execConfig.name = "default";
                settings.hiveSettings.executionConfigs.add(execConfig);
                mustSaveGeneralSettings = true;
            } else {
                logger.info((Object)"Already have Hive configurations, not adding any");
            }
            boolean securityEnabled = Boolean.parseBoolean(cmdLine.getArgs()[1]);
            String keytab = null;
            String principal = null;
            if (securityEnabled) {
                keytab = cmdLine.getArgs().length > 2 ? cmdLine.getArgs()[2] : null;
                principal = cmdLine.getArgs().length > 3 ? cmdLine.getArgs()[3] : null;
            }
            logger.info((Object)("securityEnabled=" + securityEnabled + " keytab=" + keytab + " principal=" + principal));
            if (!StringUtils.isBlank(keytab) && !StringUtils.isBlank(principal)) {
                logger.info((Object)"Enabling Kerberos login");
                settings.hadoopSettings.kerberosLoginEnabled = true;
                settings.hadoopSettings.dssKeytabPath = keytab;
                settings.hadoopSettings.dssPrincipal = principal;
                mustSaveGeneralSettings = true;
            }
            if (StringUtils.isNotBlank((String)(flavor = System.getenv("DKU_HADOOP_FLAVOR"))) && Sets.newHashSet((Object[])new String[]{"hdp"}).contains(flavor)) {
                settings.hiveSettings.canChart = true;
            }
            if (mustSaveGeneralSettings) {
                ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).save(settings);
                didAnything = true;
            }
            if (didAnything) {
                rwt.commit("CLI: Enabled Hadoop integration (from command-line)");
            }
        }
        appContext.close();
        return 0;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }
}

