/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.security.INonImpersonatedKernel;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ClusterDependentKernelHandle
extends DSSKernelBase
implements INonImpersonatedKernel {
    private final String prefix;
    private final String kernelId;
    private final String key;
    private int refCount = 0;
    private long lastTouched = 0L;
    protected LocalPrivilegedIntercomAPIClient apiClient;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.kernels.cluster_dependent");

    public ClusterDependentKernelHandle(String prefix, String kernelId, String key) {
        super(prefix.toUpperCase() + "-" + kernelId);
        this.prefix = prefix;
        this.kernelId = kernelId;
        this.key = key;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getKey() {
        return this.key;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public int incRefCount() {
        return ++this.refCount;
    }

    public int decRefCount() {
        return --this.refCount;
    }

    public synchronized LocalPrivilegedIntercomAPIClient getAPIClient() {
        return this.apiClient;
    }

    public synchronized void setAPIClient(LocalPrivilegedIntercomAPIClient apiClient) {
        this.apiClient = apiClient;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public long getLastTouched() {
        return this.lastTouched;
    }

    public synchronized void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public synchronized long getIdle() {
        return System.currentTimeMillis() - this.lastTouched;
    }

    public synchronized void acquireNow() {
    }

    public synchronized void releaseNow() {
    }

    protected abstract ProcessBuilder getProcessBuilder(ClusterSettings var1) throws Exception;

    protected abstract List<AutoCloseable> getProcessResourcesToClose();

    protected abstract File getRunDir();

    protected abstract void ping() throws Exception;

    public void start(ClusterSettings clusterSettings) throws Exception {
        ProcessBuilder pb = this.getProcessBuilder(clusterSettings);
        logger.info((Object)("Starting " + this.prefix + " kernel " + this.kernelId));
        if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(pb.environment());
        }
        SharedSecretUtils.getSharedSecret((boolean)true);
        File runDir = this.getRunDir();
        if (runDir == null) {
            runDir = ApplicationConfigurator.getBaseFolderF();
        }
        this.process = new RegularProcess(pb, runDir);
        this.process.start();
        this.startStandardTailers();
        this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
        this.monitorThread.setCloseOnFailure(new Closeable(){

            @Override
            public void close() throws IOException {
                for (AutoCloseable toClose : ClusterDependentKernelHandle.this.getProcessResourcesToClose()) {
                    try {
                        toClose.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to cleanup " + String.valueOf(toClose)), (Throwable)e);
                    }
                }
            }
        });
        this.monitorThread.start();
        this.waitForPort();
        this.setAPIClient(new LocalPrivilegedIntercomAPIClient(this.port));
        this.touch();
    }

    protected abstract void tryThrowingError() throws Exception;

    protected void waitForPort() throws Exception {
        int loops = 0;
        while (true) {
            ++loops;
            Thread.sleep(300L);
            if (this.process == null) {
                logger.error((Object)(this.prefix + " kernel process died before start"));
                this.tryThrowingError();
                throw new Exception(this.prefix + " kernel process died before start", this.processExitException);
            }
            try {
                int foundPort = this.getPort();
                if (foundPort <= 0) continue;
                logger.info((Object)(this.prefix + " kernel registered on port : " + this.port));
            }
            catch (Exception e) {
                if (loops % 10 != 5) continue;
                logger.info((Object)(this.prefix + " kernel is not yet ready: "), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public synchronized void onRegister(int port) {
        this.port = port;
    }
}

