/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ConnectionCredentialsCRUDService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class PerUserOAuth2Helper {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.oauth2");

    public static OAuth2Client.AccessTokenResult getAccessTokenFromRefreshTokenAndUpdateIfNeeded(AuthCtx authCtx, OAuth2Client oAuth2Client, String refreshToken, boolean useOIDCIdToken, boolean expectsTokenRotation, String credentialsKey, String kind) throws URISyntaxException, IOException, ParseException, DKUSecurityException {
        PerfUtils.markSlowCode();
        String userString = authCtx == null ? "n/a" : authCtx.getIdentifier();
        String keyString = String.format("%s '%s'", kind, credentialsKey);
        PerUserOAuth2Helper.extractTokenAsJWTWithoutSignature(refreshToken).ifPresent(jwt -> logger.debug((Object)("Refresh token JWT without signature: " + jwt)));
        OAuth2Client.AccessTokenResult result = oAuth2Client.acquireAccessTokenResultFromRefreshToken(authCtx, refreshToken, credentialsKey, useOIDCIdToken);
        PerUserOAuth2Helper.extractTokenAsJWTWithoutSignature(result.getAccessToken()).ifPresent(jwt -> logger.debug((Object)("access token JWT without signature: " + jwt)));
        String newRefreshToken = result.getRefreshToken();
        if (StringUtils.isEmpty((String)newRefreshToken)) {
            logger.infoV("No refresh token returned with access token from %s for '%s'", new Object[]{keyString, userString});
            result = result.withUpdatedRefreshToken(refreshToken);
        } else if (!newRefreshToken.equals(refreshToken)) {
            PerUserOAuth2Helper.extractTokenAsJWTWithoutSignature(newRefreshToken).ifPresent(jwt -> logger.debug((Object)("New refresh token JWT without signature: " + jwt)));
            if (!expectsTokenRotation) {
                logger.warnV("Refresh token rotation detected but %s doesn't declare it. Subsequent requests for access tokens by '%s' may fail", new Object[]{keyString, userString});
                return result;
            }
            if (ApplicationConfigurator.getProcessType() != MainLoggingConfigurator.ProcessType.BACKEND) {
                logger.warnV("Refresh token for '%s' on %s was changed but can't be saved back outside backend. Subsequent requests for access tokens are likely to fail", new Object[]{userString, keyString});
            } else if (TransactionContext.hasAttachedTransaction()) {
                logger.warnV("Refresh token for '%s' on %s was changed but can't be saved back from existing transaction. Subsequent requests for access tokens are likely to fail", new Object[]{userString, keyString});
            } else {
                logger.infoV("Refresh token for '%s' on %s changed, save it", new Object[]{userString, keyString});
                try {
                    ConnectionCredentialsCRUDService cs2 = (ConnectionCredentialsCRUDService)SpringUtils.getBean(ConnectionCredentialsCRUDService.class);
                    cs2.storeOAuth2RefreshToken_NT(authCtx, newRefreshToken, credentialsKey);
                }
                catch (CodedException | IOException e) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to save OAuth2 refresh token to user's credentials", e);
                }
            }
        } else {
            logger.infoV("Refresh token unchanged from %s for '%s'", new Object[]{keyString, userString});
        }
        return result;
    }

    public static Optional<String> extractTokenAsJWTWithoutSignature(String token) {
        if (token == null || !token.contains(".")) {
            return Optional.empty();
        }
        String[] parts = token.split("\\.");
        if (parts.length < 2) {
            return Optional.empty();
        }
        return Optional.of(parts[0] + "." + parts[1] + ".[SIGNATURE_REMOVED]");
    }
}

