/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.KerberizableConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.sql.TeradataDatasetConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;

public class TeradataConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
KerberizableConnection {
    public static final String connectionType = "Teradata";
    public Params params = new Params();
    private static TeradataSQLDialect dialect;

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public TeradataSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new TeradataSQLDialect();
        }
        return dialect;
    }

    @Override
    public boolean mayBeSavedAsPersonalConnectionByNonAdmin() {
        return true;
    }

    @Override
    String getDriver() {
        return "com.teradata.jdbc.TeraDriver";
    }

    @Override
    String getJdbcUrl() {
        throw new RuntimeException("You should not call this");
    }

    @Override
    String getDisplayableJdbcUrl() {
        if (this.params.useURL) {
            return StringUtils.isNotBlank((CharSequence)this.params.displayedUrl) ? this.params.displayedUrl : this.params.url;
        }
        if (this.params.kerberosLoginEnabled) {
            String url = "jdbc:teradata://" + this.params.host + "/LOGMECH=KRB5";
            if (StringUtils.isNotBlank((CharSequence)this.params.defaultDatabase)) {
                url = url + ",DATABASE=" + this.params.defaultDatabase;
            }
            return url;
        }
        String url = "jdbc:teradata://" + this.params.host + "/USER=" + this.params.user + ",PASSWORD=***";
        if (StringUtils.isNotBlank((CharSequence)this.params.defaultDatabase)) {
            url = url + ",DATABASE=" + this.params.defaultDatabase;
        }
        return url;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
        SQLConnectionProvider.TeradataSQLConnectionData cd = new SQLConnectionProvider.TeradataSQLConnectionData(ConnectionUtils.SQLConnectionType.TERADATA, (SQLDialect)new TeradataSQLDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJarsDirectory(), creds);
        this.fillConnectionData(cd);
        return cd;
    }

    @Override
    public boolean isKerberosLoginEnabled() {
        return this.params.kerberosLoginEnabled;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return !this.params.kerberosLoginEnabled;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        return super.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (this.params.kerberosLoginEnabled) {
            ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Kerberos login isn't compatible with direct access from Spark");
        }
        return ret;
    }

    private static String untrust(String untrustedSQL) {
        return "{fn teradata_untrusted}" + untrustedSQL;
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 3306;
        public String defaultDatabase;
        public boolean kerberosLoginEnabled;
        public String dssPrincipal;
        public String dssKeytabPath;
        public TeradataDatasetConfig.PrimaryIndexBehavior defaultPrimaryIndexBehavior = TeradataDatasetConfig.PrimaryIndexBehavior.AUTO;
        public String defaultAssumedDbTzForUnknownTz;
    }

    public static class TeradataUntrustedStatement
    implements Statement {
        private final Statement underlying;

        public TeradataUntrustedStatement(Statement underlying) {
            this.underlying = underlying;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.underlying.unwrap(iface);
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            return this.underlying.executeQuery(TeradataConnection.untrust(sql));
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.underlying.isWrapperFor(iface);
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            return this.underlying.executeUpdate(TeradataConnection.untrust(sql));
        }

        @Override
        public void close() throws SQLException {
            this.underlying.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.underlying.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.underlying.setMaxFieldSize(max);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.underlying.getMaxRows();
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.underlying.setMaxRows(max);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.underlying.setEscapeProcessing(enable);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.underlying.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.underlying.setQueryTimeout(seconds);
        }

        @Override
        public void cancel() throws SQLException {
            this.underlying.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.underlying.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.underlying.clearWarnings();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.underlying.setCursorName(name);
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            return this.underlying.execute(TeradataConnection.untrust(sql));
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.underlying.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.underlying.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.underlying.getMoreResults();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.underlying.setFetchDirection(direction);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.underlying.getFetchDirection();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.underlying.setFetchSize(rows);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.underlying.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.underlying.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.underlying.getResultSetType();
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.underlying.addBatch(TeradataConnection.untrust(sql));
        }

        @Override
        public void clearBatch() throws SQLException {
            this.underlying.clearBatch();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return this.underlying.executeBatch();
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.underlying.getConnection();
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.underlying.getMoreResults(current);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.underlying.getGeneratedKeys();
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            return this.underlying.executeUpdate(TeradataConnection.untrust(sql), autoGeneratedKeys);
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            return this.underlying.executeUpdate(TeradataConnection.untrust(sql), columnIndexes);
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            return this.underlying.executeUpdate(TeradataConnection.untrust(sql), columnNames);
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            return this.underlying.execute(TeradataConnection.untrust(sql), autoGeneratedKeys);
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            return this.underlying.execute(TeradataConnection.untrust(sql), columnIndexes);
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            return this.underlying.execute(TeradataConnection.untrust(sql), columnNames);
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.underlying.getResultSetHoldability();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.underlying.isClosed();
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.underlying.setPoolable(poolable);
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.underlying.isPoolable();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.underlying.closeOnCompletion();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.underlying.isCloseOnCompletion();
        }
    }

    public static class TeradataSQLConnectionWrapper
    extends SQLConnectionProvider.SQLConnectionWrapper {
        public TeradataSQLConnectionWrapper(SQLConnectionProvider.SQLConnectionData connData, Connection connection, String debugId, boolean verboseRollback, SQLConnectionProvider.ConnectionCloser connectionCloser) {
            super(connData, connection, debugId, verboseRollback, connectionCloser);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return new TeradataUntrustedStatement(this.connection.createStatement());
        }

        public Statement createTrustedStatement(boolean iKnowWhatIAmDoing) throws SQLException {
            assert (iKnowWhatIAmDoing);
            return this.connection.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return new TeradataUntrustedStatement(this.connection.createStatement(resultSetType, resultSetConcurrency));
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connection.prepareStatement(TeradataConnection.untrust(sql));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connection.prepareStatement(TeradataConnection.untrust(sql), resultSetType, resultSetConcurrency);
        }
    }
}

