/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.yaml.snakeyaml.Yaml;

public class FilteredStrLookup
extends StrLookup {
    private List<JsonObject> sources = Lists.newArrayList();
    private Map<String, StrLookupFilter> filters = Maps.newHashMap();

    public String lookup(String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Empty substitution");
        }
        JsonElement value = null;
        boolean first = true;
        for (String part : key.split("\\|")) {
            part = part.trim();
            if (first) {
                for (JsonObject source : this.sources) {
                    if (!source.has(part)) continue;
                    value = source.get(part);
                    break;
                }
            } else {
                String name;
                int colonPos = part.indexOf(58);
                String parameters = colonPos < 0 ? null : part.substring(colonPos + 1).trim();
                String string = name = colonPos < 0 ? part : part.substring(0, colonPos).trim();
                if (!this.filters.containsKey(name)) {
                    throw new IllegalArgumentException("Unknown filter " + name);
                }
                try {
                    value = this.filters.get(name).apply(value, parameters);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Filter " + name + " failed to apply: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            first = false;
        }
        return value == null ? "" : value.getAsString();
    }

    public FilteredStrLookup withValues(JsonObject ... sources) {
        this.sources.addAll(Lists.newArrayList((Object[])sources));
        return this;
    }

    public FilteredStrLookup withFilters(StrLookupFilter ... filters) {
        for (StrLookupFilter filter : filters) {
            this.filters.put(filter.getName(), filter);
        }
        return this;
    }

    public static interface StrLookupFilter {
        public String getName();

        public JsonElement apply(JsonElement var1, String var2) throws IOException;
    }

    public static class YamlifierFilter
    implements StrLookupFilter {
        @Override
        public String getName() {
            return "yaml";
        }

        @Override
        public JsonElement apply(JsonElement value, String parameters) throws IOException {
            String yaml = new Yaml().dump(JSON.toJavaLongPreserving((JsonElement)value));
            return new JsonPrimitive(yaml.trim());
        }
    }

    public static class PadderFilter
    implements StrLookupFilter {
        @Override
        public String getName() {
            return "pad";
        }

        @Override
        public JsonElement apply(JsonElement value, String parameters) throws IOException {
            if (StringUtils.isBlank((String)parameters)) {
                throw new IllegalArgumentException("padding not specified");
            }
            int paddingLength = 0;
            try {
                paddingLength = Integer.parseInt(parameters.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid padding", e);
            }
            String unpadded = value == null || value.isJsonNull() ? "" : value.getAsString();
            char[] paddingChars = new char[paddingLength];
            Arrays.fill(paddingChars, ' ');
            String padding = new String(paddingChars);
            return new JsonPrimitive(padding + Joiner.on((String)("\n" + padding)).join((Object[])unpadded.split("\n")));
        }
    }

    public static class KeyValueToMapFilter
    implements StrLookupFilter {
        @Override
        public String getName() {
            return "kv2map";
        }

        @Override
        public JsonElement apply(JsonElement value, String parameters) throws IOException {
            if (value == null || value.isJsonNull()) {
                return value;
            }
            if (!value.isJsonArray()) {
                throw new IllegalArgumentException("Expecting a list of key-values");
            }
            JsonArray array = value.getAsJsonArray();
            JsonObject map = new JsonObject();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new IllegalArgumentException("Expecting a list of objects");
                }
                JsonObject elemObj = elem.getAsJsonObject();
                if (elemObj.has("from")) {
                    map.add(elemObj.get("from").getAsString(), elemObj.get("to"));
                    continue;
                }
                if (elemObj.has("key")) {
                    map.add(elemObj.get("key").getAsString(), elemObj.get("value"));
                    continue;
                }
                throw new IllegalArgumentException("Expecting a list of {from,to} or {key/value}");
            }
            return map;
        }
    }
}

