/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards;

import com.dataiku.dip.dashboards.insights.tiles.IFrameTileParams;
import com.dataiku.dip.dashboards.insights.tiles.TextTileParams;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dashboards.model.TileParams;
import com.dataiku.dip.dashboards.model.TilesGrid;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TileDeserializer implements JsonDeserializer<Tile>
{
    INSTANCE;

    private static final Map<String, Class<? extends TileParams>> paramsMap;

    public static void registerType(String type, Class<? extends TileParams> paramsClass) {
        paramsMap.put(type, paramsClass);
    }

    public Tile deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement paramJson;
        Tile ret = new Tile();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.has("tileType")) {
            ret.tileType = (Tile.TileType)((Object)JSON.parse((JsonElement)jsonObj.get("tileType"), Tile.TileType.class));
        }
        if (jsonObj.has("box")) {
            ret.box = (Tile.Box)JSON.parse((JsonElement)jsonObj.get("box"), Tile.Box.class);
        }
        if (jsonObj.has("clickAction")) {
            ret.clickAction = (Tile.TileClickAction)((Object)JSON.parse((JsonElement)jsonObj.get("clickAction"), Tile.TileClickAction.class));
        }
        if (jsonObj.has("targetInsightId")) {
            ret.targetInsightId = jsonObj.get("targetInsightId").getAsString();
        }
        if (jsonObj.has("autoLoad")) {
            ret.autoLoad = jsonObj.get("autoLoad").getAsBoolean();
        }
        if (jsonObj.has("locked")) {
            ret.locked = jsonObj.get("locked").getAsBoolean();
        }
        if (jsonObj.has("insightId")) {
            ret.insightId = jsonObj.get("insightId").getAsString();
        }
        if (jsonObj.has("insightType")) {
            ret.insightType = jsonObj.get("insightType").getAsString();
        }
        if (jsonObj.has("backgroundOpacity")) {
            ret.backgroundOpacity = jsonObj.get("backgroundOpacity").getAsFloat();
        }
        if (jsonObj.has("backgroundColor")) {
            ret.backgroundColor = jsonObj.get("backgroundColor").getAsString();
        }
        if (jsonObj.has("displayMode")) {
            ret.displayMode = (Tile.TileDisplayMode)((Object)JSON.parse((JsonElement)jsonObj.get("displayMode"), Tile.TileDisplayMode.class));
        }
        if (jsonObj.has("imageId")) {
            ret.imageId = jsonObj.get("imageId").getAsString();
        }
        if (jsonObj.has("resizeImageMode")) {
            ret.resizeImageMode = (Tile.TileResizeImageMode)((Object)JSON.parse((JsonElement)jsonObj.get("resizeImageMode"), Tile.TileResizeImageMode.class));
        }
        if (jsonObj.has("borderOptions")) {
            ret.borderOptions = (Tile.BorderOptions)JSON.parse((JsonElement)jsonObj.get("borderOptions"), Tile.BorderOptions.class);
        }
        if (jsonObj.has("titleOptions")) {
            ret.titleOptions = (Tile.TitleOptions)JSON.parse((JsonElement)jsonObj.get("titleOptions"), Tile.TitleOptions.class);
        }
        if (jsonObj.has("grid")) {
            ret.grid = (TilesGrid)JSON.parse((JsonElement)jsonObj.get("grid"), TilesGrid.class);
        }
        if (jsonObj.has("tileSpacing")) {
            ret.tileSpacing = jsonObj.get("tileSpacing").getAsInt();
        }
        if (jsonObj.has("padding")) {
            ret.padding = jsonObj.get("padding").getAsInt();
        }
        if (jsonObj.has("useDashboardSpacing")) {
            ret.useDashboardSpacing = jsonObj.get("useDashboardSpacing").getAsBoolean();
        }
        if ((paramJson = jsonObj.get("tileParams")) != null) {
            switch (ret.tileType) {
                case INSIGHT: {
                    Class<? extends TileParams> paramsClass = paramsMap.get(ret.insightType);
                    if (paramsClass == null) {
                        throw new JsonParseException("Insight type " + ret.insightType + " is unknown");
                    }
                    ret.tileParams = (TileParams)jsonDeserializationContext.deserialize(paramJson, paramsClass);
                    break;
                }
                case TEXT: {
                    ret.tileParams = (TileParams)jsonDeserializationContext.deserialize(paramJson, TextTileParams.class);
                    break;
                }
                case IFRAME: {
                    ret.tileParams = (TileParams)jsonDeserializationContext.deserialize(paramJson, IFrameTileParams.class);
                    break;
                }
            }
        }
        return ret;
    }

    static {
        JSON.registerAdapter(Tile.class, (Object)((Object)INSTANCE));
        paramsMap = Collections.synchronizedMap(new HashMap());
    }
}

