/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.data.geo;

import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AdminGeoDataUtils {
    private static Logger logger = Logger.getLogger((String)"dku.shaker.geo");

    public static Schema getAvroSchema() {
        return (Schema)SchemaBuilder.record((String)"geoadmin").fields().name("index").type().intType().noDefault().name("isoCode").type().stringType().stringDefault("").name("enName").type().stringType().noDefault().name("localName").type().stringType().noDefault().endRecord();
    }

    public static DataStore getDataStore(File resourceFolder, int level) throws IOException {
        File shapeFile = new File(resourceFolder, "shp_" + level + ".shp");
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", shapeFile.toURL());
        return DataStoreFinder.getDataStore(map);
    }

    public static SimpleFeatureSource getSource(DataStore dataStore) throws IOException {
        String typeName = dataStore.getTypeNames()[0];
        return dataStore.getFeatureSource(typeName);
    }

    public static void fillLeaf(SimpleFeature feat, TreeLeafBase leaf) {
        leaf.geom = (Geometry)feat.getDefaultGeometry();
        leaf.env = leaf.geom.getEnvelopeInternal();
        leaf.dataIndex = (Integer)feat.getAttribute("idx");
    }

    public static boolean contains(TreeLeafBase leaf, Geometry geom) {
        if (!leaf.env.contains(geom.getEnvelopeInternal())) {
            return false;
        }
        if (leaf.prep == null) {
            leaf.prep = PreparedGeometryFactory.prepare((Geometry)leaf.geom);
        }
        return leaf.prep.contains(geom);
    }

    public static AdminGeoData getData(File resourceFolder, int level) throws Exception {
        File avroFile = new File(resourceFolder, "data_" + level + ".avro");
        AdminGeoData ret = new AdminGeoData();
        GenericDatumReader datumReader = new GenericDatumReader(AdminGeoDataUtils.getAvroSchema());
        DataFileReader dataFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        while (dataFileReader.hasNext()) {
            GenericRecord record = (GenericRecord)dataFileReader.next();
            ret.data.put((Integer)record.get("index"), record);
        }
        dataFileReader.close();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File inputFolder = new File(System.getenv("DKUINSTALLDIR"), "plugins/geoadmin/srcdata");
        File outputFolder = new File(System.getenv("DKUINSTALLDIR"), "plugins/geoadmin/resource");
        ArrayList<DataFileWriter> avroWriters = new ArrayList<DataFileWriter>();
        ArrayList<MemoryFeatureCollection> collections = new ArrayList<MemoryFeatureCollection>();
        collections.add(null);
        collections.add(null);
        avroWriters.add(null);
        avroWriters.add(null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.setDefaultGeometry("the_geom");
        builder.add("the_geom", MultiPolygon.class);
        builder.add("idx", Integer.class);
        SimpleFeatureType TYPE = builder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        Schema avroSchema = AdminGeoDataUtils.getAvroSchema();
        int assignedIdx = 0;
        for (int i = 2; i <= 8; ++i) {
            MemoryFeatureCollection mfc = new MemoryFeatureCollection(TYPE);
            File f = new File(outputFolder, "data_" + i + ".avro");
            GenericDatumWriter datumWriter = new GenericDatumWriter(avroSchema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
            dataFileWriter.setCodec(CodecFactory.snappyCodec());
            dataFileWriter.create(avroSchema, f);
            collections.add(mfc);
            avroWriters.add(dataFileWriter);
        }
        logger.info((Object)"Load OSM data");
        WKTReader reader = new WKTReader();
        RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)new GZIPInputStream(new FileInputStream(new File(inputFolder, "osm-geocoder-data.csv.gz"))), "utf8"), ',');
        ArrayList<String> out = new ArrayList<String>();
        HashMap<String, Map<String, String>> osmCountryData = new HashMap<String, Map<String, String>>();
        int read = 0;
        while (parser.next(out)) {
            String polygonWkt = (String)out.get(0);
            if (StringUtils.isBlank((String)polygonWkt)) continue;
            try {
                int adminLevel = Integer.parseInt((String)out.get(1));
                if (adminLevel > 8) continue;
                Geometry geom = reader.read(polygonWkt);
                Map<String, String> map = AdminGeoDataUtils.cleanupData(JSON.parseToMap((String)((String)out.get(3))));
                if (adminLevel == 2) {
                    String iso = map.get("ISO3166-1:alpha2");
                    if (iso == null) {
                        iso = map.get("ISO3166-1");
                    }
                    if (iso != null) {
                        osmCountryData.put(iso, map);
                    } else {
                        logger.warn((Object)("COUNTRY WITH NO ISO CODE " + JSON.json(map)));
                    }
                } else {
                    GenericData.Record record = new GenericData.Record(avroSchema);
                    record.put("index", (Object)assignedIdx);
                    if (map.containsKey("name:en")) {
                        record.put("enName", (Object)map.get("name:en"));
                    } else if (map.containsKey("name")) {
                        record.put("enName", (Object)map.get("name"));
                    } else {
                        record.put("enName", (Object)"");
                    }
                    if (map.containsKey("name")) {
                        record.put("localName", (Object)map.get("name"));
                    } else {
                        record.put("localName", (Object)"");
                    }
                    record.put("isoCode", (Object)"");
                    ((DataFileWriter)avroWriters.get(adminLevel)).append((Object)record);
                    featureBuilder.add((Object)geom);
                    featureBuilder.add((Object)assignedIdx);
                    ((MemoryFeatureCollection)collections.get(adminLevel)).add(featureBuilder.buildFeature(null));
                    ++assignedIdx;
                }
            }
            catch (Exception e) {
                logger.info((Object)("FAILED TO READ LINE " + StringUtils.join(out, (String)",")), (Throwable)e);
            }
            if (++read % 10000 != 0) continue;
            logger.info((Object)("Loaded " + read + " polygons"));
        }
        logger.info((Object)"Building non-country trees");
        for (int i = 3; i <= 8; ++i) {
            logger.info((Object)("  L" + i + ": building"));
            AdminGeoDataUtils.writeSHP(TYPE, new File(outputFolder, "shp_" + i + ".shp"), (MemoryFeatureCollection)collections.get(i));
            ((DataFileWriter)avroWriters.get(i)).close();
            logger.info((Object)("  L" + i + ": done"));
        }
        logger.info((Object)"Loading countries data");
        File file = new File(inputFolder, "ne_10m_admin_0_countries.shp");
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", file.toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(map);
        try {
            String typeName = dataStore.getTypeNames()[0];
            SimpleFeatureSource source = dataStore.getFeatureSource(typeName);
            try (FeatureIterator it = source.getFeatures().features();){
                while (it.hasNext()) {
                    SimpleFeature feat = (SimpleFeature)it.next();
                    String isoCode = feat.getProperty("ISO_A2").getValue().toString();
                    String name = feat.getProperty("NAME").getValue().toString();
                    if (StringUtils.isBlank((String)isoCode)) {
                        throw new Error("country no iso " + name);
                    }
                    if (isoCode.equals("-99") && name.equals("France")) {
                        isoCode = "FR";
                    } else if (isoCode.equals("-99")) {
                        logger.info((Object)(" NE country bad code: " + isoCode + " " + name));
                    }
                    HashMap<String, String> osmData = (HashMap<String, String>)osmCountryData.get(isoCode);
                    if (osmData == null) {
                        osmData = new HashMap<String, String>();
                        osmData.put("name", name);
                    }
                    HashMap<String, String> pmap = osmData;
                    for (Property prop : feat.getProperties()) {
                        if (prop.getValue() == null || prop.getName() == null || prop.getName().toString().equals("the_geom") || prop.getName().toString().equals("NAME")) continue;
                        pmap.put(prop.getName().toString().toLowerCase(), prop.getValue().toString());
                    }
                    GenericData.Record record = new GenericData.Record(avroSchema);
                    record.put("index", (Object)assignedIdx);
                    if (pmap.containsKey("name:en")) {
                        record.put("enName", pmap.get("name:en"));
                    } else if (isoCode.equals("BE")) {
                        record.put("enName", (Object)"Belgium");
                    } else if (isoCode.equals("NO")) {
                        record.put("enName", (Object)"Norway");
                    } else if (pmap.containsKey("name")) {
                        record.put("enName", pmap.get("name"));
                    } else {
                        record.put("enName", (Object)"");
                    }
                    if (pmap.containsKey("name")) {
                        record.put("localName", pmap.get("name"));
                    } else {
                        logger.warn((Object)("!!! NO NAME !!! " + JSON.json(pmap)));
                        record.put("localName", (Object)"");
                    }
                    record.put("isoCode", (Object)isoCode);
                    ((DataFileWriter)avroWriters.get(2)).append((Object)record);
                    Geometry geom = (Geometry)feat.getDefaultGeometry();
                    geom = DouglasPeuckerSimplifier.simplify((Geometry)geom.buffer(0.002), (double)0.002);
                    featureBuilder.add((Object)geom);
                    featureBuilder.add((Object)assignedIdx);
                    SimpleFeature feature = featureBuilder.buildFeature(null);
                    MemoryFeatureCollection coll = (MemoryFeatureCollection)collections.get(2);
                    coll.add(feature);
                    ++assignedIdx;
                }
            }
            AdminGeoDataUtils.writeSHP(TYPE, new File(outputFolder, "shp_2.shp"), (MemoryFeatureCollection)collections.get(2));
            ((DataFileWriter)avroWriters.get(2)).close();
        }
        finally {
            dataStore.dispose();
        }
    }

    private static void writeSHP(SimpleFeatureType type, File baseFile, MemoryFeatureCollection coll) throws IOException {
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, URL> zmap = new HashMap<String, URL>();
        zmap.put("url", baseFile.toURL());
        ShapefileDataStore sds = (ShapefileDataStore)dataStoreFactory.createDataStore(zmap);
        sds.createSchema(type);
        sds.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = sds.getTypeNames()[0];
        ContentFeatureSource featureSource = sds.getFeatureSource(typeName);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures((FeatureCollection)coll);
            transaction.commit();
        }
        catch (IOException e) {
            logger.error((Object)"FAILED", (Throwable)e);
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    private static Map<String, FrenchAdmin> loadFrenchAdmin(File resourceFolder) throws Exception {
        RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)new GZIPInputStream(new FileInputStream(new File(resourceFolder, "french-admin.csv.gz"))), "utf8"), ',');
        ArrayList<String> out = new ArrayList<String>();
        HashMap<String, FrenchAdmin> ret = new HashMap<String, FrenchAdmin>();
        WKTReader reader = new WKTReader();
        parser.next(out);
        while (parser.next(out)) {
            String polygonWkt = (String)out.get(3);
            if (StringUtils.isBlank((String)polygonWkt)) continue;
            FrenchAdmin fa = new FrenchAdmin();
            fa.level = Integer.parseInt((String)out.get(0));
            fa.id = (String)out.get(1);
            fa.name = (String)out.get(2);
            fa.geom = reader.read(polygonWkt);
            ret.put(fa.id, fa);
        }
        return ret;
    }

    private static Map<String, String> cleanupData(Map<String, String> data) {
        data.remove("type");
        data.remove("boundary");
        data.remove("admin_level");
        data.remove("wikipedia");
        data.remove("source");
        data.remove("flag");
        data.remove("scalerank");
        data.remove("featurecla");
        data.remove("labelrank");
        data.remove("geou_diff");
        return data;
    }

    public static class TreeLeafBase {
        public Geometry geom;
        public Envelope env;
        public volatile PreparedGeometry prep;
        public int dataIndex;
    }

    public static class AdminGeoData {
        public Map<Integer, GenericRecord> data = new HashMap<Integer, GenericRecord>();
    }

    static class FrenchAdmin {
        int level;
        Geometry geom;
        String id;
        String name;

        FrenchAdmin() {
        }
    }
}

