/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerService;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.util.SemaphoreRegistry;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeBasedRecipeRunner
extends AbstractCodeBasedActivityRunner
implements InitializableAbortableRecipeRunner {
    protected final FlowRecipe recipe = ((RecipeRunnableSubgraph)this.subgraph).getRecipe();
    protected boolean running = false;
    protected boolean abortNotified = false;
    protected ContainerExecRuntimeConfig containerConfig = null;
    protected String containerPodId = null;
    @Autowired
    private WorkerService workerService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.code.base");

    @Override
    public boolean isAppendMode(String computableRef) {
        return this.recipe.getModel().getOutputAnyRole((String)computableRef).appendMode;
    }

    public AbstractCodeBasedRecipeRunner(JobActivity activity) {
        super(activity);
        this.projectKey = this.recipe.getProjectKey();
        activity.initStatus();
    }

    protected void warnDeprecatedPythonInterpreterVersion(CodeEnvModel.UsedCodeEnvRef codeEnvRef) throws IOException {
        StandardPythonInterpreter pythonInterpreter;
        if (codeEnvRef.envLang == CodeEnvModel.EnvLang.PYTHON && (pythonInterpreter = this.codeEnvResolutionService.getPythonInterpreterVersion(codeEnvRef.envName, this.projectKey)) != null && pythonInterpreter.isDeprecated()) {
            this.activity.warnContext.addWarning(WarningsContext.WarningType.DEPRECATED_PYTHON_INTERPRETER, String.format("Code-env '%s' uses '%s' which is deprecated and will soon be removed.", new Object[]{codeEnvRef.envName, pythonInterpreter}), logger);
        }
    }

    public void executeDockerCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File mainLogFile, AutoDelete recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String payload, Map<String, String> extraEnv, Collection<String> readablePaths) throws Exception {
        this.executeDockerCodeRecipe(codeEnvRef, containerConfig, contextPath, mainLogFile, recipeTmpDir, executionType, payload, extraEnv, readablePaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDockerCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File mainLogFile, AutoDelete recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String payload, Map<String, String> extraEnv, Collection<String> readablePaths, Collection<String> writablePaths) throws Exception {
        this.warnDeprecatedPythonInterpreterVersion(codeEnvRef);
        JobContext.getCurrentActivitySummary().containerConfType = "DOCKER";
        this.containerConfig = containerConfig;
        String executionId = this.recipe.getModel().type + "-" + SecretKeyGenerator.generateSmall();
        String imageId = this.prepareContainerExecution(contextPath, recipeTmpDir, executionId, containerConfig.dockerHost, containerConfig.baseImage, codeEnvRef, executionType, payload, readablePaths, writablePaths);
        imageId = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, imageId);
        this.containerPodId = "dku_exec-" + executionId;
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = true;
        envResource.cwd = recipeTmpDir.getAbsolutePath();
        EnvironmentStash envStash = this.prepareEnvStash((File)recipeTmpDir, extraEnv, containerConfig, codeEnvRef.envName);
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.jobId = executionId;
        RemoteRunsRegistry.get((String)executionId).envResource = envResource;
        logger.infoV("Executing recipe on Docker with config=%s, using image '%s', container '%s'", new Object[]{containerConfig.name, imageId, this.containerPodId});
        AuthCtx submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory((File)recipeTmpDir);
        pb.environment().put("DKU_API_TICKET", this.apiTicketService.getSingleTicket().getSecret());
        pb.command(DockerExecUtils.getDockerRunCommand(submitter, executionType, JobContext.getCurrentJobContext().projectKey, JobContext.getCurrentJobContext().jobId, this.activity.id(), containerConfig, "--name", this.containerPodId, "-e", "DKU_API_TICKET"));
        pb.command().addAll(DockerExecUtils.getEnvironmentCommandFlags(containerConfig));
        pb.command().add(imageId);
        pb.command().add(executionId);
        ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
        AbstractCodeBasedRecipeRunner abstractCodeBasedRecipeRunner = this;
        synchronized (abstractCodeBasedRecipeRunner) {
            this.running = true;
        }
        try (WorkerPool workerPool = this.createWorkerPool(codeEnvRef.envName);){
            pb.environment().put("REMOTE_WORKER_POOL_ID", workerPool.getId());
            CodeBasedThingHelper.ExecutionResult result = this.execute(pb, mainLogFile, null, codeEnvRef.envLang.getLanguageInfo(), null, true);
            this.getExecutionResultHandler().throwFromErrorFileOrLogs(pb.directory(), codeEnvRef.envLang.getLanguageInfo(), result, null);
        }
        finally {
            abstractCodeBasedRecipeRunner = this;
            synchronized (abstractCodeBasedRecipeRunner) {
                this.running = false;
            }
            RemoteRunsRegistry.remove(executionId);
        }
    }

    public void executeKubernetesCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File mainLogFile, File additionalLogsFolder, AutoDelete recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String payload, Map<String, String> extraEnv, Collection<String> readablePaths, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws Exception {
        this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, contextPath, mainLogFile, additionalLogsFolder, recipeTmpDir, executionType, payload, extraEnv, readablePaths, null, codeProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeKubernetesCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File mainLogFile, File additionalLogsFolder, AutoDelete recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String payload, Map<String, String> extraEnv, Collection<String> readablePaths, Collection<String> writablePaths, KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider) throws Exception {
        KubectlHelper.KubectlLoopCaller kubectlPodTopper;
        boolean deleteK8sPod;
        ComputeResourceUsage cru;
        String executionId;
        AuthCtx authCtx;
        block41: {
            this.warnDeprecatedPythonInterpreterVersion(codeEnvRef);
            authCtx = this.authCtxService.getAuthCtx();
            JobContext.getCurrentActivitySummary().containerConfType = "KUBERNETES";
            this.containerConfig = containerConfig;
            executionId = KubernetesExecUtils.getNormalizedExecutionId(this.recipe.getModel().type + "-" + SecretKeyGenerator.generateSmall());
            String imageId = this.prepareContainerExecution(contextPath, recipeTmpDir, executionId, containerConfig.dockerHost, containerConfig.baseImage, codeEnvRef, executionType, payload, readablePaths, writablePaths);
            String k8sClusterId = new ClusterSelector().getClusterForProject(JobContext.getCurrentJobContext().projectKey, Cluster.ClusterArchitecture.KUBERNETES);
            K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = containerConfig.kubernetesResources;
            cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)executionId, (IK8SContainerLimits)k8sContainerLimits).reportStartNoFail();
            imageId = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, imageId);
            logger.infoV("Executing recipe on Kubernetes with config=%s, using image '%s'", new Object[]{containerConfig.name, imageId});
            AuthCtx submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
            File secretFile = new File((File)recipeTmpDir, "secret.yaml");
            File podFile = new File((File)recipeTmpDir, "pod.yaml");
            RemoteRunEnvDef envResource = new RemoteRunEnvDef();
            envResource.runsRemotely = true;
            envResource.cwd = recipeTmpDir.getAbsolutePath();
            EnvironmentStash envStash = this.prepareEnvStash((File)recipeTmpDir, extraEnv, containerConfig, codeEnvRef.envName);
            envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
            envResource.jobId = executionId;
            KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(submitter, executionId, containerConfig);
            String secretDesc = KubernetesExecUtils.getTicketSecretConf(executionId, this.apiTicketService.getSingleTicket().getSecret());
            String podDesc = KubernetesExecUtils.getPodConf(submitter, executionId, JobContext.getCurrentJobContext().projectKey, JobContext.getCurrentJobContext().jobId, this.activity.id(), laa, Collections.emptyMap(), imageId, containerConfig);
            this.containerPodId = StringUtils.join((Object[])new String[]{"-f", podFile.getAbsolutePath(), "-f", secretFile.getAbsolutePath()}, (String)"\n");
            DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
            DKUFileUtils.writeFileUTF8((File)podFile, (String)podDesc);
            deleteK8sPod = true;
            KubectlHelper.KubectlLoopCaller kubectlPodDescriber = null;
            kubectlPodTopper = null;
            double waited = RateLimiterRegistry.forName("k8sCodeRecipeStart", 1000.0).acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds (rate-limited by k8sCodeRecipeStart)", new Object[]{waited});
            }
            try {
                try (WorkerPool workerPool = this.createWorkerPool(codeEnvRef.envName);){
                    envResource.env.put("REMOTE_WORKER_POOL_ID", workerPool.getId());
                    RemoteRunsRegistry.get((String)executionId).envResource = envResource;
                    Exception exception = null;
                    String podName = KubernetesExecUtils.getPodName(executionId);
                    Semaphore semaphore = SemaphoreRegistry.forName("k8sCodeRecipesInStartupPhase", 100);
                    long before = System.currentTimeMillis();
                    semaphore.acquire();
                    try {
                        long after = System.currentTimeMillis();
                        if (after - before > 50L) {
                            logger.infoV("Waited %.3f seconds (semaphore-limited by k8sCodeRecipesInStartupPhase", new Object[]{(double)(after - before) / 1000.0});
                        }
                        KubernetesExecUtils.createPod(authCtx, this.projectKey, containerConfig, podName, secretFile, podFile, (File)recipeTmpDir);
                        AbstractCodeBasedRecipeRunner abstractCodeBasedRecipeRunner = this;
                        synchronized (abstractCodeBasedRecipeRunner) {
                            this.running = true;
                        }
                        try {
                            logger.info((Object)"Waiting for kubernetes logs availability");
                            exception = KubernetesExecUtils.waitForLogStart(authCtx, this.projectKey, podName, containerConfig);
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Will not delete kubernetes pod for debugging");
                            deleteK8sPod = false;
                            throw e;
                        }
                    }
                    finally {
                        semaphore.release();
                    }
                    if (exception != null) {
                        logger.error((Object)"Could not get kubernetes pod logs");
                        logger.warn((Object)"Will not delete kubernetes pod for debugging");
                        deleteK8sPod = false;
                        throw exception;
                    }
                    if (cru.context.type == ComputeResourceUsageContext.ComputeResourceUsageContextType.JOB_ACTIVITY) {
                        logger.info((Object)"In a job activity, gathering Kubernetes pod description in background");
                        JobActivity currentActivity = JobContext.getCurrentActivityObj();
                        kubectlPodDescriber = KubectlHelper.createPodDescriber(authCtx, this.projectKey, currentActivity, containerConfig, executionId);
                        if (kubectlPodDescriber != null) {
                            logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                            kubectlPodDescriber.start();
                        }
                        if ((kubectlPodTopper = KubectlHelper.createPodTopper(authCtx, this.projectKey, currentActivity, containerConfig, executionId)) != null) {
                            logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                            kubectlPodTopper.start();
                        }
                    }
                    logger.info((Object)"Done waiting for logs to be available, trying to start streaming them");
                    int rv = KubernetesExecUtils.streamLogsUntilPodsAreDone(authCtx, this.projectKey, (File)recipeTmpDir, podName, containerConfig, mainLogFile);
                    logger.info((Object)("Log streaming terminated with return code " + rv));
                    if (rv != 0) {
                        logger.error((Object)"Could not get kubernetes pod logs");
                        logger.warn((Object)"Will not delete kubernetes pod for debugging");
                        deleteK8sPod = false;
                    }
                    try {
                        logger.info((Object)"Waiting for kubernetes pod to finish");
                        exception = KubernetesExecUtils.waitForPod(authCtx, this.projectKey, podName, containerConfig, codeProvider);
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Will not delete kubernetes pod for debugging");
                        deleteK8sPod = false;
                        exception = e;
                    }
                    this.getExecutionResultHandler().throwFromErrorFileOrLogs((File)recipeTmpDir, codeEnvRef.envLang.getLanguageInfo(), mainLogFile, codeProvider);
                    if (exception != null) {
                        throw exception;
                    }
                }
                if (kubectlPodDescriber == null) break block41;
            }
            catch (Throwable throwable) {
                if (kubectlPodDescriber != null) {
                    logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                    kubectlPodDescriber.cancel();
                }
                if (kubectlPodTopper != null) {
                    logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                    kubectlPodTopper.cancel();
                }
                RemoteRunsRegistry.remove(executionId);
                cru.reportCompleteNoFail();
                if (deleteK8sPod) {
                    logger.info((Object)"Cleaning Kubernetes pod");
                    ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, this.projectKey, containerConfig, false, "delete", "-f", "secret.yaml", "-f", "pod.yaml"));
                    pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
                    pb.directory((File)recipeTmpDir);
                    File cleanupLogFile = new File((File)recipeTmpDir, "kubectl-cleanup-out.log");
                    CodeBasedThingHelper.ExecutionResult cleanResult = this.getProcessExecution().executeNoFail(pb, null, cleanupLogFile, null, true);
                    if (cleanResult.returnValue != 0) {
                        logger.error((Object)"Could not clean kubernetes pod");
                    }
                }
                AbstractCodeBasedRecipeRunner abstractCodeBasedRecipeRunner = this;
                synchronized (abstractCodeBasedRecipeRunner) {
                    this.running = false;
                }
                throw throwable;
            }
            logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
            kubectlPodDescriber.cancel();
        }
        if (kubectlPodTopper != null) {
            logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
            kubectlPodTopper.cancel();
        }
        RemoteRunsRegistry.remove(executionId);
        cru.reportCompleteNoFail();
        if (deleteK8sPod) {
            logger.info((Object)"Cleaning Kubernetes pod");
            ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, this.projectKey, containerConfig, false, "delete", "-f", "secret.yaml", "-f", "pod.yaml"));
            pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            pb.directory((File)recipeTmpDir);
            File cleanupLogFile = new File((File)recipeTmpDir, "kubectl-cleanup-out.log");
            CodeBasedThingHelper.ExecutionResult cleanResult = this.getProcessExecution().executeNoFail(pb, null, cleanupLogFile, null, true);
            if (cleanResult.returnValue != 0) {
                logger.error((Object)"Could not clean kubernetes pod");
            }
        }
        AbstractCodeBasedRecipeRunner abstractCodeBasedRecipeRunner = this;
        synchronized (abstractCodeBasedRecipeRunner) {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        if (this.containerConfig == null) {
            return;
        }
        AbstractCodeBasedRecipeRunner abstractCodeBasedRecipeRunner = this;
        synchronized (abstractCodeBasedRecipeRunner) {
            if (!this.running || this.abortNotified) {
                return;
            }
            this.abortNotified = true;
        }
        switch (this.containerConfig.type) {
            case DOCKER: {
                logger.warn((Object)("Abort received, will kill Docker container " + this.containerPodId));
                HashMap<String, String> env = new HashMap<String, String>(1);
                ContainerExecUtils.enrichDockerEnv(this.containerConfig, env);
                ContainerExecUtils.killDockerContainer(this.containerPodId, true, env, logger);
                break;
            }
            case KUBERNETES: {
                logger.warn((Object)("Abort received, will kill Kubernetes pod " + this.containerPodId));
                try {
                    KubernetesExecUtils.delete(this.authCtxService.getAuthCtx(), this.projectKey, this.containerConfig, true, this.containerPodId.split("\n"));
                    break;
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes pod", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes pod", (Throwable)e);
                }
            }
        }
    }

    protected WorkerPool createWorkerPool(String envName) {
        return this.workerService.createWorkerPool(this.projectKey, envName, this.authCtxService.getAuthCtx(), this.containerConfig, true, true, null);
    }

    private String prepareContainerExecution(@Nullable File contextPath, AutoDelete recipeTmpDir, String executionId, String dockerHost, String baseImageRef, CodeEnvModel.UsedCodeEnvRef codeEnvRef, RemoteRunsRegistry.ExecutionType executionType, String payload, Collection<String> readablePaths, Collection<String> writablePaths) throws IOException {
        String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, this.projectKey);
        CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(codeEnvRef.envLang, codeEnvRef.envName, envVersion);
        RemoteRunsRegistry.add(executionId, this.apiTicketService.getSingleTicket().getOriginalUser(), this.projectKey, contextPath != null ? contextPath.getPath() : null, recipeTmpDir.getPath(), executionType, JSON.json((Object)this.activity.getSerialized()), payload, readablePaths, writablePaths, Collections.singletonList(env));
        return ContainerExecImagesHelper.getImageTagToUse(dockerHost, baseImageRef, ContainerExecUtils.BaseImageType.EXEC, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
    }

    protected void writeRemoteRunEnvDefForLocalExecution(File recipeTmpDir, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = this.prepareEnvStash(recipeTmpDir, new HashMap<String, String>(), null, envName);
        stash.setCommunicationVarsForLocalOnlyExecution();
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = recipeTmpDir.getAbsolutePath();
        stash.copyToRemoteRunEnvDef(envResource, true, true, false);
        envResource.jobId = this.activity.id();
        envResource.python = new RemoteRunEnvDef.PythonEnvResource();
        envResource.python.pythonPathChunks = stash.pythonPath;
        File envFile = new File(recipeTmpDir, "remote-run-env-def.json");
        logger.info((Object)("Writing dku-exec-env for local execution in " + envFile.getAbsolutePath()));
        DKUFileUtils.writeFileUTF8((File)envFile, (String)JSON.pretty((Object)envResource));
    }
}

