/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureUtils;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.Visitor;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class QueryVisitor
implements Visitor {
    protected final SQLDialect dialect;
    protected final Integer identifierMaxLength;
    protected final AutoFeatureGenerationRecipePayloadParams params;
    @VisibleForTesting
    Map<Integer, String> viewNameByDataset;
    protected final List<String> preSelectQueries;
    protected final List<String> postSelectQueries;
    protected String selectQuery;
    protected final Map<String, Dataset> datasetsMap;
    protected final Map<String, SQLUtils.SQLTable> sqlTablesMap;
    @Nullable
    protected final String catalog;
    @Nullable
    protected final String databaseSchema;

    protected QueryVisitor(AutoFeatureGenerationRecipePayloadParams params, SQLDialect dialect, Map<Integer, String> viewNameByDataset, Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap) {
        this.dialect = dialect;
        this.identifierMaxLength = FeatureUtils.getIdentifierMaxLength(dialect);
        this.datasetsMap = datasetsMap;
        this.sqlTablesMap = sqlTablesMap;
        String primaryDatasetName = params.getPrimaryDataset().name;
        this.checkInput(primaryDatasetName);
        this.catalog = sqlTablesMap.get(primaryDatasetName).getCatalog();
        this.databaseSchema = sqlTablesMap.get(primaryDatasetName).getSchemaNullIfBlank();
        this.viewNameByDataset = viewNameByDataset;
        this.params = params;
        this.preSelectQueries = new ArrayList<String>();
        this.postSelectQueries = new ArrayList<String>();
    }

    protected List<String> getPreSelectQueries() {
        return this.preSelectQueries;
    }

    protected List<String> getPostSelectQueries() {
        return this.postSelectQueries;
    }

    protected String getSelectQuery() {
        return this.selectQuery;
    }

    protected void generateSqlViewQueries(String viewName, String sqlQuery) {
        if (this.dialect instanceof SparkSQLDialect) {
            this.preSelectQueries.add(((SparkSQLDialect)this.dialect).createTemporaryViewAs(this.dialect.getQuotedTableFullName(this.catalog, this.databaseSchema, viewName), sqlQuery));
        } else {
            this.preSelectQueries.add(this.getCreateViewInstruction(viewName) + sqlQuery);
            this.postSelectQueries.add(0, this.getDropViewInstruction(viewName));
        }
    }

    protected String getCreateViewInstruction(String viewName) {
        return this.dialect.getCreateViewInstruction(this.catalog, this.databaseSchema, viewName);
    }

    protected String getDropViewInstruction(String viewName) {
        return this.dialect.getDropViewInstruction(this.catalog, this.databaseSchema, viewName);
    }

    protected void registerNewSQLView(RelationshipGraph.Node node, String viewName) {
        this.viewNameByDataset.put(node.getId(), viewName);
        this.addViewToSqlTables(viewName);
        this.addViewToSources(viewName, this.createDatasetFromView(node));
    }

    protected void addViewToSources(String viewName, Dataset dataset) {
        this.datasetsMap.put(viewName, dataset);
    }

    protected void addViewToSqlTables(String viewName) {
        this.sqlTablesMap.put(viewName, new SQLUtils.SQLTable(this.catalog, this.databaseSchema, viewName));
    }

    protected Dataset createDatasetFromView(RelationshipGraph.Node node) {
        Dataset dataset = new Dataset();
        dataset.setSchema(node.getSchema());
        return dataset;
    }

    protected void checkInput(String datasetName) {
        if (!this.datasetsMap.containsKey(datasetName)) {
            throw ErrorContext.iae((String)String.format("Failed to retrieve the input dataset '%s': dataset is null", datasetName));
        }
        if (!this.sqlTablesMap.containsKey(datasetName)) {
            throw ErrorContext.iae((String)String.format("Failed to retrieve the input SQL table '%s': table is null", datasetName));
        }
    }
}

