/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.distinct;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeCreator;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.HashSet;

public class DistinctRecipeCreator
extends GroupingRecipeCreator {
    public DistinctRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        super.setOutputSchema(recipe, DistinctRecipeMeta.filterPayload(payload), outputDataset);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        DistinctRecipePayloadParams params = new DistinctRecipePayloadParams();
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        Schema inputSchema = inputDataset.getSchema();
        if (inputSchema != null) {
            HashSet excludedFromInput = Sets.newHashSet();
            if (outputDataset.getPartitioningSchema() != null && outputDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDataset)) {
                excludedFromInput.addAll(outputDataset.getPartitioningSchema().getDimensionNames());
            }
            for (SchemaColumn col : inputSchema.getColumns()) {
                if (!excludedFromInput.contains(col.getName())) {
                    DistinctRecipePayloadParams.GroupingKey gk = new DistinctRecipePayloadParams.GroupingKey();
                    gk.column = col.getName();
                    params.keys.add(gk);
                    continue;
                }
                params.selectAllColumns = false;
            }
        }
        return JSON.json((Object)params);
    }
}

