/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnsStepStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeStatusUtils;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;

public class FuzzyJoinRecipeStatusComputer
extends RecipeStatusComputer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.fuzzyjoin.status");

    public FuzzyJoinRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public FuzzyJoinRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    @Override
    public FuzzyJoinRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        FuzzyJoinRecipeStatus status;
        JoinLikeStatusUtils joinLikeStatusUtils = new JoinLikeStatusUtils(authCtx, this.transactionService);
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
        }
        if (status.isInvalid()) {
            return status;
        }
        FuzzyJoinRecipePayloadParams params = status.params;
        FuzzyJoinRecipeHelper helper = init.helper;
        helper.initAliases(params);
        status.fuzzyJoinAdditionalSettings = new RecipeStatus.StepStatus();
        try {
            this.checkJoins(status, helper);
            joinLikeStatusUtils.validateOutputSchema(status, params, false, this.payload, init.activity);
            try {
                this.checkSelectedColumns(status, params);
            }
            catch (Exception e) {
                logger.error((Object)"Invalid selected columns", (Throwable)e);
                status.selectedColumns.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            if (init.error != null && !status.isInvalid()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (status.isInvalid() && !status.output.error) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipe steps did not validate");
        }
        return status;
    }

    void checkJoins(FuzzyJoinRecipeStatus status, FuzzyJoinRecipeHelper helper) {
        FuzzyJoinRecipePayloadParams params = status.params;
        if (params.debugMode) {
            status.fuzzyJoinAdditionalSettings.withWarningV(RecipeCodes.WARN_RECIPE_JOIN_EXPENSIVE, "Debug mode causes slow execution and large output", new Object[0]);
        }
        for (FuzzyJoinRecipePayloadParams.JoinDesc join : params.joins) {
            boolean hasNonEqualsJoins = false;
            JoinInputDescBase input1 = (JoinInputDescBase)params.virtualInputs.get(join.table1);
            JoinInputDescBase input2 = (JoinInputDescBase)params.virtualInputs.get(join.table2);
            Dataset ds1 = helper.datasetsMap.get(input1.name);
            Dataset ds2 = helper.datasetsMap.get(input2.name);
            if (ds1 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input1.name);
            }
            if (ds2 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input2.name);
            }
            if (ds1 != null && ds2 != null) {
                Schema schema2;
                Schema schema1 = ds1.getSchema();
                if (schema1 == null) {
                    status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input1.name);
                }
                if ((schema2 = ds2.getSchema()) == null) {
                    status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input2.name);
                }
                if (schema1 != null && schema2 != null) {
                    for (FuzzyJoinRecipePayloadParams.MatchingCondition condition : join.on) {
                        if (!hasNonEqualsJoins && condition.fuzzyMatchDesc.distanceType != FuzzyJoinRecipePayloadParams.DistanceType.EXACT) {
                            hasNonEqualsJoins = true;
                        }
                        this.checkJoinWithSchema(status, input1, schema1, input2, schema2, condition);
                    }
                }
            }
            if (hasNonEqualsJoins) continue;
            status.join.withWarningV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "All matching conditions are set to strict equality. Consider using regular join recipe that is more efficient in this case.", new Object[0]);
        }
    }

    void checkJoinWithSchema(FuzzyJoinRecipeStatus status, JoinInputDescBase input1, Schema schema1, JoinInputDescBase input2, Schema schema2, FuzzyJoinRecipePayloadParams.MatchingCondition condition) {
        SchemaColumn sc1 = null;
        SchemaColumn sc2 = null;
        if (condition.fuzzyMatchDesc.distanceType == null) {
            status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "No distance type is selected between columns \"" + condition.column1.name + "\" and \"" + condition.column2.name + "\"", new Object[0]);
        }
        try {
            sc1 = ExpressionUtils.getSchemaColumn(condition.column1.name, schema1, input1.computedColumns);
        }
        catch (IllegalArgumentException e) {
            status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Dataset " + input1.name + " has no column " + condition.column1.name, new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        try {
            sc2 = ExpressionUtils.getSchemaColumn(condition.column2.name, schema2, input2.computedColumns);
        }
        catch (IllegalArgumentException e) {
            status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Dataset " + input2.name + " has no column " + condition.column2.name, new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        if (sc1 != null && sc2 != null) {
            boolean bothTypesAreNumeric;
            Type type1 = sc1.getType();
            Type type2 = sc2.getType();
            boolean bl = bothTypesAreNumeric = type1.isNumeric() && type2.isNumeric();
            if (type1 != type2 && !bothTypesAreNumeric) {
                status.join.withWarningV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, String.format("Incompatible column types: %s (%s) and %s (%s).", condition.column1.name, type1, condition.column2.name, type2), new Object[0]);
            }
            if (FuzzyJoinRecipePayloadParams.DistanceType.GEO.equals((Object)condition.fuzzyMatchDesc.distanceType)) {
                String messageTemplate = "Column '%s' (%s) needs to be of Geopoint type in order to use Geospatial distance";
                if (type1 != Type.GEOPOINT) {
                    status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, String.format(messageTemplate, condition.column1.name, type1), new Object[0]);
                }
                if (type2 != Type.GEOPOINT) {
                    status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, String.format(messageTemplate, condition.column2.name, type2), new Object[0]);
                }
            }
        }
    }

    private void checkSelectedColumns(FuzzyJoinRecipeStatus status, FuzzyJoinRecipePayloadParams params) {
        params.validateSelectedColumns();
        if (!status.selectedColumns.error) {
            int[] selectedColumnsCounts = new int[params.virtualInputs.size()];
            for (ColumnDesc cd : params.getSelectedColumns()) {
                int n = cd.table;
                selectedColumnsCounts[n] = selectedColumnsCounts[n] + 1;
            }
            for (int i = 0; i < params.virtualInputs.size(); ++i) {
                if (selectedColumnsCounts[i] != 0) continue;
                status.selectedColumns.addMessage(InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, (String)"Dataset with no selected column").withPos(i, 0));
            }
        }
    }

    private FuzzyJoinRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        FuzzyJoinRecipeStatus status = new FuzzyJoinRecipeStatus();
        try {
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            init.helper = new FuzzyJoinRecipeHelper();
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
            this.performBasicStructureChecks(status, authCtx);
            FuzzyJoinEngineStatus dss = new FuzzyJoinEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS");
            dss.isSelectable = true;
            status.engines.add(dss);
            this.performBasicCDEChecks(dss, authCtx);
            status.selectedEngine = dss;
            try {
                this.loadParams(init.helper, status);
            }
            catch (Exception e) {
                logger.error((Object)"Invalid join params", (Throwable)e);
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, ExceptionUtils.getMessageWithCauses((Throwable)e));
                return status;
            }
            init.helper.initInputDatasets(init.activity, status.params);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return status;
    }

    private void loadParams(FuzzyJoinRecipeHelper helper, FuzzyJoinRecipeStatus status) throws Exception {
        String dynamicPayload = null;
        if ("{}".equals(this.payload)) {
            RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
            dynamicPayload = recipesDAO.getPayloadOrNull(this.recipe.projectKey, this.recipe.name);
        }
        status.params = helper.loadParams(dynamicPayload != null ? dynamicPayload : this.payload, this.recipe);
        status.params.validateJoins();
    }

    private static class StatusInitializer {
        FuzzyJoinRecipeHelper helper;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class FuzzyJoinRecipeStatus
    extends RecipeStatus
    implements JoinLikeRecipeStatus {
        Schema outputSchema;
        RecipeStatus.StepStatus inputColumns;
        RecipeStatus.StepStatus join = new RecipeStatus.StepStatus();
        ColumnsStepStatus selectedColumns = new ColumnsStepStatus();
        RecipeStatus.StepStatus fuzzyJoinAdditionalSettings = new RecipeStatus.StepStatus();
        FuzzyJoinRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.inputColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.inputColumns);
            }
            if (this.join != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.join);
            }
            if (this.selectedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.selectedColumns);
            }
            if (this.fuzzyJoinAdditionalSettings != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.fuzzyJoinAdditionalSettings);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().error;
        }

        @Override
        public void setOutputSchema(Schema schema) {
            this.outputSchema = schema;
        }

        @Override
        public ColumnsStepStatus getSelectedColumns() {
            return this.selectedColumns;
        }

        @Override
        public void initOutputSchema(AuthCtx authCtx, JobActivity activity, String payload) throws Exception {
            FuzzyJoinRecipeSchemaComputer schemaComputer = new FuzzyJoinRecipeSchemaComputer(authCtx, activity);
            schemaComputer.setPayload(payload);
            this.setOutputSchema(schemaComputer.getSchema());
        }
    }

    public static class FuzzyJoinEngineStatus
    extends RecipeEngineStatus {
        public boolean canFullOuterJoin = true;

        public FuzzyJoinEngineStatus() {
        }

        public FuzzyJoinEngineStatus(String type, String typeLabel, String variant, String variantLabel, String label) {
            super(type, typeLabel, variant, variantLabel, label);
        }
    }
}

