/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.Node;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.SelectionExecutor;
import java.util.ArrayList;
import java.util.List;

public class HashingSelectionExecutor
extends SelectionExecutor {
    public static final int EFFICIENCY_FACTOR = 10;
    private final Node[][] buckets;
    private final int nJoinValues;

    public HashingSelectionExecutor(List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> matchDesc) {
        super(matchDesc);
        this.nJoinValues = matchDesc.size();
        this.buckets = new Node[this.nJoinValues][10 * this.nJoinValues];
    }

    @Override
    public List<Node> addJoinValues(List<String> joinValues) {
        return this.getNodes(joinValues, true);
    }

    @Override
    public List<Node> searchValidNodes(List<String> joinValues) {
        return this.getNodes(joinValues, false);
    }

    private List<Node> getNodes(List<String> joinValues, boolean build) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < this.nJoinValues; ++i) {
            String joinValue = joinValues.get(i);
            if (joinValue == null) continue;
            int hashIndex = Math.abs(joinValue.hashCode() % (10 * this.nJoinValues));
            if (this.buckets[i][hashIndex] == null) {
                if (!build) continue;
                this.buckets[i][hashIndex] = new Node();
            }
            nodes.add(this.buckets[i][hashIndex]);
        }
        return nodes;
    }
}

