/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.WithAdditionalRunnables;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.sampling.ContainerizedSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.FSToAnySamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.HiveSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.ImpalaSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SQLSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.sampling.SingleThreadAnyToAnySamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SparkSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sql.SQLGenerator;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.SamplingRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SamplingRecipeRunner
implements FlowRunnable,
RecipeRunner,
RecipeRunnerWithPayload,
WithAdditionalRunnables,
AbortableRecipeRunner,
ContainerizedDSSEngineAble {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected SamplingRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private SamplingRecipeExecutor executor;
    private Dataset inputDS;
    private Dataset outputDS;
    private FilterDesc filterDesc;
    private SamplingRecipeMeta.SamplingRecipeParams params;
    private String payload;
    private boolean isRunningInContainer;
    private SQLGenerator sqlGenerator = new SQLGenerator(){

        @Override
        public String generateSQL(SQLDialect dialect) throws IOException {
            return SamplingRecipeRunner.this.service.generateSQL(SamplingRecipeRunner.this.activity, dialect, SamplingRecipeRunner.this.params.selection, SamplingRecipeRunner.this.filterDesc, SamplingRecipeRunner.this.params.engineParams);
        }
    };
    private static Logger logger = Logger.getLogger((String)"dku.flow.sampling");

    public SamplingRecipeRunner(JobActivity activity) {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.activity = activity;
        this.recipe = subgraph.getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD " + payload));
        this.payload = payload;
        this.filterDesc = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void init() throws Exception {
        this.recipe.validateExactly1Source();
        this.recipe.validateExactly1Target();
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        FlowDataset inputFD = GraphUtils.getSingleSource(this.recipe);
        FlowDataset outputFD = GraphUtils.getSingleTarget(this.recipe);
        this.inputDS = inputFD.getMandatory(this.datasetsDAO);
        this.outputDS = outputFD.getMandatory(this.datasetsDAO);
        this.params = RecipeRegistry.getParamsAs(this.activity, SamplingRecipeMeta.SamplingRecipeParams.class);
        Output.WriteMode writeMode = this.recipe.getModel().getSingleOutput("main").getWriteMode();
        this.executor = this.getExecutor();
        logger.info((Object)("Using executor: " + this.executor.getClass().getName()));
        this.executor.setFilter(this.filterDesc);
        this.executor.setSelection(this.params.selection);
        this.executor.init(this.activity, writeMode);
    }

    private SamplingRecipeExecutor getExecutor() throws Exception {
        SamplingRecipeStatusComputer sc = new SamplingRecipeStatusComputer(this.recipe.getModel(), this.payload);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus engineToUse = sc.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx()).getSelectedSQLBasedEngine();
        logger.info((Object)("Selected engine type: " + engineToUse.type));
        JobContext.getCurrentActivitySummary().engineType = engineToUse.type;
        if (!engineToUse.isSelectable) {
            throw new CodedIOException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_FIND_ENGINE, "There is no engine available to handle this combination of input and output datasets");
        }
        switch (engineToUse.type) {
            case "SQL": {
                return new SQLSamplingExecutor(this.sqlGenerator);
            }
            case "SPARK": {
                return new SparkSamplingExecutor(this.sqlGenerator, this.params.engineParams.sparkSQL);
            }
            case "IMPALA": {
                return new ImpalaSamplingExecutor(this.sqlGenerator, this.params.engineParams.impala);
            }
            case "HIVE": {
                return new HiveSamplingExecutor(this.sqlGenerator, this.params.engineParams.hive);
            }
            case "DSS": {
                return this.selectStreamExecutor();
            }
        }
        throw new IllegalArgumentException("No engine selected");
    }

    private SamplingRecipeExecutor selectStreamExecutor() throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            return new ContainerizedSamplingExecutor(this.recipe, this.activity, containerConfig);
        }
        logger.info((Object)"Selecting stream executor");
        try (DatasetHandler inputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.inputDS);){
            SingleThreadAnyToAnySamplingExecutor singleThreadAnyToAnySamplingExecutor;
            block21: {
                DatasetHandler outputDatasetHandler;
                block17: {
                    SingleThreadAnyToAnySamplingExecutor singleThreadAnyToAnySamplingExecutor2;
                    block20: {
                        block18: {
                            FSToAnySamplingExecutor fSToAnySamplingExecutor;
                            block19: {
                                outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.outputDS);
                                try {
                                    DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(this.inputDS);
                                    if (!inputMeta.isFS()) break block17;
                                    boolean inputIsRepeating = this.inputDS.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig && this.inputDS.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled();
                                    logger.info((Object)("Input is repeating: " + inputIsRepeating));
                                    if (inputIsRepeating || !inputDatasetHandler.isParallelReadable() || !outputDatasetHandler.isParallelWritable() || this.params.selection != null && this.params.selection.samplingMethod != SamplingParam.SamplingMethod.FULL) break block18;
                                    fSToAnySamplingExecutor = new FSToAnySamplingExecutor(this.params.engineParams.dssEngineMaxThreads);
                                    if (outputDatasetHandler == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    if (outputDatasetHandler != null) {
                                        try {
                                            outputDatasetHandler.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                outputDatasetHandler.close();
                            }
                            return fSToAnySamplingExecutor;
                        }
                        singleThreadAnyToAnySamplingExecutor2 = new SingleThreadAnyToAnySamplingExecutor();
                        if (outputDatasetHandler == null) break block20;
                        outputDatasetHandler.close();
                    }
                    return singleThreadAnyToAnySamplingExecutor2;
                }
                singleThreadAnyToAnySamplingExecutor = new SingleThreadAnyToAnySamplingExecutor();
                if (outputDatasetHandler == null) break block21;
                outputDatasetHandler.close();
            }
            return singleThreadAnyToAnySamplingExecutor;
        }
    }

    @Override
    public void run() throws Exception {
        this.executor.run();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.executor instanceof AbortableRecipeRunner) {
            ((AbortableRecipeRunner)((Object)this.executor)).notifyBeforeAborting();
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return this.executor instanceof WithAdditionalRunnables ? ((WithAdditionalRunnables)((Object)this.executor)).getRunnables() : new ArrayList();
    }
}

