/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TeradataHadoop
extends SISORecipeExecutor {
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private TDCHParams params;
    private String csvSeparator;
    private TeradataConnection tdConnection;
    private ICredentialsService.BasicCredential tdCreds;
    private String engineVariant;
    private static Logger logger = Logger.getLogger((String)"dku.sync.tdch");

    public TeradataHadoop(TDCHParams params) {
        this.params = params;
    }

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        if (!"true".equals(ApplicationConfigurator.getProperty((String)"tdch.enabled", (String)"false"))) {
            status.markAsNonSelectable("TDCH is disabled", RecipeEngineStatus.WarningLevel.WARN);
            return;
        }
        if (inputDS.getPartitioningSchema().isPartitioned()) {
            status.setStatus("TDCH doesn't support partitioning", RecipeEngineStatus.WarningLevel.WARN);
            status.markAsNonSelectable("TDCH is disabled", RecipeEngineStatus.WarningLevel.WARN);
            return;
        }
        if (inputMeta == BuiltinFSDatasets.HDFS_META && outputMeta == BuiltinSQLDatasets.TERADATA_META) {
            status.recommended = true;
            status.isSelectable = true;
            status.variantLabel = status.variant = "HADOOP_TO_TERADATA";
        } else if (inputMeta == BuiltinSQLDatasets.TERADATA_META && outputMeta == BuiltinFSDatasets.HDFS_META) {
            status.isSelectable = true;
            status.variantLabel = status.variant = "TERADATA_TO_HADOOP";
            if (outputDS.getFormatType().equals(CSVFormatExtractor.META.getType())) {
                status.recommended = true;
            } else {
                status.setStatus("Dataset format not supported", RecipeEngineStatus.WarningLevel.ERROR);
            }
        } else {
            status.markAsNonSelectable("Needs a Teradata dataset and a HDFS dataset", RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    public void init() throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(this.inputDS);
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(this.outputDS);
        String tdcnx = null;
        if (inputMeta == BuiltinFSDatasets.HDFS_META && outputMeta == BuiltinSQLDatasets.TERADATA_META) {
            this.engineVariant = "HADOOP_TO_TERADATA";
            tdcnx = this.outputDS.getParams().getConnection();
        } else if (inputMeta == BuiltinSQLDatasets.TERADATA_META && outputMeta == BuiltinFSDatasets.HDFS_META) {
            this.engineVariant = "TERADATA_TO_HADOOP";
            tdcnx = this.inputDS.getParams().getConnection();
            if (this.outputDS.getFormatType().equals(CSVFormatExtractor.META.getType())) {
                this.csvSeparator = this.outputDS.getFormatParamsAs(CSVFormatConfig.class).getSeparatorStr();
            }
        } else {
            throw ErrorContext.iaef((String)"Invalid input/output dataset types: %s and %s", (Object)this.inputDS.getType(), (Object[])new Object[]{this.outputDS.getType()});
        }
        this.tdConnection = (TeradataConnection)this.connectionsDAO.getMandatoryConnection(this.authCtx, tdcnx);
        this.tdCreds = this.tdConnection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, this.inputDS.getProjectKey()), ICredentialsService.BasicCredential.class);
    }

    private List<String> getCommandBase(Map<String, String> envVars, AbstractSQLDatasetHandler.AbstractSQLConfig sqlConfig) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("hadoop");
        cmd.add("jar");
        cmd.add(ApplicationConfigurator.getMandatoryProperty((String)"tdch.jar"));
        if (this.engineVariant.equals("TERADATA_TO_HADOOP")) {
            cmd.add("com.teradata.connector.common.tool.ConnectorImportTool");
        } else {
            cmd.add("com.teradata.connector.common.tool.ConnectorExportTool");
        }
        cmd.add("-libjars");
        cmd.add(ApplicationConfigurator.getMandatoryProperty((String)"tdch.includes") + "," + envVars.get("DKU_HIVE_CP").replace(":", ","));
        String dbCandidate = sqlConfig.schema;
        if (dbCandidate == null || dbCandidate.equals("null") || dbCandidate.isEmpty()) {
            dbCandidate = this.tdCreds.user;
        }
        cmd.add("-url");
        cmd.add("jdbc:teradata://" + this.tdConnection.params.host + "/database=" + dbCandidate);
        cmd.add("-username");
        cmd.add(this.tdCreds.user);
        cmd.add("-password");
        cmd.add("$TDCH_PWD");
        return cmd;
    }

    private List<String> generateTeradataToHadoopCommand(HDFSDatasetHandler targetDSHandler, Map<String, String> envVars) throws IOException, InterruptedException, DKUSecurityException {
        List<String> cmd = this.getCommandBase(envVars, this.inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class));
        Pair<String, String> fmt = this.dssFormatToTDCHFormatAndMode(this.outputDS.getFormatType());
        cmd.add("-targetpaths");
        cmd.add(targetDSHandler.getFullyQualifiedRootPath());
        cmd.add("-fileformat");
        cmd.add((String)fmt.first);
        cmd.add("-jobtype");
        cmd.add((String)fmt.second);
        cmd.add("-sourcetable");
        cmd.add(this.inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)this.inputDS.getProjectKey()).table);
        if (((String)fmt.second).equals("hive")) {
            cmd.add("-targetfieldnames");
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (SchemaColumn col : this.outputDS.getSchema().columns) {
                fieldNames.add(col.getName());
            }
            cmd.add("\"" + StringUtils.join(fieldNames, (String)",") + "\"");
            cmd.add("-targettableschema");
            cmd.add("\"" + HiveSchemaHandler.tableDefFromSchema(this.outputDS.getSchema()).replace("\n", " ") + "\"");
        }
        if (this.csvSeparator != null) {
            cmd.add("-separator");
            cmd.add("'" + this.csvSeparator + "'");
        }
        return cmd;
    }

    private List<String> generateHadoopToTeradataCommand(HDFSDatasetHandler sourceDSHandler, Map<String, String> envVars) throws IOException, InterruptedException, DKUSecurityException {
        List<String> cmd = this.getCommandBase(envVars, this.outputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class));
        Pair<String, String> fmt = this.dssFormatToTDCHFormatAndMode(this.inputDS.getFormatType());
        cmd.add("-sourcepaths");
        cmd.add(sourceDSHandler.getFullyQualifiedRootPath());
        cmd.add("-fileformat");
        cmd.add((String)fmt.first);
        cmd.add("-jobtype");
        cmd.add((String)fmt.second);
        cmd.add("-targettable");
        cmd.add(this.outputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)this.outputDS.getProjectKey()).table);
        if (this.csvSeparator != null) {
            cmd.add("-separator");
            cmd.add("'" + this.csvSeparator + "'");
        }
        return cmd;
    }

    private Pair<String, String> dssFormatToTDCHFormatAndMode(String dssFormatType) {
        switch (dssFormatType) {
            case "csv": {
                return new Pair((Object)"textfile", (Object)"hdfs");
            }
            case "orcfile": {
                return new Pair((Object)"orcfile", (Object)"hive");
            }
            case "rcfile": {
                return new Pair((Object)"rcfile", (Object)"hive");
            }
            case "avro": {
                return new Pair((Object)"avrofile", (Object)"hdfs");
            }
            case "sequencefile": {
                return new Pair((Object)"sequencefile", (Object)"hive");
            }
        }
        throw ErrorContext.iae((String)("Unsupported fileFormat for TDCH: " + dssFormatType));
    }

    private File writeTDCHScript(String[] cmd) throws IOException {
        AutoDelete tmpFolder = FlowJobUtils.getTmpFolder("tdch-engine", "tdch");
        File tmpScript = new File((File)tmpFolder, String.valueOf(this.engineVariant) + ".tdch.sh");
        FileUtils.write((File)tmpScript, (CharSequence)"#!/bin/bash \n", (boolean)true);
        FileUtils.write((File)tmpScript, (CharSequence)StringUtils.join((Object[])cmd, (String)" "), (boolean)true);
        if (!tmpScript.setExecutable(true)) {
            throw new IOException("Couldn't make executable the TDCH Wrapper  " + tmpScript.getAbsolutePath());
        }
        return tmpScript;
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        this.init();
        try (DatasetHandler inputDH = DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, this.outputDS);){
            List<String> cmd;
            Map envVars = DKUtils.getEnvironment();
            if (envVars.get("DKU_TDCH_CLASSPATH") != null) {
                envVars.put("HADOOP_CLASSPATH", (String)envVars.get("DKU_TDCH_CLASSPATH"));
            } else {
                envVars.put("HADOOP_CLASSPATH", (String)envVars.get("DKU_HIVE_CP"));
            }
            envVars.put("TDCH_PWD", this.tdCreds.password);
            if (this.impersonationService.isEnabled()) {
                envVars.put("HADOOP_PROXY_USER", this.impersonationService.getTargetUser((String)this.outputDS.getProjectKey(), (AuthCtx)this.authCtx).hadoopUser);
            }
            if (this.engineVariant.equals("TERADATA_TO_HADOOP")) {
                cmd = this.generateTeradataToHadoopCommand((HDFSDatasetHandler)dh, envVars);
            } else if (this.engineVariant.equals("HADOOP_TO_TERADATA")) {
                cmd = this.generateHadoopToTeradataCommand((HDFSDatasetHandler)inputDH, envVars);
            } else {
                throw new Error("unreachable");
            }
            if (this.params.splitMode != SplitMode.DEFAULT) {
                cmd.add("-method");
                cmd.add(this.params.splitMode.getMethod());
            }
            cmd.add("-nummappers");
            cmd.add("" + this.params.numberOfExecutors);
            File scriptFile = this.writeTDCHScript(cmd.toArray(new String[0]));
            String[] command = new String[]{"/bin/bash", scriptFile.getAbsolutePath()};
            dh.clearAllData();
            if (this.engineVariant.equals("HADOOP_TO_TERADATA")) {
                dh.createManaged();
            }
            logger.info((Object)("Running TDCH:" + String.valueOf(command)));
            AutoDelete processDir = FlowJobUtils.getTmpFolder("tdch-engine", "tdch-out");
            DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs(command).withEnv(envVars).withCwd((File)processDir).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler("TDCH sync process failed"));
            execBuilder.exec();
        }
        catch (IOException e) {
            throw new IOException("TDCH engine execution failed ", e);
        }
    }

    public static class TDCHParams {
        public SplitMode splitMode = SplitMode.DEFAULT;
        public int numberOfExecutors = 2;
    }

    static enum SplitMode {
        DEFAULT(null),
        BY_HASH("split.by.hash"),
        BY_VALUE("split.by.value"),
        BY_PARTITION("split.by.partition"),
        BY_AMP("split.by.amp"),
        INTERNAL_FASTLOAD("internal.fastload");

        private String method;

        private SplitMode(String m) {
            this.method = m;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

