/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.SerializedJob;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.dataflow.kernel.master.JobKernelsManager;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class BuildState {
    List<BeingBuilt> beingBuilt = new ArrayList<BeingBuilt>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jobs.state");
    private static final DKULogger dumpLogger = DKULogger.getLogger((String)"dku.jobs.state.dump");

    public BuildState() {
        DSSMetrics.registry().register("dku.jobs.activities.possiblyRunning", (Metric)new Gauge<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getValue() {
                BuildState buildState = BuildState.this;
                synchronized (buildState) {
                    long ret = 0L;
                    for (BeingBuilt bb : BuildState.this.beingBuilt) {
                        if (!bb.running) continue;
                        ++ret;
                    }
                    return ret;
                }
            }
        });
        DSSMetrics.registry().register("dku.jobs.activities.queued", (Metric)new Gauge<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getValue() {
                BuildState buildState = BuildState.this;
                synchronized (buildState) {
                    long ret = 0L;
                    for (BeingBuilt bb : BuildState.this.beingBuilt) {
                        if (bb.running) continue;
                        ++ret;
                    }
                    return ret;
                }
            }
        });
    }

    private Set<BeingBuilt> getIncompatible(SerializedJob sj) {
        HashSet<BeingBuilt> ret = new HashSet<BeingBuilt>();
        for (SerializedJobActivity sja : sj.allActivities.values()) {
            for (SerializedJobActivity.Target tgt : sja.targets) {
                BeingBuilt bb = this.find(tgt.projectKey, tgt.datasetName, tgt.partitionId);
                if (bb == null) continue;
                ret.add(bb);
            }
        }
        return ret;
    }

    public synchronized Set<BeingBuilt> testIncompatibilities(SerializedJob sj) {
        Set<BeingBuilt> ret = this.getIncompatible(sj);
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public synchronized Set<BeingBuilt> testAndSetIncompatibilities(String jobProjectKey, String jobId, SerializedJob sj) {
        Set<BeingBuilt> ret = this.getIncompatible(sj);
        if (ret.size() > 0) {
            return ret;
        }
        for (SerializedJobActivity sja : sj.allActivities.values()) {
            for (SerializedJobActivity.Target tgt : sja.targets) {
                BeingBuilt bb = new BeingBuilt();
                bb.jobProjectKey = jobProjectKey;
                bb.jobId = jobId;
                bb.datasetProjectKey = tgt.projectKey;
                bb.datasetName = tgt.datasetName;
                bb.partition = tgt.partitionId;
                this.beingBuilt.add(bb);
            }
        }
        return null;
    }

    private BeingBuilt find(String datasetProjectKey, String datasetName, String partitionId) {
        for (BeingBuilt bb : this.beingBuilt) {
            if (!bb.datasetProjectKey.equals(datasetProjectKey) || !bb.datasetName.equals(datasetName) || !bb.partition.equals(partitionId)) continue;
            return bb;
        }
        return null;
    }

    private BeingBuilt find(String jobProjectKey, String jobId, String datasetProjectKey, String datasetName, String partitionId) {
        for (BeingBuilt bb : this.beingBuilt) {
            if (!bb.jobProjectKey.equals(jobProjectKey) || !bb.jobId.equals(jobId) || !bb.datasetProjectKey.equals(datasetProjectKey) || !bb.datasetName.equals(datasetName) || !bb.partition.equals(partitionId)) continue;
            return bb;
        }
        return null;
    }

    public synchronized DatasetBuildState getDatasetBuildState(String datasetProjectKey, String datasetName) {
        DatasetBuildState ret = new DatasetBuildState();
        for (BeingBuilt bb : this.beingBuilt) {
            if (!bb.datasetProjectKey.equals(datasetProjectKey) || !bb.datasetName.equals(datasetName)) continue;
            JobRef jr = new JobRef(bb.jobProjectKey, bb.jobId);
            if (bb.running) {
                ret.beingBuilt.add(jr);
                continue;
            }
            ret.aboutToBeBuilt.add(jr);
        }
        for (JobRef jr : ret.beingBuilt) {
            ret.aboutToBeBuilt.remove(jr);
        }
        if (ret.beingBuilt.size() == 0 && ret.aboutToBeBuilt.size() == 0) {
            return null;
        }
        return ret;
    }

    public synchronized void onActivityStarted(String jobProjectKey, String jobId, SerializedJobActivity activity) {
        for (SerializedJobActivity.Target tgt : activity.targets) {
            BeingBuilt bb = this.find(jobProjectKey, jobId, tgt.projectKey, tgt.datasetName, tgt.partitionId);
            if (bb == null) {
                logger.errorV("Could not find dataset being built: %s.%s (%s)", new Object[]{tgt.projectKey, tgt.datasetName, tgt.partitionId});
                return;
            }
            bb.running = true;
        }
    }

    public synchronized void onActivityDone(String jobProjectKey, String jobId, SerializedJobActivity activity) {
        for (SerializedJobActivity.Target tgt : activity.targets) {
            BeingBuilt bb = this.find(jobProjectKey, jobId, tgt.projectKey, tgt.datasetName, tgt.partitionId);
            if (bb == null) {
                logger.errorV("Could not find dataset being built: %s.%s (%s)", new Object[]{tgt.projectKey, tgt.datasetName, tgt.partitionId});
                return;
            }
            if (!bb.running) {
                logger.warnV("Activity done before start ?: %s.%s (%s)", new Object[]{tgt.projectKey, tgt.datasetName, tgt.partitionId});
            }
            this.beingBuilt.remove(bb);
        }
    }

    public synchronized void removeJob(String jobProjectKey, String jobId) {
        this.beingBuilt.removeIf(bb -> bb.jobProjectKey.equals(jobProjectKey) && bb.jobId.equals(jobId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        BuildService buildService = (BuildService)SpringUtils.getBean(BuildService.class);
        long pendingJobs = buildService.getJobWithStateCount(JobState.PENDING);
        JobKernelsManager jekManager = (JobKernelsManager)((Object)SpringUtils.getBean(JobKernelsManager.class));
        int freeJeks = jekManager.getFreeKernelCount();
        int totalActivities = 0;
        int runningActivities = 0;
        int queuedActivities = 0;
        HashSet<String> projects = new HashSet<String>();
        HashSet<CallSite> jobs = new HashSet<CallSite>();
        HashSet<CallSite> datasets = new HashSet<CallSite>();
        BuildState buildState = this;
        synchronized (buildState) {
            for (BeingBuilt bb : this.beingBuilt) {
                projects.add(bb.jobProjectKey);
                jobs.add((CallSite)((Object)(bb.jobProjectKey + "_" + bb.jobId)));
                datasets.add((CallSite)((Object)(bb.datasetProjectKey + "_" + bb.datasetName)));
                ++totalActivities;
                if (bb.running) {
                    ++runningActivities;
                    continue;
                }
                ++queuedActivities;
            }
            dumpLogger.infoV("Build state: runningJobs=%d pendingJobs=%d totalActivities=%d runningActivities=%d queuedActivities=%d forTotalProjects=%d forTotalComputables=%d freeJeks=%d", new Object[]{jobs.size(), pendingJobs, totalActivities, runningActivities, queuedActivities, projects.size(), datasets.size(), freeJeks});
            if (dumpLogger.isTraceEnabled()) {
                dumpLogger.trace((Object)"Being built");
                for (BeingBuilt bb : this.beingBuilt) {
                    dumpLogger.trace((Object)("  " + JSON.json((Object)bb)));
                }
                dumpLogger.trace((Object)"---------");
            }
        }
    }

    public static class BeingBuilt {
        public String datasetProjectKey;
        public String datasetName;
        public String partition;
        public String jobProjectKey;
        public String jobId;
        boolean running;
    }

    public static class DatasetBuildState {
        public Set<JobRef> beingBuilt = new HashSet<JobRef>();
        public Set<JobRef> aboutToBeBuilt = new HashSet<JobRef>();
    }

    static class JobRef {
        String projectKey;
        String jobId;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
            result = 31 * result + (this.projectKey == null ? 0 : this.projectKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobRef other = (JobRef)obj;
            if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
                return false;
            }
            return !(this.projectKey == null ? other.projectKey != null : !this.projectKey.equals(other.projectKey));
        }

        JobRef(String projectKey, String jobId) {
            this.projectKey = projectKey;
            this.jobId = jobId;
        }
    }
}

