/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import com.dataiku.dip.dataflow.kernel.Model;
import com.dataiku.dip.dataflow.kernel.master.ActivityRunRequest;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.dataflow.kernel.master.JobExecutionKernelHandle;
import com.dataiku.dip.dataflow.kernel.master.locking.Permit;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.ContextAwareTicketPayload;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.DatasetChangedEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class JobSession
implements ContextAwareTicketPayload {
    PubSubService pubSub;
    public JobDef def;
    JobState state = JobState.NOT_STARTED;
    String projectKey;
    String jobId;
    volatile JobExecutionKernelHandle kernel;
    AuthCtx authCtx;
    APITicketService.Ticket apiTicket;
    long jobStartTime;
    long resolveStartTime;
    long resolveEndTime;
    long execStartTime;
    long execEndTime;
    int kernelPid = -1;
    int jvmPid = -1;
    ComputeResourceUsage cru;
    ProcessResourceUsageMonitor resourceUsageMonitor;
    FutureTask<Void> future;
    final CompletableFuture<Set<String>> validatedPreviewFuture = new CompletableFuture();
    volatile boolean abortNotified;
    boolean isStopped;
    Map<String, Permit<ActivityRunRequest>> buildPermits = new HashMap<String, Permit<ActivityRunRequest>>();
    Throwable unexpectedFailureThrowable;
    Throwable checksFailureThrowable;
    Model.ResolveResponse previewResponse;
    Set<BuildState.BeingBuilt> incompatibilities;
    CoreJobStatus lastKnownCoreStatus;
    private static final Logger logger = Logger.getLogger((String)"dku.jobs");

    public AutoCloseable openTicketContext() {
        return new AutoCloseable(){
            private final ScenarioRun previousScenarioRun;
            private final StepRun previousStepRun;
            private ScenarioRunContext scenarioRunContext = (ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class);
            {
                this.previousScenarioRun = this.scenarioRunContext.getScenarioRun();
                this.previousStepRun = this.scenarioRunContext.getStepRun();
                if (JobSession.this.def.stepRun != null) {
                    this.scenarioRunContext.setScenarioRun(JobSession.this.def.scenarioRun);
                    this.scenarioRunContext.setStepRun(JobSession.this.def.stepRun);
                }
            }

            @Override
            public void close() {
                this.scenarioRunContext.setScenarioRun(this.previousScenarioRun);
                this.scenarioRunContext.setStepRun(this.previousStepRun);
            }
        };
    }

    public synchronized void log(String line) {
        if (this.kernel == null) {
            logger.info((Object)line);
        } else {
            this.kernel.log(line);
        }
    }

    synchronized SerializedJobStatus getLastKnownStatus() {
        SerializedJobStatus sjs = new SerializedJobStatus();
        if (this.lastKnownCoreStatus != null) {
            sjs.activities = this.lastKnownCoreStatus.activities;
        }
        sjs.def = this.def;
        sjs.jobStartTime = this.jobStartTime;
        sjs.jobEndTime = this.execEndTime;
        sjs.state = this.state;
        sjs.kernelPid = this.getKernelPid();
        sjs.jvmPid = this.getJvmPid();
        if (this.previewResponse != null) {
            sjs.job = this.previewResponse.job;
            sjs.jobBeforePrune = this.previewResponse.jobBeforePrune;
        }
        if (this.resolveStartTime > 0L) {
            sjs.resolveDuration = this.resolveEndTime > 0L ? this.resolveEndTime - this.resolveStartTime : System.currentTimeMillis() - this.resolveStartTime;
        }
        if (this.execStartTime > 0L) {
            sjs.execDuration = this.execEndTime != 0L ? this.execEndTime - this.execStartTime : System.currentTimeMillis() - this.execStartTime;
        }
        if (this.unexpectedFailureThrowable != null && this.unexpectedFailureThrowable instanceof APIError.SerializedErrorException) {
            sjs.unexpectedFailure = ((APIError.SerializedErrorException)this.unexpectedFailureThrowable).error;
        } else if (this.unexpectedFailureThrowable != null) {
            sjs.unexpectedFailure = new SerializedError(this.unexpectedFailureThrowable, true);
        }
        if (this.checksFailureThrowable != null && this.checksFailureThrowable instanceof APIError.SerializedErrorException) {
            sjs.checksFailure = ((APIError.SerializedErrorException)this.checksFailureThrowable).error;
        } else if (this.checksFailureThrowable != null) {
            sjs.checksFailure = new SerializedError(this.checksFailureThrowable, true);
        }
        if (this.incompatibilities != null) {
            sjs.incompatibilities = Lists.newArrayList(this.incompatibilities);
        }
        return sjs;
    }

    int getKernelPid() {
        if (this.kernelPid < 0 && this.kernel != null) {
            this.kernelPid = this.kernel.getPid();
        }
        return this.kernelPid;
    }

    int getJvmPid() {
        if (this.jvmPid < 0 && this.kernel != null) {
            this.jvmPid = this.kernel.getJvmPID();
        }
        return this.jvmPid;
    }

    synchronized void diskWriteStatus(SerializedJobStatus sjs) {
        try {
            sjs.state = this.state;
            JSON.prettyToFile((Object)sjs, (File)FlowJobUtils.jobStatusFile(false, this.projectKey, this.jobId));
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to write job status", e);
        }
    }

    synchronized void updateAndWriteStatus(CoreJobStatus cjs) {
        this.lastKnownCoreStatus = cjs;
        this.diskWriteStatus(this.getLastKnownStatus());
    }

    void transitionToState(JobState target) {
        this.transitionToState(target, 0L, true);
    }

    void transitionToState(JobState target, long warningCount) {
        this.transitionToState(target, warningCount, true);
    }

    void transitionToState(JobState target, long warningCount, boolean publishEventChanged) {
        if (target == this.state) {
            return;
        }
        boolean ok = false;
        switch (this.state) {
            case NOT_STARTED: {
                ok = target == JobState.PENDING;
                break;
            }
            case PENDING: {
                ok = target == JobState.STARTING || target == JobState.ABORTED || target == JobState.FAILED;
                break;
            }
            case STARTING: {
                ok = target == JobState.COMPUTING_DEPS || target == JobState.ABORTED || target == JobState.FAILED;
                break;
            }
            case COMPUTING_DEPS: {
                ok = target == JobState.RUNNING || target == JobState.WAITING_CONFIRMATION || target == JobState.FAILED || target == JobState.ABORTED || target == JobState.DONE;
                break;
            }
            case PAUSED: {
                ok = target == JobState.RUNNING;
                break;
            }
            case RUNNING: {
                ok = target == JobState.PAUSED || target == JobState.FAILED || target == JobState.DONE || target == JobState.ABORTED;
                break;
            }
            case WAITING_CONFIRMATION: {
                ok = target == JobState.RUNNING || target == JobState.ABORTED || target == JobState.FAILED;
                break;
            }
            case ABORTED: 
            case DONE: 
            case FAILED: {
                boolean bl = ok = target == JobState.ABORTED;
            }
        }
        if (!ok) {
            throw new IllegalStateException("Invalid job state transition: " + String.valueOf((Object)this.state) + " -> " + String.valueOf((Object)target));
        }
        this.state = target;
        if (publishEventChanged) {
            this.pubSub.publish(new JobStateChangedEvent(this.def, this.state, warningCount));
        }
        if (target.isFinished() && this.lastKnownCoreStatus != null) {
            HashMultimap datasetChangedPartitions = HashMultimap.create();
            for (Map.Entry<String, SerializedJobActivityStatus> entry : this.lastKnownCoreStatus.activities.entrySet()) {
                SerializedJobActivityStatus sjas = entry.getValue();
                if (sjas.state != ActivityState.DONE && sjas.state != ActivityState.SKIPPED && sjas.state != ActivityState.ABORTED && sjas.state != ActivityState.FAILED) continue;
                for (SerializedJobActivityStatus.SerializedTargetDS activityTarget : sjas.targets) {
                    switch (activityTarget.type) {
                        case DATASET: {
                            DatasetLocUtils.DatasetLoc resolvedFullName = DatasetLocUtils.resolveSmart(this.def.projectKey, activityTarget.id);
                            datasetChangedPartitions.put((Object)resolvedFullName, (Object)activityTarget.partition.id);
                            break;
                        }
                    }
                }
            }
            for (Map.Entry<String, SerializedJobActivityStatus> entry : datasetChangedPartitions.asMap().entrySet()) {
                this.pubSub.publish(new DatasetChangedEvent((DatasetLocUtils.DatasetLoc)((Object)entry.getKey()), new ArrayList<String>((Collection)((Object)entry.getValue()))));
            }
        }
    }

    void onJobFailed() {
        if (this.lastKnownCoreStatus != null) {
            for (SerializedJobActivityStatus activityStatus : this.lastKnownCoreStatus.activities.values()) {
                if (activityStatus.state != ActivityState.RUNNING && activityStatus.state != ActivityState.WAITING) continue;
                activityStatus.endTime = System.currentTimeMillis();
                activityStatus.totalTime = activityStatus.endTime - activityStatus.startTime;
                activityStatus.messageCode = null;
                activityStatus.message = null;
                activityStatus.detailedState = null;
                activityStatus.state = ActivityState.FAILED;
            }
        }
    }

    public FlowExecutionService2.JobSummary toLightJobSummary(boolean withKernelPid) {
        FlowExecutionService2.JobSummary js = new FlowExecutionService2.JobSummary();
        js.def = this.def;
        js.state = this.state;
        js.stableState = this.state.isFinished();
        js.startTime = this.jobStartTime;
        if (withKernelPid) {
            js.kernelPid = this.getKernelPid();
        }
        return js;
    }
}

