/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.slave;

import com.codahale.metrics.json.MetricsModule;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.AbstractJobKernelSession;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobComputer;
import com.dataiku.dip.dataflow.graph.utils.JobPrinter;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.JobRunner;
import com.dataiku.dip.dataflow.jobrunner.SerializedJob;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.Model;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.JEKComputeResourceUsageReportingService;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.FixedTicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesUpdateRunner;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class KernelSession
extends AbstractJobKernelSession {
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private JEKComputeResourceUsageReportingService computeResourceUsageReportingService;
    private volatile JobRunner runner;
    public final String jobProjectKey;
    public final String jobId;
    public final ScenarioRun scenarioRun;
    public final StepRun stepRun;
    protected JobDef def;
    public Job job;
    protected JobComputer computeJob;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.job.slave");

    public KernelSession(String jobProjectKey, String jobId, String jobTicketSecret, AuthCtx initiatorAuthCtx, ScenarioRun scenarioRun, StepRun stepRun) throws IOException {
        super(jobTicketSecret, initiatorAuthCtx, "job:" + jobProjectKey + "." + jobId);
        this.jobProjectKey = jobProjectKey;
        this.jobId = jobId;
        this.scenarioRun = scenarioRun;
        this.stepRun = stepRun;
    }

    @Override
    public void close() {
        try (FileOutputStream fos = new FileOutputStream(new File(FlowJobUtils.getCurrentJobFolder(), "metrics.json"));){
            ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
            om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)fos, (Object)DSSMetrics.registry());
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to dump metrics at end of job", (Throwable)e);
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model.ResolveResponse resolve() throws Exception {
        assert (this.t == null);
        assert (this.def == null);
        assert (this.computeJob == null);
        assert (this.job == null);
        logger.info((Object)"Starting to resolve job");
        BuildUtils.copyJobEnvFile(this.jobProjectKey, this.jobId);
        BuildUtils.captureEnvironmentVariables(this.jobProjectKey, this.jobId);
        File localConfigArchive = FlowJobUtils.jobLocalConfigArchive(false, this.jobProjectKey, this.jobId);
        File localConfigFolder = FlowJobUtils.jobLocalConfigFolder(false, this.jobProjectKey, this.jobId);
        this.t = localConfigArchive.isFile() ? this.singleWTxService.beginTheSingleTransactionOnArchive(localConfigArchive, FlowJobUtils.LOCALCONFIG_FOLDER_NAME, this.authCtx) : this.singleWTxService.beginTheSingleTransactionOnDirectory(localConfigFolder, this.authCtx);
        this.impersonationService.setImpersonationConfig(this.generalSettingsDAO.read().impersonation);
        VariablesUpdateRunner vur = new VariablesUpdateRunner();
        vur.doUpdate((RWTransactionRef)this.t);
        if (this.t.isFile("run/app-manifests.json")) {
            this.loadApps();
        }
        this.def = (JobDef)JSON.parseFile((File)FlowJobUtils.jobDefFile(false, this.jobProjectKey, this.jobId), JobDef.class);
        logger.info((Object)JSON.pretty((Object)JSON.parseFile((File)FlowJobUtils.jobDefFile(false, this.jobProjectKey, this.jobId), JsonObject.class)));
        JobContext.setJob(this.def.projectKey, this.def.id, null);
        this.activateScenarioVariablesInThread();
        logger.info((Object)"Loading recipes");
        FlowGraph graph = this.graphService.getGlobalGraph(true);
        logger.info((Object)"Recipes loaded, computing job details");
        this.computeJob = new JobComputer(this.authCtx, this.def, graph);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forJobDepsComputation((AuthCtx)this.authCtx, (String)this.def.projectKey, (String)this.def.id));
        try {
            this.job = this.computeJob.compute();
        }
        finally {
            CurrentComputeResourceUsageContext.clear();
        }
        JobContext.setJob(this.def.projectKey, this.def.id, this.job);
        logger.info((Object)"Done computing job data, dumping graph");
        logger.info((Object)JobPrinter.print(this.job, 0));
        Map<String, Set<TaggableObjectsService.TaggableObjectRef>> sourceRefs = this.job.getSources();
        logger.info((Object)("Job has the following sources: " + JSON.json(sourceRefs)));
        if (!KernelSession.shouldCheckTaggableObjectReadUsePrivileges()) {
            logger.info((Object)"Legacy dataset read privilege checks enabled, will not check taggable object read/use privileges");
        }
        for (Map.Entry<String, Set<TaggableObjectsService.TaggableObjectRef>> sourceRefsEntry : sourceRefs.entrySet()) {
            for (TaggableObjectsService.TaggableObjectRef ref : sourceRefsEntry.getValue()) {
                if (KernelSession.shouldCheckTaggableObjectReadUsePrivileges()) {
                    this.checkTaggableObjectReadUsePrivilege(ref, sourceRefsEntry.getKey());
                    continue;
                }
                if (ref.type != ITaggingService.TaggableType.DATASET) continue;
                this.checkDatasetReadPrivilege(ref.getLoc(), Privileges.DatasetLevelPrivilegeType.READ_DATA);
            }
        }
        Model.ResolveResponse rr = new Model.ResolveResponse();
        rr.jobBeforePrune = this.computeJob.getBeforePruning();
        rr.job = this.job.getSerialized();
        rr.initialStatus = this.job.getStatus();
        this.datasetWritingService.configureForJEK(this, (TransactionRef)this.t);
        return rr;
    }

    private void loadApps() throws IOException {
        AppManifest.RecipeAppManifests appsManifest = (AppManifest.RecipeAppManifests)this.t.readObject("run/app-manifests.json", AppManifest.RecipeAppManifests.class);
        for (Map.Entry<String, AppManifest> entry : appsManifest.manifests.entrySet()) {
            logger.info((Object)("Registering recipe-app " + entry.getKey()));
            AppRecipeMeta arm = new AppRecipeMeta(entry.getKey(), entry.getValue());
            RecipeRegistry.register(arm);
        }
    }

    private static boolean shouldCheckTaggableObjectReadUsePrivileges() {
        return ApplicationConfigurator.getParams().getBoolParam("dku.job.checkTaggableObjectReadUsePrivileges", true);
    }

    void activateScenarioVariablesInThread() {
        if (this.scenarioRun != null) {
            this.scenarioRunContext.setScenarioRun(this.scenarioRun);
            this.scenarioRunContext.setStepRun(this.stepRun);
        }
    }

    public JobActivity getActivityById(String id) {
        return this.getActivityById(this.job.topLevelActivity, id, new HashSet<String>());
    }

    private JobActivity getActivityById(JobActivity activity, String id, Set<String> alreadyVisited) {
        if (StringUtils.equals((String)activity.id(), (String)id)) {
            return activity;
        }
        if (alreadyVisited.contains(activity.id())) {
            return null;
        }
        alreadyVisited.add(activity.id());
        for (JobActivity depActivity : activity.dependencies) {
            JobActivity found = this.getActivityById(depActivity, id, alreadyVisited);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public List<String> findAvailableContainerConfigurations(ContainerExecRuntimeConfig.Container container) {
        return ContainerExecUtils.getAllowedContainerNames(this.getAuthCtx(), Collections.singletonList(container), WorkloadType.USER_CODE);
    }

    public SerializedJob getSerialized() {
        return this.job.getSerialized();
    }

    public void notifyAbort() {
        JobRunner runnerLocal = this.runner;
        if (runnerLocal != null) {
            logger.info((Object)"Notify abort to job runner");
            runnerLocal.notifyAbort(this.t);
        }
    }

    public JobRunner getJobRunner() {
        return this.runner;
    }

    public AbortedResult pollAborted() {
        boolean isAborted = false;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 30000L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"Job abort status polling was interrupted", (Throwable)e);
                break;
            }
            JobRunner runnerLocal = this.runner;
            if (runnerLocal == null) {
                logger.debug((Object)"runner is null, exit abort polling");
                break;
            }
            if (!runnerLocal.isAborted()) continue;
            isAborted = true;
            break;
        }
        return new AbortedResult(isAborted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runFully(Set<String> skippedActivityIds, int kernelPid) {
        assert (this.t != null);
        assert (this.def != null);
        assert (this.computeJob != null);
        assert (this.job != null);
        JobContext.setJob(this.def.projectKey, this.def.id, this.job);
        this.activateScenarioVariablesInThread();
        this.job.runSummary.jobType = this.job.def.type;
        this.job.runSummary.triggerType = this.job.def.triggeredFrom;
        try {
            TransactionContext.attach((TransactionRef)this.t);
            this.runner = new JobRunner(this.job, skippedActivityIds, this.generalSettingsDAO.read(), (APITicketService)this.ticketService);
            this.basicMeaningsService.invalidateCache();
            logger.info((Object)("Job run started in kernel with pid " + kernelPid));
            JobStatusUpdater updater = new JobStatusUpdater();
            updater.start();
            this.runner.runJob((TransactionRef)this.t);
            updater.interrupt();
            updater.join();
            try {
                File f = DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{"run-summary.json"});
                JSON.prettyToFile((Object)this.job.runSummary, (File)f);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to write job summary", (Throwable)e);
            }
            for (SerializedJobActivityStatus sa : this.job.getStatus().activities.values()) {
                if (sa.state != ActivityState.FAILED) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Job run failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.runner = null;
        }
    }

    @Override
    public RWTransaction getTransactionRef() {
        return this.t;
    }

    public CoreJobStatus getStatus() {
        assert (this.job != null);
        return this.job.getStatus();
    }

    public static com.dataiku.hproxy.model.pig.ValidationResult doPigCheck(String projectKey, String script) throws Exception {
        logger.info((Object)"Propagating Pig script checking to backend");
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();){
            com.dataiku.hproxy.model.pig.ValidationResult validationResult;
            int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
            try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());){
                validationResult = (com.dataiku.hproxy.model.pig.ValidationResult)apiClient.postFormToJSON("/dip/api/tintercom/hproxy/check-pig-script", com.dataiku.hproxy.model.pig.ValidationResult.class, new Object[]{"script", script, "projectKey", projectKey});
            }
            return validationResult;
        }
    }

    public static ValidationResult doHiveCheck(String projectKey, String initQuery, String execQuery, List<SimpleKeyValue> extraConf, boolean isExplainPlan, boolean useGlobalMetastore, boolean onlyCheckInsertOverwrites) throws Exception {
        logger.info((Object)"Propagating Hive script checking to backend");
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();){
            ValidationResult validationResult;
            int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
            try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());){
                validationResult = (ValidationResult)apiClient.postFormToJSON("/dip/api/tintercom/hproxy/check-hive-script", ValidationResult.class, new Object[]{"initQuery", initQuery, "execQuery", execQuery, "extraConf", extraConf, "isExplainPlan", isExplainPlan, "useGlobalMetastore", useGlobalMetastore, "onlyCheckInsertOverwrites", onlyCheckInsertOverwrites, "projectKey", projectKey});
            }
            return validationResult;
        }
    }

    public void downloadLocalConfig(HttpServletResponse resp, String executionId, String executionSecretId) {
        this.ensureCDEOrigin(executionId, executionSecretId);
        logger.info((Object)"Serving localconfig/");
        try {
            resp.setStatus(200);
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + FlowJobUtils.LOCALCONFIG_ARCHIVE_NAME + "\"");
            try (ZipWriteFS zipFs = new ZipWriteFS((OutputStream)resp.getOutputStream());){
                FSUtils.newRecursiveCopy().filter(new RelFileFilter(){
                    private final Pattern TOP_LEVEL_EXCLUSION_PATTERN = Pattern.compile("^(lib)$");
                    private final Pattern PROJECT_EXCLUSION_PATTERN = Pattern.compile("projects/[^/]*/(lib)/.*");

                    public boolean accept(ReadOnlyFS fs, RelFile file) throws IOException {
                        String path = file.getFullPath();
                        for (Pattern p : Arrays.asList(this.TOP_LEVEL_EXCLUSION_PATTERN, this.PROJECT_EXCLUSION_PATTERN)) {
                            if (!p.matcher(path).matches()) continue;
                            return false;
                        }
                        return true;
                    }
                }).from((ReadOnlyFS)this.getTransactionRef()).to((ReadWriteFS)zipFs, FlowJobUtils.LOCALCONFIG_FOLDER_NAME).run();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send files", (Throwable)e);
        }
    }

    public void forwardPubSubEventToBackend(DSSEvent event) {
        this.computeResourceUsageReportingService.publishPubSubEvent(event);
    }

    static /* synthetic */ FixedTicketService access$000(KernelSession x0) {
        return x0.ticketService;
    }

    public static class AbortedResult {
        boolean isAborted;

        public AbortedResult(boolean isAborted) {
            this.isAborted = isAborted;
        }

        public boolean getIsAborted() {
            return this.isAborted;
        }
    }

    class JobStatusUpdater
    extends Thread {
        JobStatusUpdater() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

