/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.AbstractJobKernelSession;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.streaming.ksql.KsqlContinuousRecipeRunner;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonRecipeRunner;
import com.dataiku.dip.recipes.streaming.scala.StreamingSparkScalaRecipeRunner;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ShortTaskExecutor;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeRunner;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CAKernelSession
extends AbstractJobKernelSession {
    @Autowired
    private ImpersonationResolverService impersonationService;
    private ContinuousActivity activity;
    FlowRunnable mainRunner = null;
    private static Logger logger = Logger.getLogger((String)"dku.job.slave");

    public CAKernelSession(ContinuousActivity activity, String jobTicketSecret, AuthCtx initiatorAuthCtx) throws IOException {
        super(jobTicketSecret, initiatorAuthCtx, "continuousactivity:" + activity.projectKey + "." + activity.recipeId);
        this.activity = activity;
    }

    public String getJobProjectKey() {
        return this.activity.projectKey;
    }

    public String getJobId() {
        return this.activity.recipeId;
    }

    public void notifyAbort() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        futures.add(ShortTaskExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.info((Object)("Sending abort to " + String.valueOf(CAKernelSession.this.mainRunner) + " (is abortable=" + (CAKernelSession.this.mainRunner instanceof AbortableRecipeRunner) + ")"));
                if (CAKernelSession.this.mainRunner != null && CAKernelSession.this.mainRunner instanceof AbortableRecipeRunner) {
                    ((AbortableRecipeRunner)CAKernelSession.this.mainRunner).notifyBeforeAborting();
                }
                return null;
            }
        }));
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                logger.error((Object)"Unable to abort activity", e);
            }
        }
    }

    public SerializedError run() throws IOException {
        File configFolder = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.t = this.singleWTxService.beginTheSingleTransactionOnDirectory(configFolder, this.authCtx);
        try {
            TransactionContext.attach((TransactionRef)this.t);
            this.datasetWritingService.configureForCAK(this, (TransactionRef)this.t);
            this.impersonationService.setImpersonationConfig(this.generalSettingsDAO.read().impersonation);
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(this.activity.projectKey, this.activity.recipeId);
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forContinuousActivity((AuthCtx)this.authCtx, (String)this.activity.projectKey, (String)this.activity.recipeId);
            cruContext.activityType = "recipe";
            cruContext.recipeType = sr.type;
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            switch (sr.type) {
                case "csync": {
                    this.mainRunner = new CSyncRecipeRunner(this.activity, sr);
                    break;
                }
                case "streaming_spark_scala": {
                    this.mainRunner = new StreamingSparkScalaRecipeRunner(this.activity, sr);
                    break;
                }
                case "cpython": {
                    this.mainRunner = new ContinuousPythonRecipeRunner(this.activity, sr);
                    break;
                }
                case "ksql": {
                    this.mainRunner = new KsqlContinuousRecipeRunner(this.activity, sr);
                    break;
                }
                default: {
                    throw new Error("unknonwn continuous activity type " + sr.type);
                }
            }
            SpringUtils.getInstance().autowire((Object)this.mainRunner);
            this.mainRunner.run();
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"Job run failed", (Throwable)e);
            return new SerializedError((Throwable)e, true);
        }
    }

    @Override
    public RWTransaction getTransactionRef() {
        return this.t;
    }
}

