/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.streaming.slave.ContinuousActivityKernel;
import com.dataiku.dip.dataflow.streaming.slave.RPCModel;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ContinuousActivityRunner
extends AutoRestartingProcessRunner {
    private final String runId;
    private final DSSAuthCtx authCtx;
    private final ContinuousActivity activity;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    private ContinuousActivityKernel kernel;
    private File jobDir;
    private volatile boolean aborted = false;
    private static Map<String, ContinuousActivityKernel> startingKernels = Maps.newConcurrentMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public ContinuousActivityRunner(DSSAuthCtx authCtx, ContinuousActivity activity, String runId) {
        this.activity = activity;
        this.authCtx = authCtx;
        this.runId = runId;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private String getActivityUniqueId() {
        return this.activity.projectKey + "." + this.activity.recipeId + "." + this.runId + " ." + this.attemptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        logger.info((Object)"Running CA runner");
        boolean wasStarted = false;
        String activityUniqueId = this.getActivityUniqueId();
        this.jobDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", this.activity.projectKey, this.activity.recipeId, "runs", "run-" + this.runId, "attempt-" + this.attemptId});
        File statusFile = new File(this.jobDir, "status.json");
        JSON.prettyToFile((Object)"starting", (File)statusFile);
        APITicketService.Ticket ticket = this.apiTicketService.createTicket((AuthCtx)this.authCtx, "continuous_activity:" + activityUniqueId, (Object)this);
        try {
            DKUFileUtils.mkdirs((File)this.jobDir);
            ContinuousActivityRunner continuousActivityRunner = this;
            synchronized (continuousActivityRunner) {
                block35: {
                    if (!this.aborted) break block35;
                    logger.info((Object)"Skipping activity as it has been aborted before it was started.");
                    return;
                }
                this.kernel = new ContinuousActivityKernel(activityUniqueId, this.jobDir);
            }
            startingKernels.put(activityUniqueId, this.kernel);
            try {
                this.kernel.start();
            }
            finally {
                startingKernels.remove(activityUniqueId);
            }
            wasStarted = true;
            Thread currentThread = Thread.currentThread();
            if (currentThread instanceof FutureThread) {
                ((FutureThread)((Object)currentThread)).clearScenarioRunContext();
            }
            RPCModel.RunQuery ssq = new RPCModel.RunQuery();
            ssq.definition = this.activity;
            ssq.attemptId = this.attemptId;
            ssq.ticketSecret = ticket.getSecret();
            ssq.initiatorAuthContext = this.authCtx;
            JSON.prettyToFile((Object)"running", (File)statusFile);
            try (Transaction tr = this.transactionService.beginRead();){
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(this.activity.projectKey, this.activity.recipeId);
                for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
                    FlowComputable target = this.computableFromRefService.get(this.activity.projectKey, output.ref);
                    ITaggingService.TaggableType type = target.getType().toTaggableType();
                    DatasetLocUtils.DatasetLoc resolved = DatasetLocUtils.resolveFull(target.getFullId());
                    TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(resolved.getProjectKey(), type, resolved.getId());
                    this.neverBuiltComputablesCacheService.remove(ref);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to mark outputs as built");
            }
            SerializedError err = (SerializedError)this.kernel.apiClient.postObject("/cak/pintercom/run", SerializedError.class, (Object)ssq);
            if (!this.aborted) {
                JSON.prettyToFile((Object)"done", (File)statusFile);
            }
            this.kernel.killNoWaitNoException(true);
            if (err != null) {
                JSON.prettyToFile((Object)err, (File)new File(this.jobDir, "error.json"));
                throw new APIError.SerializedErrorException(err);
            }
            if (this.kernel.isFinished() && this.kernel.getReturnCode() != 0) {
                throw new Exception("Process exited with code " + this.kernel.getReturnCode());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failure during kernel run (wasStarted=" + wasStarted + ")"), (Throwable)e);
            if (!this.aborted) {
                JSON.prettyToFile((Object)"failed", (File)statusFile);
            }
            if (!wasStarted) {
                throw new AutoRestartingProcessRunner.BackendStartFailedException("Backend died before start", e, this.getLogTail());
            }
            throw new AutoRestartingProcessRunner.BackendDiedException("Backend died while running", e, this.getLogTail());
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
            if (this.kernel != null) {
                try {
                    this.kernel.killWithoutMercy();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to kill kernel", e);
                }
            }
        }
    }

    @Override
    public SmartLogTail getLogTail() {
        if (this.kernel != null) {
            return this.kernel.getLogTail();
        }
        return null;
    }

    @Override
    public Integer getPid() {
        if (this.kernel != null) {
            return this.kernel.getPid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean noKernel;
        logger.info((Object)"Stopping continuous activity runner: sending abort signal");
        boolean alreadyAborted = this.aborted;
        ContinuousActivityRunner continuousActivityRunner = this;
        synchronized (continuousActivityRunner) {
            this.aborted = true;
            noKernel = this.kernel == null;
        }
        if (!alreadyAborted) {
            try {
                JSON.prettyToFile((Object)"aborted", (File)new File(this.jobDir, "status.json"));
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to write aborted status", (Throwable)e);
            }
        }
        if (noKernel) {
            return;
        }
        String activityUniqueId = this.getActivityUniqueId();
        try {
            for (int count = 0; startingKernels.containsKey(activityUniqueId) && count < 10; ++count) {
                Thread.sleep(250L);
            }
            if (startingKernels.containsKey(activityUniqueId)) {
                logger.warn((Object)"CA kernel is still in starting mode while aborting.");
            }
            if (this.kernel.apiClient != null) {
                this.kernel.apiClient.postObject("/cak/pintercom/abort", 30000, Void.class, new Object());
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to properly stop CA kernel. Will kill", t);
        }
        this.kernel.killTreeNoWaitNoException(true);
    }

    public static ContinuousActivityKernel getStartingKernel(String kernelId) {
        return startingKernels.get(kernelId);
    }
}

