/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ColumnUniqueValuesRule
extends AbstractMultiColumnRule
implements MetricsBasedDataQualityRule {
    public static final String TYPE = "ColumnUniqueValuesRule";
    public List<String> columns = new ArrayList<String>();
    @Nullable
    public ThresholdType thresholdType;
    public double minimum;
    public boolean minimumEnabled;
    public double softMinimum;
    public boolean softMinimumEnabled;

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<Metric> getMetricsForOneColumn(String column) {
        assert (this.thresholdType != null);
        switch (this.thresholdType) {
            case ENTIRE_COLUMN: {
                return Arrays.asList(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_DISTINCT, column, null), new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column, null));
            }
            case MIN_PERCENTAGE: {
                return Arrays.asList(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_UNIQUE, column, null), new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column, null));
            }
            case MIN_COUNT: {
                return Collections.singletonList(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_UNIQUE, column, null));
            }
        }
        throw new IllegalStateException("Unknown threshold type");
    }

    private long readMetricsValue(AbstractCheckContext context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics metricType, String column) throws Exception {
        return ReadMetricValueHelper.readLongMetricsValue(context, Metric.serializeMetric(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(metricType, column, null)));
    }

    @Override
    public AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        assert (this.thresholdType != null);
        try {
            switch (this.thresholdType) {
                case ENTIRE_COLUMN: {
                    long distinctCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_DISTINCT, column);
                    long totalCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column);
                    if (totalCount != distinctCount) {
                        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Duplicates found");
                    }
                    return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, String.format("%d unique value%s", distinctCount, distinctCount == 1L ? "" : "s"));
                }
                case MIN_COUNT: {
                    long uniqueCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_UNIQUE, column);
                    return new MetricInNumericRangeCheck().withMinimum(this.minimumEnabled, this.minimum).withSoftMinimum(this.softMinimumEnabled, this.softMinimum).runForResolvedValue(uniqueCount);
                }
                case MIN_PERCENTAGE: {
                    long uniqueCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_UNIQUE, column);
                    long nonEmptyCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column);
                    if (nonEmptyCount == 0L) {
                        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot compute percentage-based rule: no non-empty values");
                    }
                    return new MetricInNumericRangeCheck().withMinimum(this.minimumEnabled, this.minimum).withSoftMinimum(this.softMinimumEnabled, this.softMinimum).runForResolvedValue(100.0 * (double)uniqueCount / (double)nonEmptyCount);
                }
            }
            throw new IllegalStateException("Unknown threshold type");
        }
        catch (ReadMetricValueHelper.ReadMetricError e) {
            return new AbstractCheckContext.CheckResult(e.outcome, e.message);
        }
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfigOtherThanColumnsExistence(Dataset dataset) {
        if (this.thresholdType == null) {
            return new RuleValidationError("Threshold type cannot be null");
        }
        if (this.minimumEnabled && this.thresholdType == ThresholdType.MIN_PERCENTAGE && (this.minimum < 0.0 || this.minimum > 100.0)) {
            return new RuleValidationError("Minimum percentage must be between 0 and 100");
        }
        if (this.softMinimumEnabled && this.thresholdType == ThresholdType.MIN_PERCENTAGE && (this.softMinimum < 0.0 || this.softMinimum > 100.0)) {
            return new RuleValidationError("Soft minimum percentage must be between 0 and 100");
        }
        return null;
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Override
    public void accept(FailedRowsExtractRuleVisitor visitor) {
        visitor.visit(this);
    }

    public static enum ThresholdType {
        ENTIRE_COLUMN,
        MIN_COUNT,
        MIN_PERCENTAGE;

    }
}

