/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.projects.importexport.AgentToolsConnectionUtils;
import com.dataiku.dip.projects.importexport.PromptStudioConnectionsUtils;
import com.dataiku.dip.projects.importexport.RetrievableKnowledgeConnectionsUtils;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.SelectableConnectionContainer;
import com.dataiku.dip.savedmodels.proxymodels.ProxyModelConfiguration;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetConnectionUtils {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    private final boolean allowMissingConnections;

    public DatasetConnectionUtils() {
        this(false);
    }

    public DatasetConnectionUtils(boolean allowMissingConnections) {
        this.allowMissingConnections = allowMissingConnections;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Nullable
    private UsedConnection recordConnection(AuthCtx authCtx, String connectionName, boolean withType) throws IOException, DKUSecurityException {
        if (StringUtils.isEmpty((String)connectionName)) {
            return null;
        }
        if (withType) {
            DSSConnection conn = this.connectionsDAO.getConnection(authCtx, connectionName);
            if (conn == null) {
                if (this.allowMissingConnections) {
                    return new UsedConnection(connectionName, null, true);
                }
                throw ErrorContext.iaef((String)"Connection '%s' does not exist", (Object)connectionName, (Object[])new Object[0]);
            }
            return new UsedConnection(connectionName, conn.getType());
        }
        return new UsedConnection(connectionName, null);
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, SerializedDataset sd, boolean withType) throws IOException, DKUSecurityException {
        UsedConnection used;
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        DatasetHandler.DatasetParams params = sd.getParams();
        if (params != null && (used = this.recordConnection(authCtx, params.getConnection(), withType)) != null) {
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, RetrievableKnowledge rk) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        Set<String> referencedConnections = RetrievableKnowledgeConnectionsUtils.listConnectionNames(rk);
        for (String co2 : referencedConnections) {
            UsedConnection used = this.recordConnection(authCtx, co2, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, PromptStudio ps2) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        Set<String> referencedConnections = PromptStudioConnectionsUtils.listConnectionNames(ps2);
        for (String co2 : referencedConnections) {
            UsedConnection used = this.recordConnection(authCtx, co2, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, AgentTool at) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        Set<String> referencedConnections = AgentToolsConnectionUtils.listConnectionNames(at);
        for (String co2 : referencedConnections) {
            UsedConnection used = this.recordConnection(authCtx, co2, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, MLTask mlTask) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        Set<String> referencedConnections = mlTask.getUsedConnections();
        for (String co2 : referencedConnections) {
            UsedConnection used = this.recordConnection(authCtx, co2, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, FullModelId fmi) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        Set<String> referencedConnections = fmi.getUsedConnections();
        for (String co2 : referencedConnections) {
            UsedConnection used = this.recordConnection(authCtx, co2, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, FullModelEvaluationId fme) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        for (String usedConnection : fme.getUsedConnections()) {
            UsedConnection used = this.recordConnection(authCtx, usedConnection, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, StreamingEndpoint se, boolean withType) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        UsedConnection used = this.recordConnection(authCtx, se.getParams().getConnection(), withType);
        if (used != null) {
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, SavedModel sm, boolean withType) throws IOException, DKUSecurityException {
        UsedConnection used;
        assert (TransactionContext.hasAttachedTransaction());
        CodeEnvUsagesService codeEnvUsagesService = (CodeEnvUsagesService)SpringUtils.getBean(CodeEnvUsagesService.class);
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        if (sm.savedModelType.savedModelHandlingType == SavedModel.SavedModelHandlingType.EXTERNAL_MLFLOW && sm.proxyModelConfiguration != null && StringUtils.isNotEmpty((String)sm.proxyModelConfiguration.connection) && (used = this.recordConnection(authCtx, sm.proxyModelConfiguration.connection, withType)) != null) {
            ret.add(used);
        }
        for (FullModelId fmi : codeEnvUsagesService.listFmisInSavedModel(sm)) {
            Set<String> connections = fmi.getUsedConnections();
            for (String connection : connections) {
                UsedConnection used2 = this.recordConnection(authCtx, connection, withType);
                if (used2 == null) continue;
                ret.add(used2);
            }
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, ManagedFolder mf, boolean withType) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        UsedConnection used = this.recordConnection(authCtx, mf.getParams().getConnection(), withType);
        if (used != null) {
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, SerializedRecipe sr) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        RecipeMeta meta = RecipeRegistry.getMeta(sr);
        String payloadOrNull = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
        for (String connectionName : meta.underlyingConnectionNames(sr, payloadOrNull)) {
            UsedConnection used = this.recordConnection(authCtx, connectionName, true);
            if (used == null) continue;
            ret.add(used);
        }
        return ret;
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, Scenario scenario) throws IOException, DKUSecurityException {
        return this.getUsedConnections(authCtx, scenario, scenario);
    }

    public List<UsedConnection> getUsedConnections(AuthCtx authCtx, LambdaService lambdaService) throws IOException, DKUSecurityException {
        return this.getUsedConnections(authCtx, lambdaService, lambdaService);
    }

    private List<UsedConnection> getUsedConnections(AuthCtx authCtx, SelectableConnectionContainer connectionContainer, TaggableObjectsService.TaggableObject taggable) throws IOException, DKUSecurityException {
        assert (TransactionContext.hasAttachedTransaction());
        ArrayList<UsedConnection> ret = new ArrayList<UsedConnection>();
        for (ParamsWithSelectableConnection connectionUser : connectionContainer.collectConnectionUsers()) {
            String connectionName;
            UsedConnection usage = connectionUser.collectConnectionUsage(taggable);
            if (usage == null || ConnectionsDAO.parseVirtualConnection(connectionName = usage.name) != null) continue;
            if (StringUtils.isBlank((String)usage.type)) {
                UsedConnection used = this.recordConnection(authCtx, connectionName, true);
                if (used == null) continue;
                ret.add(used);
                continue;
            }
            ret.add(usage);
        }
        return ret;
    }

    public UsedConnection getSingleUsedConnection(AuthCtx authCtx, SerializedDataset sd) throws IOException, DKUSecurityException {
        List<UsedConnection> ret = this.getUsedConnections(authCtx, sd, true);
        if (ret.size() == 0) {
            throw ErrorContext.iaef((String)"Dataset %s does not use any connection", (Object)sd.name, (Object[])new Object[0]);
        }
        if (ret.size() > 1) {
            throw ErrorContext.iaef((String)"Dataset %s uses multiple connections (%d)", (Object)sd.name, (Object[])new Object[]{ret.size()});
        }
        return ret.get(0);
    }

    public void replaceConnections(SerializedDataset sd, Map<String, String> replacements) {
        if (replacements.size() > 1) {
            throw ErrorContext.iaef((String)"Unexpected multiple connections to replace for dataset %s", (Object)sd.name, (Object[])new Object[0]);
        }
        if (replacements.size() == 1) {
            DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(sd.type);
            JsonObject paramsObj = (JsonObject)JSON.parse((String)JSON.json((Object)sd.getParams()), JsonObject.class);
            JsonPrimitive connection = paramsObj.getAsJsonPrimitive("connection");
            if (connection != null) {
                String target = replacements.get(connection.getAsString());
                if (target == null) {
                    throw ErrorContext.iaef((String)"Did not find connection to remap in dataset %s: %s", (Object)sd.name, (Object[])new Object[]{connection.getAsString()});
                }
                paramsObj.addProperty("connection", target);
            }
            sd.setParams((DatasetHandler.DatasetParams)JSON.parse((String)JSON.json((Object)paramsObj), meta.paramsClass()));
        }
    }

    public void replaceConnections(ManagedFolder mf, Map<String, String> replacements) {
        if (replacements.size() > 1) {
            throw ErrorContext.iaef((String)"Unexpected multiple connections to replace for managed folder %s", (Object)mf.name, (Object[])new Object[0]);
        }
        if (replacements.size() == 1) {
            String connection = mf.params.connection;
            mf.params.connection = replacements.get(connection);
        }
    }

    public void replaceConnections(StreamingEndpoint se, Map<String, String> replacements) {
        if (replacements.size() > 1) {
            throw ErrorContext.iaef((String)"Unexpected multiple connections to replace for streaming endpoint %s", (Object)se.id, (Object[])new Object[0]);
        }
        if (replacements.size() == 1) {
            String connection = se.getParams().getConnection();
            se.getParams().setConnection(replacements.get(connection));
        }
    }

    public void replaceConnections(SavedModel sm, Map<String, String> replacements) {
        if (replacements.size() > 1) {
            throw ErrorContext.iaef((String)"Unexpected multiple connections to replace for saved model", (Object)sm.id, (Object[])new Object[0]);
        }
        if (replacements.size() == 1) {
            if (sm.proxyModelConfiguration == null) {
                throw ErrorContext.iaef((String)"Missing configuration for saved model", (Object)sm.id, (Object[])new Object[0]);
            }
            sm.proxyModelConfiguration.connection = replacements.get(sm.proxyModelConfiguration.connection);
        }
    }

    public void replaceConnections(@Nonnull ProxyModelConfiguration pmc, Map<String, String> replacements, String fmi) {
        if (replacements.size() > 1) {
            throw ErrorContext.iaef((String)"Unexpected multiple connections to replace for proxy model configuration", (Object)fmi, (Object[])new Object[0]);
        }
        if (replacements.size() == 1) {
            pmc.connection = replacements.get(pmc.connection);
        }
    }

    public RecipePayloadParams replaceConnections(SerializedRecipe sr, String payloadOrNull, Map<String, String> replacements) {
        RecipeMeta meta = RecipeRegistry.getMeta(sr);
        return meta.remapConnections(sr, payloadOrNull, replacements);
    }

    public void replaceConnections(Scenario sr, Map<String, String> replacements) {
        this.replaceConnections(sr, sr, replacements);
    }

    public void replaceConnections(LambdaService sr, Map<String, String> replacements) {
        this.replaceConnections(sr, sr, replacements);
    }

    public void replaceConnections(SelectableConnectionContainer container, TaggableObjectsService.TaggableObject taggable, Map<String, String> replacements) {
        if (replacements.size() > 0) {
            for (ParamsWithSelectableConnection connectionUser : container.collectConnectionUsers()) {
                String connectionName;
                UsedConnection usage = connectionUser.collectConnectionUsage(taggable);
                if (usage == null || ConnectionsDAO.parseVirtualConnection(connectionName = usage.name) != null) continue;
                String target = replacements.get(connectionName);
                if (target == null) {
                    throw ErrorContext.iaef((String)"Did not find connection to remap in %s %s: %s", (Object)taggable.getTaggableType().toHumanReadableString(), (Object[])new Object[]{taggable.getId(), connectionName});
                }
                connectionUser.setConnection(target);
            }
        }
    }

    public static class UsedConnection {
        public final String name;
        public final String type;
        public final boolean isMissing;

        public UsedConnection(String name, String type) {
            this(name, type, false);
        }

        public UsedConnection(String name, String type, boolean isMissing) {
            this.name = name;
            this.type = type;
            this.isMissing = isMissing;
        }
    }
}

