/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetInputHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetMeta;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetTestHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBOutput;
import com.dataiku.dip.datasets.dynamodb.PartitionedDynamoDBDatasetInputHandler;
import com.dataiku.dip.datasets.dynamodb.UnpartitionedDynamoDBDatasetInputHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DynamoDBDatasetHandler
implements RowOrientedDatasetHandler {
    public static final DatasetHandler.DatasetMeta<DynamoDBDatasetHandler, Config> META = new DynamoDBDatasetMeta();
    private final AuthCtx authCtx;
    private final Dataset dataset;
    protected final Config config;
    private DynamoDBDatasetInputHandler inputHandler;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public DynamoDBDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.config = (Config)dataset.getParams();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        this.initInputHandler();
        return this.inputHandler.getPartitionSplit(partition);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        this.initInputHandler();
        return this.inputHandler.getFilterSplits(filter);
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        this.initInputHandler();
        return this.inputHandler.getSingleSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        this.initInputHandler();
        return this.inputHandler.getSampleSplit();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public String suggestName() {
        return this.config.table;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        this.initInputHandler();
        return this.inputHandler.listPartitions();
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public void close() {
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException {
        ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, this.config.connection, DynamoDBConnection.class);
        if (StringUtils.isBlank((String)this.config.table)) {
            throw ErrorContext.icef((String)"Missing table for dataset %s", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        if (this.dataset.getPartitioningSchema().isPartitioned() && StringUtils.isBlank((String)this.config.partitioningColumn)) {
            throw ErrorContext.icef((String)"Dataset %s is partitioned, need a partitioning column", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
    }

    @Override
    public long getRecords() throws Exception {
        this.initInputHandler();
        try (DynamoDBConnectionWrapper dynamoConn = this.getNewConnection();){
            DescribeTableResponse describeTableResponse = dynamoConn.client.describeTable(builder -> builder.tableName(this.config.table));
            long count = describeTableResponse.table().itemCount();
            logger.info((Object)("Counting entries for table " + this.config.table + " : " + count));
            long l = count;
            return l;
        }
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        this.initInputHandler();
        return this.inputHandler.computePartitionRecords(p);
    }

    public void updateIndex() throws Exception {
        this.initInputHandler();
        this.inputHandler.updateIndex();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        try {
            this.checkConfiguration();
            this.initInputHandler();
            try (DynamoDBConnectionWrapper dynamoConn = this.getNewConnection();){
                if (dynamoConn.client.listTables().tableNames().contains(this.config.table)) {
                    if (this.dataset.getParams().isNotReadyIfEmpty()) {
                        logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                        DatasetReadiness datasetReadiness = RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                        return datasetReadiness;
                    }
                    DatasetReadiness datasetReadiness = DatasetReadiness.ready(null);
                    return datasetReadiness;
                }
                DatasetReadiness datasetReadiness = DatasetReadiness.notReady(new IOException("Table does not exist : " + this.config.table));
                return datasetReadiness;
            }
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return this.listPartitions().contains(p);
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        this.initInputHandler();
        this.inputHandler.createManaged();
    }

    @Override
    public void clearAllData() throws Exception {
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            logger.info((Object)"Clearing partitions");
            this.clearPartitions(this.listPartitions());
        } else {
            this.clearAllDataAndStructure();
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        this.initInputHandler();
        this.inputHandler.clearPartitions(partitions);
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.getNewConnection();){
            dynamoConn.client.deleteTable(builder -> builder.tableName(this.config.table));
            DynamoDbWaiter dbWaiter = dynamoConn.client.waiter();
            dbWaiter.waitUntilTableNotExists(builder -> builder.tableName(this.config.table));
        }
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new DynamoDBDatasetTestHandler(this.authCtx, this);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        return new DynamoDBOutput(this.authCtx, this.dataset, targetPartition, warningsContext);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    private void initInputHandler() {
        if (this.inputHandler != null) {
            return;
        }
        this.inputHandler = this.dataset.getPartitioningSchema().isPartitioned() ? new PartitionedDynamoDBDatasetInputHandler(this) : new UnpartitionedDynamoDBDatasetInputHandler(this);
    }

    protected DynamoDBConnectionWrapper getNewConnection() throws IOException, DKUSecurityException, CodedException {
        logger.info((Object)("Connecting to database, connection=" + this.config.connection));
        return DynamoDBConnectionWrapper.get(this.authCtx, this.config.connection);
    }

    public static class Config
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public boolean notReadyIfEmpty;
        public String table;
        public boolean partitioned;
        public String partitioningColumn;
        public String explicitPartitionsList;
        public StorageTypeVerifier.DataTypeMismatchBehavior readDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
        public StorageTypeVerifier.DataTypeMismatchBehavior writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }
    }
}

