/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    private ElasticSearchDatasetHandler handler;
    private final AuthCtx authCtx;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.elasticsearch");

    public ElasticSearchDatasetTestHandler(AuthCtx authCtx, ElasticSearchDatasetHandler handler) {
        this.authCtx = authCtx;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    public TestResult test(String projectKey, Dataset dataset, boolean connectionOnly, boolean forConsistencyCheck) throws Exception {
        assert (ElasticSearchDatasetHandler.META.getType().equals(dataset.getType()));
        logger.info((Object)("Testing, dataset = " + dataset.getName() + " connectionOnly = " + connectionOnly));
        TestResult result = new TestResult();
        result.testedConnectionOnly = true;
        if (projectKey != null) {
            try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, dataset);){
                result.suggestedName = DatasetInspector.slufigyAndUnicize(projectKey, dh.suggestName(), this.dao, this.transactionService);
            }
        }
        ElasticSearchDatasetHandler.Config config = dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class);
        ElasticSearchConnection esconn = ConnectionsDAO.get().getMandatoryConnectionAs(this.handler.authCtx, config.connection, ElasticSearchConnection.class);
        try (ElasticSearchHttpClient client = esconn.getHttpClient(this.authCtx, projectKey);){
            ElasticSearchUtils.SearchDistribution distribution;
            HttpResponse resp = client.execute((HttpUriRequest)new HttpGet(esconn.getTestURL()));
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Server didn't answer 200 but " + resp.getStatusLine().getStatusCode() + " " + resp.getStatusLine().getReasonPhrase());
            }
            if (esconn.isAWSOpenSearchServerless()) {
                distribution = ElasticSearchUtils.SearchDistribution.OPEN_SEARCH;
                result.version = " unknown: AWS Serverless";
            } else {
                JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                distribution = ElasticSearchUtils.SearchDistribution.getDistribution(jresp);
                JSONObject version = jresp.getJSONObject("version");
                result.version = version.getString("number");
            }
            result.dialect = distribution.getDialect(result.version);
            result.distributionName = distribution.displayName;
            result.defaultMapping = ElasticSearchUtils.getDefaultMappingDefinition(dataset, result.dialect, SerializedDataset.TypeSystemVersion.V2).toString();
            result.connectionOK = true;
        }
        catch (Exception e) {
            result.connectionOK = false;
            result.connectionErrorMsg = new SerializedError((Throwable)e, true);
            return result;
        }
        if (connectionOnly) {
            return result;
        }
        result.testedConnectionOnly = false;
        ElasticSearchIndex esIndex = this.handler.getEsIndexForced();
        logger.info((Object)"Counting index");
        try {
            assert (esIndex != null && !esIndex.rootIndex.isEmpty()) : "Index name or index pattern name is invalid: null or empty";
            result.empty = esIndex.count() == 0L;
        }
        catch (AssertionError | Exception e) {
            logger.warn((Object)"Error counting index", (Throwable)e);
            result.empty = true;
            result.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            result.indexErrorMsg = new SerializedError((Throwable)e, true);
            return result;
        }
        logger.info((Object)"Gathering documents preview");
        try {
            Schema schemaToCompare = this.inferSchemaFromElasticSearchMapping(result, esIndex.rootIndex);
            this.fixupPartitionedSchema(schemaToCompare, dataset);
            Pair<SchemaDetection.SchemaDetectionResult, MemTable> res = DatasetUtils.simpleDetectSchema(this.authCtx, dataset, forConsistencyCheck, schemaToCompare);
            result.schemaDetection = (SchemaDetection.SchemaDetectionResult)res.first;
            SerializedMemTableSimple smt = new SerializedMemTableSimple();
            smt.fromMemTable((MemTable)res.second, 0, ((MemTable)res.second).nrows());
            result.preview = smt;
        }
        catch (Exception e) {
            String index = "/" + esIndex.rootIndex + "/" + esIndex.type;
            logger.warn((Object)("Error getting preview for " + index + ": "), (Throwable)e);
            result.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            result.indexErrorMsg = new SerializedError((Throwable)e, true);
        }
        return result;
    }

    private void fixupPartitionedSchema(Schema schema, Dataset dataset) {
        if (dataset.isManaged() && dataset.getPartitioningSchema().isPartitioned()) {
            for (String col : dataset.getPartitioningSchema().getDimensionNames()) {
                logger.info((Object)("Ignoring partition column '" + col + "' in schema comparison"));
                schema.removeColumn(col);
            }
        }
    }

    private Schema inferSchemaFromElasticSearchMapping(TestResult result, String index) throws IOException, DKUSecurityException {
        ElasticSearchIndex.InferredSchemaWithStats inferredSchemaWithStats = this.handler.getEsIndexForced().inferSchemaFromMapping(index);
        if (!inferredSchemaWithStats.multipleFieldTypes.isEmpty()) {
            result.multipleFieldTypesMessage = "Multiple types for fields: " + String.join((CharSequence)", ", inferredSchemaWithStats.multipleFieldTypes) + ", falling back to 'string'.";
        }
        return inferredSchemaWithStats.inferredSchema;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(this.handler.getDataset().getProjectKey(), this.handler.getDataset(), false, true);
        ret.empty = result.empty;
        ret.result = result.schemaDetection;
        if (ret.result != null && StringUtils.isNotBlank((String)result.multipleFieldTypesMessage)) {
            ret.result.setWarningLevel(SchemaDetection.WarningLevel.WARN);
            ret.result.textReasons.add(result.multipleFieldTypesMessage);
        } else if (ret.result == null) {
            ret.result = new SchemaDetection.SchemaDetectionResult();
            ret.result.setWarningLevel(SchemaDetection.WarningLevel.FATAL);
            if (!result.connectionOK) {
                ret.result.textReasons.add(result.connectionErrorMsg.message);
            } else if (result.previewErrorMsg != null) {
                ret.result.textReasons.add(result.previewErrorMsg);
            }
        }
        return ret;
    }

    public Map<String, Integer> listIndicesWithCount() throws Exception {
        ElasticSearchIndex esIndex = this.handler.getEsIndexNoCheck();
        return esIndex.listIndicesWithCount();
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        InfoMessage.InfoMessages ret = FSDatasetUtils.checkDatasetName(newDatasetName);
        try {
            ElasticSearchIndex esIndex = this.handler.getEsIndexForced();
            if (esIndex.indexOrAliasExist(esIndex.rootIndex)) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Index or alias '%s' already exists", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with elasticsearch: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public String defaultMapping;
        public boolean connectionOK;
        public String version;
        public ElasticSearchDialect dialect;
        public String distributionName;
        public SerializedError connectionErrorMsg;
        public boolean empty;
        public String multipleFieldTypesMessage;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
        public String previewErrorMsg;
        public SerializedMemTableSimple preview;
        public SerializedError indexErrorMsg;
    }
}

