/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.HighlightedMemRow;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDeleteOutputProcessor;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchManagedPartitionUtils;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUnmanagedPartitionUtils;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.HttpDeleteWithBody;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticSearchIndex
implements AutoCloseable {
    public static final ContentType REQ_CONTENT_TYPE = ContentType.create((String)"application/json", (String)"UTF-8");
    public static final int BULK_INDEX_ACTION_SIZE = ApplicationConfigurator.getParams().getIntParam("dku.datasets.elasticsearch.bulkIndexActionSize", Integer.valueOf(10));
    public static final long DEFAULT_FRAME = ApplicationConfigurator.getParams().getLongParam("dku.datasets.elasticsearch.defaultFrame", 10000L);
    public static final String SCROLL_TIMEOUT = ApplicationConfigurator.getParams().getParam("dku.datasets.elasticsearch.scrollTimeout", "1m");
    static final String ELASTIC_SEARCH_HIGHLIGHT_START_TAG = "__dku_hls";
    static final String ELASTIC_SEARCH_HIGHLIGHT_END_TAG = "__dku_hle";
    public final String address;
    public final ElasticSearchDialect dialect;
    public final String rootIndex;
    public final String type;
    public final String typeUrl;
    public final long frameSize;
    private final String customQueryDSL;
    private final ElasticSearchDatasetHandler.ReadTemporalMode readTemporalMode;
    public final boolean isManaged;
    final Dataset dataset;
    final boolean partitioned;
    final PartitioningScheme partitioningScheme;
    final String partitioningColumn;
    final String partitioningIndexPattern;
    final ElasticSearchDatasetHandler.UnmananagedPartitioningType unmanagedPartitioningType;
    final ElasticSearchConnection connection;
    final ElasticSearchHttpClient client;
    public final long refreshWaitDelayMs;
    public final long refreshWaitMaxDelayMs;
    public final long concurrentDeleteDelayMs;
    public final long maxRetriesOnDeleteIndex;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.elasticsearch");

    public ElasticSearchIndex(AuthCtx authCtx, ElasticSearchConnection esConnection, ElasticSearchDatasetHandler.Config config, Dataset dataset) {
        this.connection = esConnection;
        try {
            this.client = this.connection.getHttpClient(authCtx, dataset.getProjectKey());
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to init ES client", e);
        }
        this.address = this.connection.getServerAddress();
        this.dialect = this.connection.params.dialect;
        this.dataset = dataset;
        this.isManaged = dataset.isManaged();
        this.type = config.type;
        this.customQueryDSL = config.customQueryDsl;
        this.readTemporalMode = config.readTemporalMode;
        if (this.dialect.hasType) {
            Object typeUrl = this.type;
            try {
                typeUrl = "/" + URLEncoder.encode(this.type, ElasticSearchUtils.CHARSET.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.typeUrl = typeUrl;
        } else {
            this.typeUrl = "";
        }
        this.frameSize = config.frameSize;
        if (this.frameSize <= 0L) {
            throw new IllegalArgumentException("Frame size must be > 0, is " + this.frameSize);
        }
        this.partitioningScheme = dataset.getPartitioningSchema();
        boolean bl = this.partitioned = this.partitioningScheme != null && this.partitioningScheme.isPartitioned();
        if (!dataset.isManaged()) assert (this.partitioned == config.partitioned);
        if (this.partitioned && !dataset.isManaged()) {
            switch (config.unmanagedPartitioningType) {
                case COLUMN: {
                    this.partitioningIndexPattern = null;
                    this.partitioningColumn = config.partitioningColumn;
                    assert (this.partitioningScheme.getDimensionNames().size() == 1);
                    assert (StringUtils.isNotBlank((String)this.partitioningColumn)) : "partitioning column is empty";
                    assert (StringUtils.isNotBlank((String)((String)this.partitioningScheme.getDimensionNames().get(0)))) : "first partition dimension is empty";
                    assert (((String)this.partitioningScheme.getDimensionNames().get(0)).equals(this.partitioningColumn)) : "first partition dimension and partition columns are different";
                    this.rootIndex = config.index;
                    break;
                }
                case INDEX: {
                    this.partitioningColumn = null;
                    this.partitioningIndexPattern = config.partitioningIndexPattern;
                    assert (StringUtils.isNotBlank((String)this.partitioningIndexPattern)) : "partitioning index pattern is empty";
                    String expandedPattern = ElasticSearchUnmanagedPartitionUtils.substitutePartitionIdentifierInPathForSuggestedName(config.partitioningIndexPattern, this.partitioningScheme);
                    this.rootIndex = ElasticSearchUtils.normalizeName(expandedPattern, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported partitioning type: " + String.valueOf((Object)config.unmanagedPartitioningType));
                }
            }
            this.unmanagedPartitioningType = config.unmanagedPartitioningType;
        } else {
            this.partitioningColumn = null;
            this.partitioningIndexPattern = null;
            this.unmanagedPartitioningType = null;
            this.rootIndex = config.index;
        }
        Params params = this.connection.getDkuPropertiesAsParams();
        this.refreshWaitMaxDelayMs = params.getLongParam("dku.connection.elasticsearch.refreshMaxWaitDelayMs", 90000L);
        this.refreshWaitDelayMs = params.getLongParam("dku.connection.elasticsearch.refreshWaitDelayMs", 20000L);
        this.concurrentDeleteDelayMs = params.getLongParam("dku.connection.elasticsearch.concurrentDeleteDelayMs", 500L);
        this.maxRetriesOnDeleteIndex = params.getLongParam("dku.connection.elasticsearch.maxRetriesOnDeleteIndex", 5L);
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexOrAliasExist(String index) throws Exception {
        HttpResponse check = this.execute((HttpUriRequest)new HttpGet(this.address + index + "?ignore_unavailable=false"), false, "Couldn't fetch index or alias " + index, 404);
        try {
            boolean bl = this.checkIndexAliasExistResponse(check);
            return bl;
        }
        finally {
            EntityUtils.consume((HttpEntity)check.getEntity());
        }
    }

    private boolean checkIndexAliasExistResponse(HttpResponse check) {
        return check.getStatusLine().getStatusCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Boolean, Boolean> indexExistsWithAlias(String index, @Nullable String alias) throws Exception {
        boolean wantsAlias = !StringUtils.isBlank((String)alias);
        boolean indexExists = false;
        Boolean aliasExists = wantsAlias ? Boolean.valueOf(false) : null;
        HttpResponse check = this.execute((HttpUriRequest)new HttpGet(this.address + index + "/" + this.dialect.getAliasesURLSuffix + "?ignore_unavailable=false"), false, "Couldn't fetch alias list for index " + index, 404);
        try {
            indexExists = this.checkIndexAliasExistResponse(check);
            if (indexExists) {
                JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(check.getEntity().getContent()));
                if (jresp.length() == 1 && ((String)jresp.keys().next()).equals(index)) {
                    if (wantsAlias) {
                        aliasExists = jresp.getJSONObject(index).getJSONObject("aliases").has(alias);
                    }
                } else if (wantsAlias && !alias.equals(index)) {
                    throw new IOException("Index " + index + " is already an alias");
                }
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)check.getEntity());
        }
        return new Pair((Object)indexExists, (Object)aliasExists);
    }

    public boolean createIndex(String index, @Nullable String alias) throws Exception {
        boolean wantsAlias = !StringUtils.isBlank((String)alias);
        Pair<Boolean, Boolean> hasIndexAndAlias = this.indexExistsWithAlias(index, alias);
        if (((Boolean)hasIndexAndAlias.first).booleanValue()) {
            if (hasIndexAndAlias.second == Boolean.FALSE) {
                this.execute((HttpUriRequest)new HttpPut(this.address + index + "/_alias/" + alias), true, "Couldn't add alias " + alias + " to index " + index, new int[0]);
                return true;
            }
            return false;
        }
        HttpPut req = new HttpPut(this.address + index);
        if (wantsAlias) {
            JSONObject body = new JSONObject().put("aliases", (Object)new JSONObject().put(alias, (Object)new JSONObject()));
            req.setEntity((HttpEntity)new StringEntity(body.toString(), REQ_CONTENT_TYPE));
        }
        this.execute((HttpUriRequest)req, true, "Could not create index " + index, new int[0]);
        return true;
    }

    public boolean deleteIndexOrIndicesForAlias(String name, boolean isAlias) throws IOException, InterruptedException {
        if (isAlias) {
            return this.deleteIndicesForAlias(name);
        }
        return this.deleteIndex(name);
    }

    public boolean deleteIndex(String index) throws IOException, InterruptedException {
        boolean success;
        HttpDelete req = new HttpDelete(this.address + index);
        HttpResponse resp = this.execute((HttpUriRequest)req, true, "Could not delete index " + index, 404);
        boolean bl = success = resp.getStatusLine().getStatusCode() != 404;
        if (success) {
            this.awaitIfNeeded();
        }
        return success;
    }

    public boolean deleteIndicesForAlias(String alias) throws IOException, InterruptedException {
        Iterator<String> indices = this.getIndicesForAlias(alias).iterator();
        if (!indices.hasNext()) {
            return false;
        }
        boolean indexDeleted = false;
        while (indices.hasNext()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < BULK_INDEX_ACTION_SIZE && indices.hasNext(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(indices.next());
            }
            String indexBatch = buf.toString();
            HttpDelete req = new HttpDelete(this.address + indexBatch);
            HttpResponse resp = this.execute((HttpUriRequest)req, true, "Could not delete indices " + indexBatch, 404);
            if (resp.getStatusLine().getStatusCode() == 404) continue;
            indexDeleted = true;
        }
        if (indexDeleted) {
            this.awaitIfNeeded();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIndicesForAlias(String alias) throws IOException {
        HttpResponse resp = this.execute((HttpUriRequest)new HttpGet(this.address + this.dialect.getAliasesURLSuffix + "/" + alias), false, "Can't fetch index aliases", 404);
        try {
            if (resp.getStatusLine().getStatusCode() == 404) {
                LinkedList linkedList = Lists.newLinkedList();
                return linkedList;
            }
            JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
            ArrayList arrayList = Lists.newArrayList((Iterator)jresp.keys());
            return arrayList;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    public boolean deleteDocsExternal() throws Exception {
        if (this.dataset.getPartitioningSchema().isPartitioned() && ElasticSearchDatasetHandler.UnmananagedPartitioningType.INDEX.equals((Object)this.unmanagedPartitioningType)) {
            boolean someDeleted = false;
            for (Partition p : this.listPartitions()) {
                String index = this.getPartitionIndex(p);
                boolean deleted = this.deleteDocs(index);
                someDeleted = deleted || someDeleted;
            }
            return someDeleted;
        }
        return this.deleteDocs(this.rootIndex);
    }

    public boolean deleteDocs(String index) throws Exception {
        boolean success;
        StreamColumnFactory cf = new StreamColumnFactory();
        ElasticSearchDeleteOutputProcessor deleter = new ElasticSearchDeleteOutputProcessor(this, index, (ColumnFactory)cf);
        long del = this.executePush(index, this.typeUrl, PushMode.META_ONLY, null, deleter, (ColumnFactory)cf, (RowFactory)new StreamRowFactory(), null, null, new WarningsContext(), new ESQueryBuilder());
        deleter.lastRowEmitted();
        logger.infoV("Deleted %d rows from /%s%s", new Object[]{del, index, this.typeUrl});
        boolean bl = success = del > 0L;
        if (success) {
            this.awaitIfNeeded();
        }
        return success;
    }

    public void updateMapping(String index) throws Exception {
        assert (this.dataset.isManaged());
        HttpPut req = new HttpPut(this.address + index + "/_mapping" + this.typeUrl + (this.dialect.hasIgnoreMappingConflicts ? "?ignore_conflicts=true" : ""));
        SerializedDataset.TypeSystemVersion version = this.dataset.getTypeSystemVersion();
        String mapping = ElasticSearchUtils.getMappingDefinition(this.dataset, this.dialect, version).toString();
        req.setEntity((HttpEntity)new StringEntity(mapping, REQ_CONTENT_TYPE));
        logger.debug((Object)("Set mapping: " + mapping));
        this.execute((HttpUriRequest)req, true, "Mapping update failed on: /" + index + this.typeUrl, new int[0]);
    }

    public InferredSchemaWithStats inferSchemaFromMapping(String index) throws IOException {
        InferredSchemaWithStats inferredSchemaWithStats = new InferredSchemaWithStats();
        inferredSchemaWithStats.mappingStats = this.getMappingDefinitionFromIndex(index);
        for (Map.Entry<String, FieldTypeMappingStats> entry : inferredSchemaWithStats.mappingStats.fieldStats.entrySet()) {
            SchemaColumn col;
            FieldTypeMappingStats fieldStats = entry.getValue();
            if (fieldStats.types.size() == 1) {
                TypeAndFormat fieldType = fieldStats.types.iterator().next();
                Type schemaType = ElasticSearchUtils.getDSSTypeFromESType(fieldType, this.readTemporalMode);
                col = new SchemaColumn(entry.getKey(), schemaType);
                if (schemaType == Type.OBJECT && fieldStats.objectType != null) {
                    col.objectFields = FieldTypeMappingStats.convertObjectFields(fieldStats.objectType, this.readTemporalMode);
                }
            } else {
                logger.info((Object)("Multiple ElasticSearch types for field '" + entry.getKey() + "' on index '" + index + "'"));
                inferredSchemaWithStats.multipleFieldTypes.add(entry.getKey());
                col = new SchemaColumn(entry.getKey(), Type.STRING);
            }
            inferredSchemaWithStats.inferredSchema.getColumns().add(col);
        }
        return inferredSchemaWithStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElasticSearchMappingStats getMappingDefinitionFromIndex(String index) throws IOException {
        HttpGet req = new HttpGet(this.address + index + "/_mapping" + this.typeUrl);
        HttpResponse resp = this.execute((HttpUriRequest)req, false, "Mapping get failed on: /" + index + this.typeUrl, new int[0]);
        try {
            JSONObject mapping = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
            Iterator indexesIter = mapping.keys();
            ElasticSearchMappingStats ret = new ElasticSearchMappingStats();
            ret.indexCount = mapping.length();
            while (indexesIter.hasNext()) {
                String currentIndex = (String)indexesIter.next();
                JSONObject rootMapping = mapping.getJSONObject(currentIndex).getJSONObject("mappings");
                if (this.dialect.hasType) {
                    rootMapping = rootMapping.getJSONObject(this.type);
                }
                if (!rootMapping.has("properties")) {
                    logger.warn((Object)("No mapping found for '" + currentIndex + "', skipping"));
                    continue;
                }
                JSONObject properties = rootMapping.getJSONObject("properties");
                Iterator it = properties.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!ret.fieldStats.containsKey(key)) {
                        ret.fieldStats.put(key, new FieldTypeMappingStats());
                    }
                    FieldTypeMappingStats stats = ret.fieldStats.get(key);
                    JSONObject field = properties.getJSONObject(key);
                    if (field.has("type")) {
                        stats.add(TypeAndFormat.fromField(field));
                        continue;
                    }
                    if (field.has("properties")) {
                        stats.objectType = field.getJSONObject("properties");
                    }
                    stats.add(new TypeAndFormat("object", null));
                }
            }
            ElasticSearchMappingStats elasticSearchMappingStats = ret;
            return elasticSearchMappingStats;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    public void empty() throws Exception {
        if (this.dataset.isManaged()) {
            this.deleteIndexOrIndicesForAlias(this.rootIndex, this.dataset.getPartitioningSchema().isPartitioned());
        } else {
            this.deleteDocsExternal();
        }
    }

    public boolean supportsFlushAndRefresh() {
        return !this.connection.isAWSOpenSearchServerless();
    }

    public boolean supportsScrollSearch() {
        return !this.connection.isAWSOpenSearchServerless();
    }

    public boolean supportsConcurrentDeleteIndex() {
        return !this.connection.isAWSOpenSearchServerless();
    }

    private void flush(String index, boolean ignoreNotExist) throws IOException {
        if (this.supportsFlushAndRefresh()) {
            this.execute((HttpUriRequest)new HttpPost(this.address + index + "/_flush"), true, "Couldn't flush index " + index, ignoreNotExist ? 404 : 200);
        }
    }

    private void refresh(String index, boolean ignoreNotExist) throws IOException {
        if (this.supportsFlushAndRefresh()) {
            this.execute((HttpUriRequest)new HttpPost(this.address + index + "/_refresh"), true, "Couldn't refresh index " + index, ignoreNotExist ? 404 : 200);
        }
    }

    public void refreshAndFlush(String index, boolean ignoreNotExist) throws IOException {
        this.refresh(index, ignoreNotExist);
        this.flush(index, ignoreNotExist);
    }

    public void addPartitions(List<Partition> partitions) throws Exception {
        if (!this.dataset.isManaged()) {
            return;
        }
        for (Partition p : partitions) {
            this.createIndex(this.getPartitionIndex(p), this.rootIndex);
            this.updateMapping(this.getPartitionIndex(p));
        }
    }

    public void removePartitions(List<Partition> partitions) throws Exception {
        if (this.dataset.isManaged()) {
            for (Partition p : partitions) {
                this.deleteIndex(this.getPartitionIndex(p));
            }
        } else {
            StreamColumnFactory cf = new StreamColumnFactory();
            for (Partition p : partitions) {
                String index = this.getPartitionIndex(p);
                ElasticSearchDeleteOutputProcessor deleter = new ElasticSearchDeleteOutputProcessor(this, index, (ColumnFactory)cf);
                this.executePush(index, this.typeUrl, PushMode.META_ONLY, p, deleter, (ColumnFactory)cf, (RowFactory)new StreamRowFactory(), null, null, new WarningsContext(), new ESQueryBuilder());
                deleter.lastRowEmitted();
            }
        }
    }

    public Map<String, Integer> listIndicesWithCount() throws Exception {
        return ElasticSearchUtils.listIndicesWithCount(this.client, this.address, this.rootIndex);
    }

    public List<Partition> listPartitions() throws Exception {
        List<Object> partitions = !this.partitioned ? Lists.newArrayList((Object[])new Partition[]{new Partition(null)}) : (this.dataset.isManaged() ? ElasticSearchManagedPartitionUtils.listPartitionsManaged(this) : ElasticSearchUnmanagedPartitionUtils.listPartitionsExternal(this, PartitionableHandler.MAX_PARTITIONS + 1L));
        if ((long)partitions.size() > PartitionableHandler.MAX_PARTITIONS) {
            throw new DataStoreIOException("Maximum number of partitions has been reached (current limit is " + PartitionableHandler.MAX_PARTITIONS + " partitions).");
        }
        return partitions;
    }

    public long count() throws Exception {
        return this.count(this.rootIndex);
    }

    public long count(String index) throws Exception {
        return this.count(index, new ArrayList<Partition>());
    }

    public long count(Partition partition) throws Exception {
        if (!this.partitioned || partition == null) {
            return this.count();
        }
        if (this.dataset.isManaged()) {
            return this.count(this.getPartitionIndex(partition), new ArrayList<Partition>());
        }
        ArrayList<Partition> partitionsAsField = new ArrayList<Partition>();
        if (ElasticSearchDatasetHandler.UnmananagedPartitioningType.COLUMN.equals((Object)this.unmanagedPartitioningType)) {
            partitionsAsField.add(partition);
        }
        return this.count(this.getPartitionIndex(partition), partitionsAsField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElasticSearchCount countWithShards(String index, List<Partition> partitionsAsField, @Nullable WarningsContext warningsContext) throws Exception {
        String queryDSL = this.removeSourceIfPresent(this.customQueryDSL);
        ESQueryBuilder queryBuilder = new ESQueryBuilder(null, queryDSL);
        JSONObject query = queryBuilder.buildQueryString(partitionsAsField, this);
        String countUri = this.dialect.getBaseUrl(this.address, index, this.typeUrl) + "/_count";
        ElasticSearchUtils.HttpGetWithEntity req = new ElasticSearchUtils.HttpGetWithEntity(countUri);
        req.setEntity((HttpEntity)new StringEntity(query.toString(), REQ_CONTENT_TYPE));
        logger.info((Object)("Sending count to index with parsed custom query: " + String.valueOf(query)));
        int allowedStatusCodes = this.dataset.isManaged() || warningsContext != null ? 404 : -1;
        HttpResponse resp = this.execute((HttpUriRequest)req, false, "Couldn't get count for index " + index, allowedStatusCodes);
        try {
            ElasticSearchCount res = new ElasticSearchCount();
            if (resp.getStatusLine().getStatusCode() == 404) {
                String message = "Elasticsearch index or type not found: " + countUri;
                if (warningsContext != null) {
                    warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, message, logger);
                } else {
                    logger.warn((Object)message);
                }
                ElasticSearchCount elasticSearchCount = res;
                return elasticSearchCount;
            }
            JSONObject response = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
            res.count = response.getLong("count");
            if (res.count > 0L) {
                res.shards = response.getJSONObject("_shards").getInt("total");
            }
            ElasticSearchCount elasticSearchCount = res;
            return elasticSearchCount;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    private long count(String index, List<Partition> partitionsAsField) throws Exception {
        return this.countWithShards((String)index, partitionsAsField, null).count;
    }

    private String removeSourceIfPresent(String queryDSL) {
        if (StringUtils.isBlank((String)queryDSL)) {
            return queryDSL;
        }
        JSONObject obj = new JSONObject(queryDSL);
        if (obj.has("_source")) {
            obj.remove("_source");
        }
        return obj.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected long executePush(String index, String typeUrl, PushMode pushMode, @Nullable Partition partitionField, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext, ESQueryBuilder esQueryBuilder) throws Exception {
        long rowsBefore = listener == null ? 0L : listener.getReadRecords();
        long maxRows = limit == null || limit.maxRecords <= 0L ? Long.MAX_VALUE : limit.maxRecords;
        long frameRows = Math.min(maxRows, this.frameSize);
        String baseUri = this.dialect.getBaseUrl(this.address, index, typeUrl);
        if (esQueryBuilder.customQueryDSL != null && this.dialect == ElasticSearchDialect.ES_LE_2) {
            throw new IllegalArgumentException("Custom Queries are not supported for this ES version");
        }
        ArrayList<Partition> partitionsAsFields = new ArrayList<Partition>();
        if (this.partitioned && partitionField != null && !this.dataset.isManaged() && ElasticSearchDatasetHandler.UnmananagedPartitioningType.COLUMN.equals((Object)this.unmanagedPartitioningType)) {
            partitionsAsFields.add(partitionField);
        }
        ElasticSearchCount countResult = this.countWithShards(index, partitionsAsFields, warningsContext);
        long rowsCounted = countResult.count;
        if (rowsCounted == 0L) {
            logger.info((Object)("No document in index " + index + (String)(this.dialect.hasType ? " for type " + typeUrl : "")));
            return 0L;
        }
        if ((frameRows /= (long)Math.max(countResult.shards, 1)) == 0L) {
            logger.warn((Object)"Sharding bigger than frame size");
            frameRows = 1L;
        }
        logger.info((Object)("Fetching up to " + maxRows + " records in " + countResult.shards + " shards"));
        try (DatasetIterator datasetIterator = DatasetIterator.from(this, baseUri, frameRows, esQueryBuilder, partitionsAsFields);){
            ElasticSearchResultsReader reader = new ElasticSearchResultsReader(pushMode, rowsBefore, cf);
            reader.parseColumns(this.dataset, this, index);
            long max = Math.min(datasetIterator.totalHits(), maxRows);
            boolean done = false;
            while (!done && datasetIterator.hasNextHits()) {
                JSONArray hits = datasetIterator.nextHits();
                done = reader.pushHits(out, rf, hits, max, listener, false);
            }
            if (reader.rowsPushed != rowsCounted && reader.rowsPushed != max) {
                if (warningsContext != null) {
                    warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_COUNT_MISMATCH, "Count reported " + rowsCounted + " rows but pushed " + reader.rowsPushed, logger);
                } else {
                    logger.warn((Object)("Count reported " + rowsCounted + " rows but pushed " + reader.rowsPushed));
                }
            }
            long l = reader.rowsPushed;
            return l;
        }
    }

    private void awaitIfNeeded() throws InterruptedException {
        if (!this.supportsFlushAndRefresh()) {
            Thread.sleep(this.refreshWaitDelayMs);
        }
    }

    HttpResponse execute(HttpUriRequest req, boolean consume, String errorPrefix, int ... okStatusCodes) throws IOException {
        return this.client.execute(req, consume, errorPrefix, okStatusCodes);
    }

    public String getPartitionIndex(@Nullable Partition p) {
        if (p == null || !this.partitioned || p.isAll()) {
            return this.rootIndex;
        }
        if (!this.dataset.isManaged()) {
            switch (this.unmanagedPartitioningType) {
                case COLUMN: {
                    return this.rootIndex;
                }
                case INDEX: {
                    return ElasticSearchUnmanagedPartitionUtils.resolvePartitionIdentifierInPattern(this.partitioningIndexPattern, p, this.dataset.getPartitioningSchema());
                }
            }
            throw new IllegalArgumentException("Unsupported partition type: " + String.valueOf((Object)this.unmanagedPartitioningType));
        }
        return this.rootIndex + ElasticSearchManagedPartitionUtils.encodePartitionDimensions(p);
    }

    public Partition getCanonicalPartition(Partition p) {
        return ElasticSearchManagedPartitionUtils.getIndexPartition(this, this.getPartitionIndex(p));
    }

    public JSONObject getPartitionFilter(List<Partition> partitions, boolean addToRoot) throws JSONException {
        if (partitions.isEmpty() || !this.partitioned || this.dataset.isManaged() || !ElasticSearchDatasetHandler.UnmananagedPartitioningType.COLUMN.equals((Object)this.unmanagedPartitioningType)) {
            return null;
        }
        return ElasticSearchUnmanagedPartitionUtils.getPartitionFilter(partitions, this.partitioningColumn, addToRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractiveSearchResults getSearchDocumentsFrom(DSSAuthCtx user, ESQueryBuilder queryBuilder, boolean trackTotalHits) throws Exception {
        InteractiveSearchResults interactiveSearchResults;
        if (this.dialect != ElasticSearchDialect.ES_7) {
            throw new IllegalArgumentException("Only ES_7 dialect is supported, found: " + String.valueOf((Object)this.dialect));
        }
        InteractiveSearchResults results = new InteractiveSearchResults();
        String index = this.rootIndex;
        List<Partition> partitionsAsField = new ArrayList<Partition>();
        ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery = queryBuilder.searchQuery;
        if (searchQuery.datasetSelection != null && searchQuery.datasetSelection.partitionSelectionMethod != DatasetSelection.PartitionSelectionMethod.ALL) {
            if (this.dataset.isManaged()) {
                index = ElasticSearchManagedPartitionUtils.buildSearchPartitionIndex(this, user, searchQuery, results);
            } else {
                switch (this.unmanagedPartitioningType) {
                    case COLUMN: {
                        assert (this.partitioned) : "a partition scheme was given on a non partitioned dataset";
                        List<String> partitionsStrs = searchQuery.datasetSelection.getPartitionIds(user, this.dataset);
                        partitionsAsField = PartitionFactory.fromPartitionSpec(this.dataset.getPartitioningSchema(), String.join((CharSequence)",", partitionsStrs));
                        break;
                    }
                    case INDEX: {
                        index = ElasticSearchUnmanagedPartitionUtils.buildSearchPartitionIndex(this, user, searchQuery, results);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown partitioning type:" + String.valueOf((Object)this.unmanagedPartitioningType));
                    }
                }
            }
        }
        if (StringUtils.isBlank((String)index)) {
            return results;
        }
        JSONObject jcustomQuery = queryBuilder.buildQueryString(partitionsAsField, this);
        queryBuilder.addHighlightParams(jcustomQuery);
        queryBuilder.addSortParams(jcustomQuery);
        jcustomQuery.put("from", searchQuery.from);
        jcustomQuery.put("size", searchQuery.size);
        if (searchQuery.from == 0 && trackTotalHits) {
            jcustomQuery.put("track_total_hits", trackTotalHits);
        }
        ElasticSearchUtils.HttpGetWithEntity req = new ElasticSearchUtils.HttpGetWithEntity(this.dialect.getBaseUrl(this.address, index, this.typeUrl) + "/_search");
        req.setEntity((HttpEntity)new StringEntity(jcustomQuery.toString(), REQ_CONTENT_TYPE));
        HttpResponse resp = this.execute((HttpUriRequest)req, false, "Couldn't get results for index '" + index + "' and query: " + String.valueOf(jcustomQuery), this.dataset.isManaged() ? 404 : -1, 400);
        try {
            JSONObject jsonResult = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
            results.parse(jsonResult);
            interactiveSearchResults = results;
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume((HttpEntity)resp.getEntity());
                throw throwable;
            }
            catch (Exception e) {
                logger.info((Object)("Couldn't get results for index '" + index + "' and query: " + String.valueOf(jcustomQuery)), (Throwable)e);
                throw e;
            }
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return interactiveSearchResults;
    }

    public static enum PushMode {
        ALL_COLUMNS,
        SCHEMA_COLUMNS,
        META_ONLY;

    }

    public static class ESQueryBuilder {
        PaginatedInteractiveSearchQuery searchQuery;
        JSONObject customQueryDSL;

        public ESQueryBuilder() {
        }

        public ESQueryBuilder(String searchQuery, String customQueryDSL) {
            if (StringUtils.isNotBlank((String)customQueryDSL)) {
                this.customQueryDSL = new JSONObject(customQueryDSL);
            }
            if (StringUtils.isNotBlank((String)searchQuery)) {
                this.searchQuery = new PaginatedInteractiveSearchQuery();
                this.searchQuery.queryString = searchQuery;
            }
        }

        public ESQueryBuilder(PaginatedInteractiveSearchQuery searchQuery, JSONObject customQueryDSL) {
            this.searchQuery = searchQuery;
            this.customQueryDSL = customQueryDSL;
        }

        private boolean isEmpty() {
            return this.customQueryDSL == null && this.searchQuery == null;
        }

        private JSONObject buildSearchQueryString() {
            if (this.searchQuery.isEmpty()) {
                return new JSONObject().put("match_all", (Object)new JSONObject());
            }
            return new JSONObject().put("query_string", (Object)new JSONObject().put("query", (Object)this.searchQuery.queryString));
        }

        JSONObject buildQueryString(List<Partition> partitionsAsField, ElasticSearchIndex elasticSearchIndex) {
            if (!partitionsAsField.isEmpty() && this.isEmpty() && elasticSearchIndex.dialect.hasRootFilter) {
                assert (!elasticSearchIndex.dataset.isManaged() && ElasticSearchDatasetHandler.UnmananagedPartitioningType.COLUMN.equals((Object)elasticSearchIndex.unmanagedPartitioningType)) : "field-based partitioned is not supported on managed dataset";
                return elasticSearchIndex.getPartitionFilter(partitionsAsField, elasticSearchIndex.dialect.hasRootFilter);
            }
            JSONObject jcustomQuery = new JSONObject();
            if (this.customQueryDSL != null) {
                assert (!elasticSearchIndex.dataset.isManaged()) : "custom DSL is not supported on managed dataset";
                jcustomQuery = new JSONObject(this.customQueryDSL.toString());
            }
            boolean queryMovedToFilterArray = false;
            if (!partitionsAsField.isEmpty()) {
                queryMovedToFilterArray = true;
                JSONArray boolQuery = this.moveQueryAsBoolFilter(jcustomQuery);
                this.addPartitionsFieldToFilterArray(boolQuery, partitionsAsField, elasticSearchIndex);
            }
            if (this.searchQuery == null) {
                return jcustomQuery;
            }
            if (elasticSearchIndex.dialect != ElasticSearchDialect.ES_7) {
                throw new IllegalArgumentException("Only ES_7 dialect is supported, found: " + String.valueOf((Object)elasticSearchIndex.dialect));
            }
            JSONObject searchQueryJSON = this.buildSearchQueryString();
            if (!jcustomQuery.has("query")) {
                jcustomQuery.put("query", (Object)searchQueryJSON);
            } else {
                if (!queryMovedToFilterArray) {
                    this.moveQueryAsBoolFilter(jcustomQuery);
                }
                assert (jcustomQuery.getJSONObject("query").keySet().size() == 1 && jcustomQuery.getJSONObject("query").has("bool")) : "query String has invalid format: " + String.valueOf(jcustomQuery);
                jcustomQuery.getJSONObject("query").getJSONObject("bool").put("must", (Object)searchQueryJSON);
            }
            return jcustomQuery;
        }

        private void addPartitionsFieldToFilterArray(JSONArray boolQuery, List<Partition> partitions, ElasticSearchIndex elasticSearchIndex) {
            assert (elasticSearchIndex.partitioned && !elasticSearchIndex.dataset.isManaged()) : "field-based partitioned is not supported on managed or unpartitioned dataset";
            JSONObject boolPartitionFilter = elasticSearchIndex.getPartitionFilter(partitions, true);
            assert (boolPartitionFilter != null);
            logger.info((Object)("Adding with partition filter on field to query: " + String.valueOf(boolPartitionFilter)));
            boolQuery.put(boolPartitionFilter.get("filter"));
        }

        private JSONArray moveQueryAsBoolFilter(JSONObject body) {
            if (!body.has("query")) {
                body.put("query", (Object)new JSONObject());
            }
            JSONObject query = body.getJSONObject("query");
            JSONArray array = new JSONArray();
            Iterator it = query.keys();
            while (it.hasNext()) {
                String queryKey = (String)it.next();
                array.put((Object)new JSONObject().put(queryKey, query.get(queryKey)));
            }
            body.put("query", (Object)new JSONObject().put("bool", (Object)new JSONObject().put("filter", (Object)array)));
            logger.info((Object)("ES Query after moving sub-queries in filter is now:" + String.valueOf(body)));
            return array;
        }

        public void addSortParams(JSONObject jcustomQuery) {
            if (this.searchQuery.sortParameters == null || this.searchQuery.sortParameters.isEmpty()) {
                return;
            }
            JSONArray sortParams = new JSONArray();
            for (PaginatedInteractiveSearchQuery.SortParameter sortParameter : this.searchQuery.sortParameters) {
                if (StringUtils.isBlank((String)sortParameter.column) || StringUtils.isBlank((String)sortParameter.order)) continue;
                sortParams.put((Object)new JSONObject().put(sortParameter.column, (Object)sortParameter.order));
            }
            sortParams.put((Object)"_score");
            jcustomQuery.put("sort", (Object)sortParams);
        }

        public void addHighlightParams(JSONObject jcustomQuery) {
            if (this.searchQuery == null || this.searchQuery.isEmpty()) {
                return;
            }
            JSONObject highlightParams = new JSONObject().put("fields", (Object)new JSONObject().put("*", (Object)new JSONObject()));
            highlightParams.put("pre_tags", (Object)new JSONArray((Object)new String[]{ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_START_TAG}));
            highlightParams.put("post_tags", (Object)new JSONArray((Object)new String[]{ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_END_TAG}));
            highlightParams.put("number_of_fragments", 0);
            JSONObject query = jcustomQuery.getJSONObject("query");
            JSONObject searchQueryJSON = this.buildSearchQueryString();
            if (!query.toString().equals(searchQueryJSON.toString())) {
                highlightParams.put("highlight_query", (Object)searchQueryJSON);
            }
            jcustomQuery.put("highlight", (Object)highlightParams);
        }

        public static class PaginatedInteractiveSearchQuery
        extends DatasetExploreSettings.InteractiveSearchQuery {
            public List<SortParameter> sortParameters;
            public int size;
            public int from;

            public static class SortParameter {
                String column;
                String order;
            }
        }
    }

    public static class InferredSchemaWithStats {
        public ElasticSearchMappingStats mappingStats;
        public List<String> multipleFieldTypes = new ArrayList<String>();
        public Schema inferredSchema = new Schema();
    }

    static class ElasticSearchMappingStats {
        public Map<String, FieldTypeMappingStats> fieldStats = new LinkedHashMap<String, FieldTypeMappingStats>();
        public int indexCount;

        ElasticSearchMappingStats() {
        }
    }

    static class FieldTypeMappingStats {
        Set<TypeAndFormat> types = new HashSet<TypeAndFormat>();
        JSONObject objectType = null;
        int inIndexCount = 0;

        FieldTypeMappingStats() {
        }

        void add(TypeAndFormat type) {
            this.types.add(type);
            ++this.inIndexCount;
        }

        static List<SchemaColumn> convertObjectFields(JSONObject obj, ElasticSearchDatasetHandler.ReadTemporalMode readTemporalMode) {
            ArrayList<SchemaColumn> ret = new ArrayList<SchemaColumn>();
            for (String key : obj.keySet()) {
                SchemaColumn col;
                JSONObject field = obj.getJSONObject(key);
                if (field.has("type")) {
                    Type schemaType = ElasticSearchUtils.getDSSTypeFromESType(TypeAndFormat.fromField(field), readTemporalMode);
                    col = new SchemaColumn(key, schemaType);
                    ret.add(col);
                    continue;
                }
                if (!field.has("properties")) continue;
                JSONObject subFields = field.getJSONObject("properties");
                col = new SchemaColumn(key, Type.OBJECT);
                col.objectFields = FieldTypeMappingStats.convertObjectFields(subFields, readTemporalMode);
                ret.add(col);
            }
            return ret;
        }
    }

    static class TypeAndFormat {
        public String type;
        public String format;

        TypeAndFormat(String type, String format) {
            this.type = type;
            this.format = format;
        }

        static TypeAndFormat fromField(JSONObject field) {
            String type = field.getString("type");
            String format = field.has("format") ? field.getString("format") : null;
            return new TypeAndFormat(type, format);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndFormat that = (TypeAndFormat)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.format, that.format);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.format);
        }
    }

    private static class ElasticSearchCount {
        long count;
        int shards;

        private ElasticSearchCount() {
        }
    }

    private static interface DatasetIterator
    extends AutoCloseable {
        public boolean hasNextHits() throws IOException;

        public JSONArray nextHits() throws IOException;

        public long totalHits() throws IOException;

        public static DatasetIterator from(ElasticSearchIndex index, String baseUri, long frameRows, ESQueryBuilder esQueryBuilder, List<Partition> partitionsAsFields) {
            if (index.supportsScrollSearch()) {
                return new DatasetScrollIterator(index, baseUri, frameRows, esQueryBuilder, partitionsAsFields);
            }
            return new DatasetSearchAfterIterator(index, baseUri, frameRows, esQueryBuilder, partitionsAsFields);
        }
    }

    public static class ElasticSearchResultsReader {
        public static final String INDEX_COLUMN = "__index";
        ColumnFactory cf;
        private final Map<String, Type> columns = new LinkedHashMap<String, Type>();
        long rowsPushed = 0L;
        private final PushMode pushMode;
        private final long rowsBefore;

        public ElasticSearchResultsReader(PushMode pushMode, long rowsBefore, ColumnFactory cf) {
            this.pushMode = pushMode;
            this.rowsBefore = rowsBefore;
            this.cf = cf;
        }

        public void parseColumns(Dataset dataset, ElasticSearchIndex esIndex, String index) throws IOException {
            List cols;
            Schema schema = dataset.getSchema();
            List list = cols = this.pushMode == PushMode.SCHEMA_COLUMNS && schema != null ? schema.getColumns() : null;
            if (cols != null) {
                for (SchemaColumn c2 : cols) {
                    this.columns.put(c2.getName(), c2.getType());
                }
            } else {
                for (String col : esIndex.getMappingDefinitionFromIndex((String)index).fieldStats.keySet()) {
                    this.columns.put(col, null);
                }
            }
            if (this.pushMode != PushMode.META_ONLY) {
                for (String column : this.columns.keySet()) {
                    this.cf.column(column);
                }
            }
        }

        public boolean pushHits(ProcessorOutput out, RowFactory rf, JSONArray hits, long maxHits, @Nullable InputSplitProgressListener listener, boolean addIndexInfo) throws Exception {
            this.checkSchemaAndResultsHaveColumns(hits);
            for (int i = 0; i < hits.length(); ++i) {
                JSONObject hit = hits.getJSONObject(i);
                JSONObject doc = hit.getJSONObject("_source");
                Row r = rf.row();
                if (this.pushMode == PushMode.META_ONLY) {
                    r.put(this.cf.column("_id"), hit.getString("_id"));
                    r.put(this.cf.column("_index"), hit.getString("_index"));
                } else {
                    for (Map.Entry<String, Type> column : this.columns.entrySet()) {
                        Type t = column.getValue();
                        String columnName = column.getKey();
                        JSONObject highlight = hit.optJSONObject("highlight");
                        Column col = this.cf.column(columnName);
                        Object value = doc.opt(columnName);
                        String v = ElasticSearchUtils.getValueAsDSSString(value, t);
                        if (r instanceof HighlightedMemRow && highlight != null && highlight.has(columnName)) {
                            HighlightedMemRow hlr = (HighlightedMemRow)r;
                            Object hlValue = highlight.getJSONArray(columnName).get(0);
                            String highlightedValue = ElasticSearchUtils.getValueAsDSSString(hlValue, t);
                            if (highlightedValue == null) {
                                r.put(col, v);
                                continue;
                            }
                            List<int[]> indices = ElasticSearchResultsReader.extractHighlightedMatches(highlightedValue);
                            hlr.put(col, v, indices);
                            continue;
                        }
                        r.put(col, v);
                    }
                }
                if (addIndexInfo) {
                    Column col1 = this.cf.column(INDEX_COLUMN);
                    r.put(col1, hit.getString("_index"));
                }
                ++this.rowsPushed;
                if (listener != null && this.rowsPushed % 50L == 0L) {
                    listener.setData(0L, 0L, this.rowsBefore + this.rowsPushed);
                }
                out.emitRow(r);
                if (this.rowsPushed < maxHits) continue;
                return true;
            }
            return false;
        }

        private void checkSchemaAndResultsHaveColumns(JSONArray hits) {
            if (hits.length() == 0 || !this.columns.isEmpty() || this.pushMode == PushMode.META_ONLY) {
                return;
            }
            JSONObject doc = hits.getJSONObject(0).getJSONObject("_source");
            if (doc.length() > 0) {
                throw new IllegalArgumentException("Invalid number of columns: no column in schema while " + doc.length() + " found in _source");
            }
        }

        static List<int[]> extractHighlightedMatches(String value) {
            int start = value.indexOf(ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_START_TAG, 0);
            int relativeIndexDelta = 0;
            ArrayList<int[]> indices = new ArrayList<int[]>();
            while (start != -1) {
                int end = value.indexOf(ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_END_TAG, start);
                int startIndex = start - relativeIndexDelta;
                int endIndex = end - (relativeIndexDelta += ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_START_TAG.length());
                relativeIndexDelta += ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_END_TAG.length();
                indices.add(new int[]{startIndex, endIndex});
                start = value.indexOf(ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_START_TAG, end + ElasticSearchIndex.ELASTIC_SEARCH_HIGHLIGHT_END_TAG.length());
            }
            return indices;
        }
    }

    public static class InteractiveSearchResults {
        WarningsContext warningsContext = new WarningsContext();
        public JSONObject hits;

        public void parse(JSONObject r) throws IOException {
            if (!r.has("error")) {
                this.hits = r.getJSONObject("hits");
            } else {
                this.parseError(r.getJSONObject("error"));
            }
        }

        private void parseError(JSONObject error) throws IOException {
            String errorType = error.getString("type");
            if (StringUtils.equals((String)"index_not_found_exception", (String)errorType)) {
                this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, error.getString("reason"), logger);
            } else if (StringUtils.equals((String)"search_phase_execution_exception", (String)errorType)) {
                JSONArray failedShards = error.getJSONArray("failed_shards");
                for (int i = 0; i < failedShards.length(); ++i) {
                    JSONObject failedShard = failedShards.getJSONObject(i);
                    try {
                        JSONObject reason = failedShard.getJSONObject("reason");
                        if (reason.has("caused_by")) {
                            JSONObject cause = reason.getJSONObject("caused_by");
                            if (!StringUtils.equals((String)"parse_exception", (String)cause.getString("type")) || this.warningsContext.hasWarningType(WarningsContext.WarningType.INPUT_ELASTICSEARCH_BAD_QUERY)) continue;
                            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_BAD_QUERY, cause.getString("reason"), logger);
                            continue;
                        }
                        if (!reason.getString("reason").startsWith("Result window is too large") || this.warningsContext.hasWarningType(WarningsContext.WarningType.INPUT_ELASTICSEARCH_RESULT_WINDOW_TOO_LARGE)) continue;
                        String warningText = "The request returned an error: " + reason.getString("reason");
                        this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_RESULT_WINDOW_TOO_LARGE, warningText, logger);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Error while parsing JSON object: " + String.valueOf(failedShard)), (Throwable)e);
                    }
                }
            }
            if (this.warningsContext.getTotalCount() == 0) {
                throw new IOException("Couldn't get results for query: " + String.valueOf(error));
            }
        }
    }

    private static class DatasetSearchAfterIterator
    implements DatasetIterator {
        private final ElasticSearchIndex index;
        private final ESQueryBuilder esQueryBuilder;
        private final List<Partition> partitionsAsFields;
        private final String searchUri;
        private final String countUri;
        private long totalHits = 0L;
        private boolean totalHitsCounted = false;
        private boolean stop = false;
        private JSONObject lastHit = null;

        DatasetSearchAfterIterator(ElasticSearchIndex index, String baseUri, long frameRows, ESQueryBuilder esQueryBuilder, List<Partition> partitionsAsFields) {
            this.index = index;
            this.esQueryBuilder = esQueryBuilder;
            this.partitionsAsFields = partitionsAsFields;
            this.searchUri = baseUri + "/_search?size=" + frameRows;
            this.countUri = baseUri + "/_count";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long totalHits() throws IOException {
            if (!this.totalHitsCounted) {
                HttpPost countRequest = new HttpPost(this.countUri);
                JSONObject body = this.esQueryBuilder.buildQueryString(this.partitionsAsFields, this.index);
                countRequest.setEntity((HttpEntity)new StringEntity(body.toString(), REQ_CONTENT_TYPE));
                HttpResponse resp = this.index.execute((HttpUriRequest)countRequest, false, "Couldn't fetch " + this.countUri, this.index.dataset.isManaged() ? 404 : -1);
                try {
                    if (resp.getStatusLine().getStatusCode() == 200) {
                        JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                        this.totalHits = jresp.getLong("count");
                    }
                    this.totalHitsCounted = true;
                }
                finally {
                    EntityUtils.consume((HttpEntity)resp.getEntity());
                }
            }
            return this.totalHits;
        }

        @Override
        public boolean hasNextHits() {
            return !this.stop;
        }

        private StringEntity makeSearchAfterEntity() {
            JSONObject body = this.esQueryBuilder.buildQueryString(this.partitionsAsFields, this.index);
            body.put("sort", (Object)new JSONArray().put((Object)"_doc"));
            if (this.lastHit != null) {
                body.put("search_after", this.lastHit.get("sort"));
            }
            return new StringEntity(body.toString(), REQ_CONTENT_TYPE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSONArray nextHits() throws IOException {
            HttpPost req = new HttpPost(this.searchUri);
            req.setEntity((HttpEntity)this.makeSearchAfterEntity());
            HttpResponse resp = this.index.execute((HttpUriRequest)req, false, "Couldn't fetch " + this.searchUri, this.index.dataset.isManaged() ? 404 : -1);
            JSONArray hits = null;
            try {
                JSONObject jresp;
                if (resp.getStatusLine().getStatusCode() == 200 && !(hits = (jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()))).getJSONObject("hits").getJSONArray("hits")).isEmpty()) {
                    this.lastHit = hits.getJSONObject(hits.length() - 1);
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
            if (hits == null || hits.isEmpty()) {
                this.stop = true;
            }
            return hits;
        }

        @Override
        public void close() {
        }
    }

    private static class DatasetScrollIterator
    implements DatasetIterator {
        private final ElasticSearchIndex index;
        private final ESQueryBuilder esQueryBuilder;
        private final List<Partition> partitionsAsFields;
        private final String initUri;
        private final String nextUri;
        private String scrollId;
        private long totalHits = 0L;
        private long scrolledHits = 0L;
        private JSONArray firstHits;

        DatasetScrollIterator(ElasticSearchIndex index, String baseUri, long frameRows, ESQueryBuilder esQueryBuilder, List<Partition> partitionsAsFields) {
            this.index = index;
            this.esQueryBuilder = esQueryBuilder;
            this.partitionsAsFields = partitionsAsFields;
            this.initUri = baseUri + "/_search?" + (index.dialect.hasScan ? "search_type=scan&" : "") + "scroll=" + SCROLL_TIMEOUT + "&size=" + frameRows;
            this.nextUri = index.address + "_search/scroll" + (String)(index.dialect.hasScan ? "?scroll=" + SCROLL_TIMEOUT : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initScroll() throws IOException {
            HttpPost initialRequest = new HttpPost(this.initUri);
            JSONObject body = this.esQueryBuilder.buildQueryString(this.partitionsAsFields, this.index);
            if (!this.index.dialect.hasScan) {
                body.put("sort", (Object)new JSONArray().put((Object)"_doc"));
            }
            initialRequest.setEntity((HttpEntity)new StringEntity(body.toString(), REQ_CONTENT_TYPE));
            HttpResponse resp = this.index.execute((HttpUriRequest)initialRequest, false, "Couldn't fetch " + this.initUri, this.index.dataset.isManaged() ? 404 : -1);
            try {
                if (resp.getStatusLine().getStatusCode() == 200) {
                    JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                    this.scrollId = jresp.getString("_scroll_id");
                    this.totalHits = ElasticSearchUtils.getTotal(this.index.dialect, jresp);
                    if (this.totalHits > 0L && !this.index.dialect.hasScan) {
                        this.firstHits = jresp.getJSONObject("hits").getJSONArray("hits");
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }

        @Override
        public long totalHits() throws IOException {
            if (this.scrollId == null) {
                this.initScroll();
            }
            return this.totalHits;
        }

        @Override
        public boolean hasNextHits() throws IOException {
            if (this.scrollId == null) {
                this.initScroll();
            }
            return this.totalHits > this.scrolledHits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSONArray nextHits() throws IOException {
            JSONArray hits;
            if (this.firstHits != null) {
                hits = this.firstHits;
                this.firstHits = null;
            } else {
                HttpResponse resp = null;
                try {
                    HttpPost req = new HttpPost(this.nextUri);
                    String scrollIdParam = this.index.dialect.hasScan ? this.scrollId : new JSONObject().put("scroll", (Object)SCROLL_TIMEOUT).put("scroll_id", (Object)this.scrollId).toString();
                    req.setEntity((HttpEntity)new StringEntity(scrollIdParam, REQ_CONTENT_TYPE));
                    resp = this.index.execute((HttpUriRequest)req, false, "Couldn't fetch scroll batch", new int[0]);
                    JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                    hits = jresp.getJSONObject("hits").getJSONArray("hits");
                }
                finally {
                    if (resp != null) {
                        EntityUtils.consume((HttpEntity)resp.getEntity());
                    }
                }
            }
            if (hits != null) {
                this.scrolledHits += (long)hits.length();
            }
            return hits;
        }

        @Override
        public void close() {
            if (StringUtils.isEmpty((String)this.scrollId)) {
                return;
            }
            try {
                HttpDeleteWithBody req = new HttpDeleteWithBody(this.index.address + "_search/scroll");
                String scrollIdParam = this.index.dialect.hasScan ? this.scrollId : new JSONObject().put("scroll_id", (Object)this.scrollId).toString();
                req.setEntity((HttpEntity)new StringEntity(scrollIdParam, REQ_CONTENT_TYPE));
                this.index.execute((HttpUriRequest)req, true, "Could not clear scroll_id", new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

