/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sample.SampleDatasetDesc;
import com.dataiku.dip.datasets.sample.SampleDatasetMetaDataLogo;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SampleDatasetDescValidator
extends PluginComponentDescValidator {
    private final SampleDatasetDesc desc;
    private final File resourceFolder;
    private final TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.resourcefile");

    public SampleDatasetDescValidator(String componentId, SampleDatasetDesc desc, File resourceFolder, TransactionService transactionService) {
        super(componentId);
        this.desc = desc;
        this.resourceFolder = resourceFolder;
        this.transactionService = transactionService;
    }

    @Override
    public InfoMessage.InfoMessages validate() {
        this.genericValidateMeta(this.desc.meta);
        this.validateLogo();
        this.validateColumns();
        return this.messages;
    }

    private static String invalidExtensionMessage(String logo) {
        int index = logo.lastIndexOf(46);
        return index == -1 ? String.format("Logo file (\"%s\") does not have a file extension.", logo) : String.format("Logo file extension (\"%s\") is not supported.", logo.substring(index));
    }

    private void validateLogo() {
        String logo = this.desc.meta.getLogo();
        if (logo == null) {
            return;
        }
        boolean extensionIsValid = SampleDatasetMetaDataLogo.logoFileExtensionIsValid(logo);
        boolean filenameIsValid = SampleDatasetMetaDataLogo.logoFilenameIsValid(logo);
        if (!extensionIsValid) {
            this.withFatal(SampleDatasetDescValidator.invalidExtensionMessage(logo));
        }
        if (!filenameIsValid) {
            this.withWarning(String.format("Logo filename \"%s\" contains unsupported characters.", logo));
        }
        if (extensionIsValid && filenameIsValid) {
            File logoFile = DKUFileUtils.getWithin((File)this.resourceFolder, (String[])new String[]{logo});
            if (!SampleDatasetMetaDataLogo.logoFileExists(logoFile, logo)) {
                this.withWarning(String.format("Logo file \"resource/%s\" does not exist.", logo));
            } else if (!SampleDatasetMetaDataLogo.logoFileSizeIsValid(logoFile)) {
                this.withWarning(String.format("Logo file \"resource/%s\" exceeds %dMb.", logo, SampleDatasetMetaDataLogo.SIZE_LIMIT_IN_MB));
            }
        }
    }

    private void validateColumns() {
        Set<String> meaningsSet = null;
        try (Transaction t = this.transactionService.beginRead();){
            meaningsSet = ((MeaningsService)SpringUtils.getBean(MeaningsService.class)).listAll().labelsMap.keySet();
        }
        catch (IOException e) {
            logger.warn((Object)"Could not list meanings");
        }
        if (this.desc.columns == null || this.desc.columns.isEmpty()) {
            this.withFatal("Field columns is not set or empty");
        } else {
            this.desc.columns.stream().filter(col -> StringUtils.isBlank((String)col.getName())).findAny().ifPresent(col -> this.withFatal("One or several columns are either unset or empty"));
            this.desc.columns.stream().map(SchemaColumn::getName).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).forEach(colName -> this.withFatal(String.format("Column name is duplicated: \"%s\"", colName)));
            this.desc.columns.stream().filter(col -> col.getTypeString() == null).forEach(col -> this.withFatal(String.format("Type is not set for column: \"%s\"", col.getName())));
            this.desc.columns.stream().filter(col -> col.getTypeString() != null).filter(col -> !Type.exists((String)col.getTypeString())).forEach(col -> this.withFatal(String.format("Type \"%s\" is unknown for column: \"%s\"", col.getTypeString(), col.getName())));
            if (meaningsSet == null) {
                this.withWarning("Could not fetch the list of meanings");
            } else {
                Set<String> finalMeaningsSet = meaningsSet;
                this.desc.columns.stream().filter(col -> col.getMeaning() != null).filter(col -> !finalMeaningsSet.contains(col.getMeaning())).forEach(col -> this.withWarning(String.format("Meaning \"%s\" is unknown for column: \"%s\"", col.getMeaning(), col.getName())));
            }
        }
    }
}

