/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class InsertBatchStatementBuilder {
    private static final Set TABLES_HAVING_STEP_ID_COLUMN_TO_FIX = ImmutableSet.of((Object)"STEP_RUNS", (Object)"JOB", (Object)"FLOW_OBJECT_ACTION", (Object)"FLOW_OBJECT_ACTION_HISTORY");
    private ResultSet fromResultSet;
    private DSSDBConnection connToExternalDB;
    private SQLUtils.SQLTable toTable;
    private SQLDialect toDialect;
    private static final int BATCH_SIZE = 1000;
    private static final int LOG_INTERVAL = 10000;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.db.recordsCopier");

    private InsertBatchStatementBuilder(ResultSet fromResultSet) {
        this.fromResultSet = fromResultSet;
    }

    static InsertBatchStatementBuilder insert(ResultSet fromResultSet) {
        return new InsertBatchStatementBuilder(fromResultSet);
    }

    InsertBatchStatementBuilder to(DSSDBConnection connToExternalDB, SQLUtils.SQLTable toTable, SQLDialect toDialect) {
        this.connToExternalDB = connToExternalDB;
        this.toTable = toTable;
        this.toDialect = toDialect;
        return this;
    }

    void exec(String logPrefix, int targetRecordsCount, String sourceTableName) throws SQLException {
        Columns columns = this.buildSchemaColumns(sourceTableName);
        String qb = InsertQueryBuilder.insertInto(this.toTable).addColumns(columns.toArray()).toSQL(this.toDialect);
        try (PreparedStatement ps2 = this.connToExternalDB.prepareNonPersistedStatement(qb);){
            int i = 0;
            while (this.fromResultSet.next()) {
                for (Column column : columns.get()) {
                    column.insertValue(ps2, this.fromResultSet);
                }
                ps2.addBatch();
                ps2.clearParameters();
                if (++i % 1000 != 0) continue;
                ps2.executeBatch();
                if (i % 10000 != 0) continue;
                logger.debugV(" %s: copied %d / %d records (%.0f %%)", new Object[]{logPrefix, i, targetRecordsCount, Float.valueOf(100.0f * (float)i / (float)targetRecordsCount)});
            }
            if (i % 1000 != 0) {
                ps2.executeBatch();
            }
            this.connToExternalDB.commit();
        }
    }

    private Columns buildSchemaColumns(String sourceTableName) throws SQLException {
        Columns result = new Columns();
        ResultSetMetaData rsmd = this.fromResultSet.getMetaData();
        for (int i = 1; i <= this.fromResultSet.getMetaData().getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i).toUpperCase();
            if (TABLES_HAVING_STEP_ID_COLUMN_TO_FIX.contains(sourceTableName.toUpperCase()) && name.equalsIgnoreCase("STEP_ID")) {
                result.add(new ScenarioStepIdColumn(rsmd, i));
                continue;
            }
            result.add(new Column(rsmd, i));
        }
        return result;
    }

    private static class Columns {
        private List<Column> columnList = new ArrayList<Column>();

        private Columns() {
        }

        private void add(Column column) {
            this.columnList.add(column);
        }

        List<Column> get() {
            return this.columnList;
        }

        SchemaColumn[] toArray() {
            return (SchemaColumn[])FluentIterable.from(this.columnList).transform((Function)new Function<Column, SchemaColumn>(){

                public SchemaColumn apply(Column column) {
                    return column.schemaColumn;
                }
            }).toArray(SchemaColumn.class);
        }
    }

    private class Column {
        int colIndex;
        SchemaColumn schemaColumn;
        int sqlType;

        Column(ResultSetMetaData rsdm, int colIndex) throws SQLException {
            this.sqlType = rsdm.getColumnType(colIndex);
            this.schemaColumn = new SchemaColumn(rsdm.getColumnName(colIndex).toUpperCase(), this.getColumnType(this.sqlType));
            this.colIndex = colIndex;
        }

        void insertValue(PreparedStatement insert, ResultSet rs2) throws SQLException {
            insert.setObject(this.colIndex, rs2.getObject(this.colIndex), this.sqlType);
        }

        private Type getColumnType(int sqlColumnType) {
            switch (sqlColumnType) {
                case 12: {
                    return Type.STRING;
                }
                case 4: {
                    return Type.INT;
                }
                case -5: {
                    return Type.BIGINT;
                }
                case -6: 
                case 5: {
                    return Type.TINYINT;
                }
                case 8: {
                    return Type.DOUBLE;
                }
                case -7: 
                case 16: {
                    return Type.BOOLEAN;
                }
                case 91: 
                case 92: 
                case 93: {
                    return Type.DATE;
                }
            }
            throw new UnsupportedOperationException("Unsupported SQL type: " + sqlColumnType);
        }
    }

    private class ScenarioStepIdColumn
    extends Column {
        ScenarioStepIdColumn(ResultSetMetaData rsdm, int colIndex) throws SQLException {
            super(rsdm, colIndex);
        }

        @Override
        void insertValue(PreparedStatement insert, ResultSet rs2) throws SQLException {
            insert.setObject(this.colIndex, (Object)Step.ensureIdNotOversize(rs2.getString(this.colIndex)), this.sqlType);
        }
    }
}

