/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.sampling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.SilentLimitProcessorOutput;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.signature.DatasetSignatures;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SampleRequest;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleManager {
    @Autowired
    DatasetAccessService datasetAccessService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.sample");

    public Sample createSample_NT(SampleRequest sampleRequest) throws Exception {
        String id;
        TransactionContext.assertNoAttachedTransaction();
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.error((Object)("Started creating new sample from dataset" + sampleRequest.dataset.getFullName()));
        StreamableDatasetSelection selection = sampleRequest.dataSpec.datasetSelection;
        String basicSignature = DatasetSignatures.computeBasicSignature(sampleRequest.dataset, (List<String>)selection.selectedPartitions);
        String contentSignature = DatasetSignatures.computeContentSignature(sampleRequest.authCtx, sampleRequest.dataset, selection.selectedPartitions);
        long computeTime = System.currentTimeMillis();
        while (this.findSample(id = Sample.generateNewSampleId(sampleRequest.dataset, sampleRequest.projectKey)) != null) {
        }
        Sample sample = new Sample(basicSignature, contentSignature, sampleRequest.projectKey, id, computeTime, sampleRequest.dataSpec, sampleRequest.dataset.getSchema(), sampleRequest.containerConfName);
        this.deleteSample(sample);
        try {
            WriteSampleDataFutureThread ft = new WriteSampleDataFutureThread(sampleRequest, sample);
            FutureResponse futureResponse = this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<WrittenSampleInfo>>(){});
            futureResponse = this.futureService.waitForFinalResponse(futureResponse);
            if (futureResponse.result == null) {
                throw new Exception("Failed to write sample data, remote future failed.");
            }
            WrittenSampleInfo writtenSampleInfo = (WrittenSampleInfo)futureResponse.result;
            sample.nbRows = writtenSampleInfo.nWrittenRows;
            sample.isWholeDataset = SampleManager.isSampleWholeDataset(sampleRequest, writtenSampleInfo);
            this.writeSampleMetaFile(sample);
            logger.info((Object)("Sample " + sample.getId() + " created in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create sample " + sample.getId() + " after " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"), (Throwable)e);
            this.deleteSample(sample);
            throw e;
        }
        return sample;
    }

    private static boolean isSampleWholeDataset(SampleRequest request, WrittenSampleInfo info) {
        StreamableDatasetSelection selection = request.dataSpec.datasetSelection;
        if (selection.hasPartition(request.dataset) || selection.hasFilter()) {
            return false;
        }
        if (selection.samplingMethod == SamplingParam.SamplingMethod.FULL) {
            return true;
        }
        if (selection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            return !info.maxRecordLimitOverReached;
        }
        return info.nProcessedRows == info.nWrittenRows;
    }

    public boolean isProvablyOutdated_NT(AuthCtx authCtx, Sample sample) throws InterruptedException, DKUSecurityException, IOException, CodedException {
        Dataset dataset;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getOrNull(sample.getDatasetLoc());
            if (dataset == null) {
                boolean bl = true;
                return bl;
            }
        }
        StreamableDatasetSelection selection = sample.getSelection();
        String contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset, selection.selectedPartitions);
        return !StringUtils.equals((String)contentSignature, (String)sample.getDatasetContentSignature());
    }

    public Sample findSample(String sampleId) {
        if (sampleId == null) {
            return null;
        }
        File metaFile = Sample.metaFile(sampleId);
        return this.readSampleMetaFile(metaFile);
    }

    private static WrittenSampleInfo writeSampleData(SampleRequest request, Sample sample) throws Exception {
        FileUtils.touch((File)sample.getDataFile());
        StreamColumnFactory cf = new StreamColumnFactory();
        ToDatasetStreamer sampleWriter = ToDatasetStreamer.newNonSplittedNonBucketed(request.authCtx, sample.asFakeDataset(), Partition.newNP(), (ColumnFactory)cf, (WarningsContext)new WarningsContext.DummyWarningsContext(), Output.WriteMode.OVERWRITE);
        CountingProcessorOutput counter = new CountingProcessorOutput(sampleWriter.getAsOutput());
        StreamableDatasetSelection datasetSelection = (StreamableDatasetSelection)((Object)JSON.deepCopy((Object)((Object)request.dataSpec.datasetSelection)));
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getContext(sample.getProjectKey());
        FilterDescUtils.expand(datasetSelection.filter, vc);
        boolean maxRecordLimitOverReached = false;
        FilteringProcessorOutput writer = counter;
        SilentLimitProcessorOutput limiter = null;
        if (datasetSelection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            limiter = new SilentLimitProcessorOutput((ProcessorOutput)counter, datasetSelection.maxRecords);
            writer = limiter;
            ++datasetSelection.maxRecords;
        }
        UniversalSingleThreadPusher pusher = UniversalSingleThreadPusher.prepareForCount(request.authCtx, request.dataset, datasetSelection, (ProcessorOutput)writer, (ColumnFactory)cf, (RowFactory)new StreamRowFactory());
        pusher.push();
        writer.lastRowEmitted();
        if (datasetSelection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            maxRecordLimitOverReached = limiter != null && limiter.isLimitOverReached();
            --datasetSelection.maxRecords;
        }
        return new WrittenSampleInfo(pusher.getProcessedRowCount(), counter.getCount(), maxRecordLimitOverReached);
    }

    public synchronized List<Sample> listAllSamples() throws IOException {
        ArrayList<Sample> output = new ArrayList<Sample>();
        for (File file : DKUFileUtils.recursiveListFiles((File)Sample.samplesDir())) {
            Sample sample;
            if (!StringUtils.equals((String)file.getName(), (String)"meta.json") || (sample = this.readSampleMetaFile(file)) == null) continue;
            output.add(sample);
        }
        return output;
    }

    private synchronized Sample readSampleMetaFile(File file) {
        if (!file.isFile()) {
            return null;
        }
        try {
            return (Sample)((Object)JSON.parseFile((File)file, Sample.class));
        }
        catch (JsonParseException | IOException e) {
            logger.error((Object)("Cannot read sample metadata: " + String.valueOf(file)), e);
            return null;
        }
    }

    public synchronized void deleteSample(Sample sample) throws IOException {
        DKUFileUtils.deleteDirectory((File)sample.getSampleDir());
    }

    public synchronized void writeSampleMetaFile(Sample sample) throws IOException {
        File metaFile = Sample.metaFile(sample.getId());
        JSON.prettyToFile((Object)((Object)sample), (File)metaFile);
    }

    private static class WriteSampleDataFutureThread
    extends FutureThread<WrittenSampleInfo> {
        private final FuturePayload futurePayload;
        private SampleRequest request;
        private Sample sample;
        private WrittenSampleInfo writtenSampleInfo;

        public WriteSampleDataFutureThread(SampleRequest request, Sample sample) {
            super(request.authCtx);
            this.request = request;
            this.sample = sample;
            this.futurePayload = WriteSampleDataFutureThread.buildFuturePayload(request, sample);
        }

        private static FuturePayload buildFuturePayload(SampleRequest request, Sample sample) {
            String displayName = "Write sample:" + sample.id + "for dataset " + request.dataset.getFullName() + " with dataset selection " + request.dataSpec.datasetSelection.toString();
            FuturePayload fp = FuturePayload.newSimple((String)"eda_build_sample", (String)"Build EDA sample");
            fp.targets.add(new FuturePayload.FuturePayloadTarget(sample.projectKey, sample.id, displayName, null));
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 1.0;
        }

        public WrittenSampleInfo getResult() {
            return this.writtenSampleInfo;
        }

        public void execute() throws Exception {
            this.writtenSampleInfo = SampleManager.writeSampleData(this.request, this.sample);
        }

        static {
            JSON.registerAdapter(WriteSampleDataFutureThread.class, (Object)new JSON.Adapter<WriteSampleDataFutureThread>(){

                public WriteSampleDataFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SampleRequest request = (SampleRequest)ctx.deserialize(jsonObj.get("request"), SampleRequest.class);
                    Sample sample = (Sample)((Object)ctx.deserialize(jsonObj.get("sample"), Sample.class));
                    return new WriteSampleDataFutureThread(request, sample);
                }

                public JsonElement serialize(WriteSampleDataFutureThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("request", ctx.serialize((Object)ft.request));
                    ret.add("sample", ctx.serialize((Object)ft.sample));
                    return ret;
                }
            });
        }
    }

    private static class WrittenSampleInfo {
        long nProcessedRows;
        long nWrittenRows;
        boolean maxRecordLimitOverReached;

        public WrittenSampleInfo(long nProcessedRows, long nWrittenRows, boolean maxRecordLimitOverReached) {
            this.nProcessedRows = nProcessedRows;
            this.nWrittenRows = nWrittenRows;
            this.maxRecordLimitOverReached = maxRecordLimitOverReached;
        }
    }
}

