/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseTTest;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.compute.stats.VarianceAssumption;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractPairwiseTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class PairwiseTTestCard
extends AbstractPairwiseTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "pairwise_ttest";
    public VarianceAssumption varianceAssumption = VarianceAssumption.EQUAL;
    public AlternativeHypothesis alternative = AlternativeHypothesis.TWO_SIDED;

    public PairwiseTTestCard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups, @Nullable String referenceGroup, VarianceAssumption varianceAssumption, PValueAdjustmentMethod adjustmentMethod, AlternativeHypothesis alternative) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
        this.referenceGroup = referenceGroup;
        this.varianceAssumption = varianceAssumption;
        this.adjustmentMethod = adjustmentMethod;
        this.alternative = alternative;
    }

    private PairwiseTTestCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractPairwiseTestCard.AbstractCompiledPairwiseTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new PairwiseTTest(PairwiseTTestCard.this.xColumn.name, grouping, PairwiseTTestCard.this.referenceGroup != null, PairwiseTTestCard.this.varianceAssumption, PairwiseTTestCard.this.adjustmentMethod, PairwiseTTestCard.this.alternative, PairwiseTTestCard.this.confidenceLevel);
            }

            @Override
            protected PairwiseTTestCardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                PairwiseTTest.PairwiseTTestResult ttest = result.as(PairwiseTTest.PairwiseTTestResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new PairwiseTTestCardResult((List<String>)allWarnings, groups, allGroups, histogramData, ttest.pvalues, ttest.adjustedPvalues, ttest.statistics);
            }
        };
    }

    public static class PairwiseTTestCardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double[] pvalues;
        public double[] adjustedPvalues;
        public double[] statistics;

        public PairwiseTTestCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double[] pvalues, double[] adjustedPvalues, double[] statistics) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalues = pvalues;
            this.adjustedPvalues = adjustedPvalues;
            this.statistics = statistics;
        }

        private PairwiseTTestCardResult() {
        }
    }
}

