/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.STLDecompositionParams;
import com.dataiku.dip.eda.compute.computations.timeseries.STLDecomposition;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.TimeInfoFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;

public class STLDecompositionCard
extends TimeSeriesCard {
    public static final String TYPE = "stl_decomposition";
    public STLDecompositionParams params;
    public boolean showCompactChart = false;
    public SeriesKind[] selectedSeries = SeriesKind.values();

    public STLDecompositionCard(Variable seriesColumn, Variable timeColumn, STLDecompositionParams params) {
        super(seriesColumn, timeColumn);
        this.params = params;
    }

    private STLDecompositionCard() {
    }

    @Override
    protected TimeSeriesComputation getMainComputation() {
        return new STLDecomposition(this.seriesColumn.name, this.timeColumn.name, this.params);
    }

    @Override
    protected TimeSeriesCard.TimeSeriesCardResult buildCardResult(AvailableResult mainComputationResult, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
        STLDecomposition.STLDecompositionResult result = mainComputationResult.as(STLDecomposition.STLDecompositionResult.class);
        return new STLDecompositionCardResult(result, boxPlot, timeInfo);
    }

    public static enum SeriesKind {
        OBSERVED,
        TREND,
        SEASONALITY,
        RESIDUALS;

    }

    public static class STLDecompositionCardResult
    extends TimeSeriesCard.TimeSeriesCardResult {
        public double[] trend;
        public double[] observed;
        public String[] time;
        public double[] seasonal;
        public double[] resid;
        public STLDecomposition.STLDecompositionResult.STLGuessedParams guessedParams;

        public STLDecompositionCardResult(STLDecomposition.STLDecompositionResult result, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
            super(boxPlot, timeInfo);
            this.trend = result.trend;
            this.observed = result.observed;
            this.seasonal = result.seasonal;
            this.resid = result.resid;
            this.time = result.time;
            this.guessedParams = result.guessedParams;
        }

        protected STLDecompositionCardResult() {
        }
    }
}

