/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.worksheets.cards.CDFPlotCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.CategoricalHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.NumericalHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.QuantilesTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateSummaryStatsCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnivariateSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 1) {
            return Collections.emptyList();
        }
        SniffedVariable sniffedVariable = sniffedVariables.get(0);
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        if (sniffedVariable.isLikelyNumerical()) {
            for (NumericalHistogramOption option : NumericalHistogramOption.values()) {
                suggestions.add(this.suggestNumericalHistogram(sniffedVariable, option));
            }
            suggestions.add(this.suggestQuantiles(sniffedVariable));
            suggestions.add(this.suggestNumericalSummaryStats(sniffedVariable));
            suggestions.add(this.suggestCumulativeDistribution(sniffedVariable));
        }
        if (sniffedVariable.isLikelyCategorical()) {
            suggestions.add(this.suggestCategoricalHistogram(sniffedVariable, false));
            if (sniffedVariable.hasEmptyValues()) {
                suggestions.add(this.suggestCategoricalHistogram(sniffedVariable, true));
            }
            suggestions.add(this.suggestCategoricalSummaryStats(sniffedVariable));
            suggestions.add(this.suggestFrequencyTable(sniffedVariable));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestNumericalHistogram(SniffedVariable sniffedVariable, NumericalHistogramOption option) {
        NumericalHistogramCard card = new NumericalHistogramCard().withShowHistogram(option.showHistogram).withShowBoxPlot(option.showBoxPlot);
        card.column = Suggester.toContinuousVariable(sniffedVariable);
        return new SuggestCards.SuggestedCard(option.baseName, card);
    }

    private SuggestCards.SuggestedCard suggestQuantiles(SniffedVariable sniffedVariable) {
        QuantilesTableCard card = new QuantilesTableCard();
        card.column = Suggester.toContinuousVariable(sniffedVariable);
        return new SuggestCards.SuggestedCard("Quantiles", card);
    }

    private SuggestCards.SuggestedCard suggestNumericalSummaryStats(SniffedVariable sniffedVariable) {
        Variable variable = Suggester.toContinuousVariable(sniffedVariable);
        return this.suggestSummaryStats(variable);
    }

    private SuggestCards.SuggestedCard suggestCategoricalSummaryStats(SniffedVariable sniffedVariable) {
        Variable variable = Suggester.toCategoricalVariable(sniffedVariable);
        return this.suggestSummaryStats(variable);
    }

    private SuggestCards.SuggestedCard suggestSummaryStats(Variable variable) {
        UnivariateSummaryStatsCard card = new UnivariateSummaryStatsCard();
        card.column = variable;
        return new SuggestCards.SuggestedCard("Summary stats", card);
    }

    private SuggestCards.SuggestedCard suggestCumulativeDistribution(SniffedVariable sniffedVariable) {
        CDFPlotCard card = new CDFPlotCard();
        card.column = Suggester.toContinuousVariable(sniffedVariable);
        return new SuggestCards.SuggestedCard("Cumulative distribution function", card);
    }

    private SuggestCards.SuggestedCard suggestCategoricalHistogram(SniffedVariable sniffedVariable, boolean filterEmptyValues) {
        CategoricalHistogramCard card = new CategoricalHistogramCard();
        card.column = Suggester.toCategoricalVariable(sniffedVariable);
        if (filterEmptyValues) {
            card.filter = new NotFilter("No empty values", new AnumFilter(sniffedVariable.name, Collections.singleton("")));
        }
        String name = filterEmptyValues ? "Histogram without empty values" : "Histogram";
        return new SuggestCards.SuggestedCard(name, card);
    }

    private SuggestCards.SuggestedCard suggestFrequencyTable(SniffedVariable sniffedVariable) {
        UnivariateFrequencyTableCard card = new UnivariateFrequencyTableCard();
        card.column = Suggester.toCategoricalVariable(sniffedVariable);
        return new SuggestCards.SuggestedCard("Frequency table", card);
    }

    private static enum NumericalHistogramOption {
        SHOW_BOX_PLOT("Box plot", false, true),
        SHOW_BOX_PLOT_AND_HISTOGRAM("Histogram with box plot", true, true);

        String baseName;
        boolean showHistogram;
        boolean showBoxPlot;

        private NumericalHistogramOption(String baseName, boolean showHistogram, boolean showBoxPlot) {
            this.baseName = baseName;
            this.showHistogram = showHistogram;
            this.showBoxPlot = showBoxPlot;
        }
    }
}

