/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.http;

import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLResourceAPIRestDTO;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLResourceProperties;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class AzureMLOnlineDeploymentAPIRestDTO
extends AzureMLResourceAPIRestDTO<AzureMLOnlineDeploymentProperties> {
    public String location;
    public String kind;
    public Map<String, String> tags = new HashMap<String, String>();
    public Sku sku = new Sku();

    private AzureMLOnlineDeploymentAPIRestDTO() {
    }

    public String getModelName() {
        if (StringUtils.isEmpty((CharSequence)((AzureMLOnlineDeploymentProperties)this.properties).model)) {
            return null;
        }
        String[] modelURIParts = ((AzureMLOnlineDeploymentProperties)this.properties).model.split("/");
        if (modelURIParts.length < 4) {
            return null;
        }
        return modelURIParts[modelURIParts.length - 3];
    }

    public String getModelVersion() {
        if (StringUtils.isEmpty((CharSequence)((AzureMLOnlineDeploymentProperties)this.properties).model)) {
            return null;
        }
        String[] modelURIParts = ((AzureMLOnlineDeploymentProperties)this.properties).model.split("/");
        if (modelURIParts.length < 4) {
            return null;
        }
        return modelURIParts[modelURIParts.length - 1];
    }

    public String getEndpointName() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            return null;
        }
        String[] idURIParts = this.id.split("/");
        if (idURIParts.length < 4) {
            return null;
        }
        return idURIParts[idURIParts.length - 3];
    }

    @Override
    public AzureMLResourceIdentifier getResourceIdentifier() {
        return new AzureMLResourceIdentifier(this.name, this.getEndpointName(), this.workspace, this.resourceGroup, this.subscription);
    }

    public static class Sku {
        public int capacity;
        public String family;
        public String name;
        public String size;
        public String tier;
    }

    public static class AzureMLOnlineDeploymentProperties
    extends AzureMLResourceProperties {
        public String model;
        public String environmentId;
        public String instanceType;
        public boolean appInsightsEnabled;
        public String egressPublicNetworkAccess;
        public Map<String, String> environmentVariables = new HashMap<String, String>();
        public ProbeSettings livenessProbe;
        public ProbeSettings readinessProbe;
        public AzureMLOnlineDeployment.DeploymentProvisioningState provisioningState;
    }

    public static class ProbeSettings {
        public String initialDelay;
        public String period;
        public String timeout;
        public int successThreshold;
        public int failureThreshold;
    }
}

